# テスト方針書

## 概要

本ドキュメントは、FreeBSD カーネルおよびユーザーランドソースツリー（freebsd-src-main）におけるテスト方針を定義する。FreeBSD プロジェクトは、OS カーネル、システムライブラリ、ユーザーランドユーティリティを含む大規模な C/アセンブリ/シェル言語ベースのプロジェクトであり、ATF (Automated Testing Framework) および Kyua テストランナーを中心とした包括的なテスト基盤を有する。テストコードはシェルスクリプト（約351ファイル）、C言語（約220ファイル）、Python（約109ファイル）で記述されている。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々のシステムコール、ライブラリ関数、ユーティリティコマンドの正常動作を検証する | 各コンポーネント開発者 |
| 結合テスト | カーネルサブシステム間（ネットワーク、ファイルシステム、セキュリティ等）の連携動作を検証する | サブシステム担当者 |
| システムテスト | FreeBSD OS全体としてのビルド・ブート・基本機能動作を検証する（CI smoke test / full test） | CI/CDインフラチーム |
| 受入テスト | リリースブランチにおけるリグレッション確認、アーキテクチャ横断テストを実施する | リリースエンジニアリングチーム |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | ATF テストケースによるシステムコール、ライブラリ、コマンドの機能検証 | 開発時・CI パイプライン実行時 |
| 性能テスト | カーネルサブシステム（AIO、kqueue、ネットワーク等）のスループット・レイテンシ検証 | リリース前・必要に応じて |
| セキュリティテスト | Capsicum、MAC フレームワーク、audit、ACL 等のセキュリティ機構の動作検証 | 開発時・CI パイプライン実行時 |
| スタイルチェック | style(9) コーディング規約への準拠をPerlスクリプト（checkstyle9.pl）で検証 | Pull Request 作成時（GitHub Actions） |
| カーネルテスト (ktest) | Netlink経由のカーネルモジュールテスト。カーネル内テストモジュールをロードし、Pythonから実行結果を検証する | 開発時・結合テスト時 |
| ファジングテスト | openssh、krb5、libecc等のcontribライブラリに対するCIFuzzによるファジング | CI パイプライン実行時 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 開発者による個別テスト実行 | FreeBSD実機またはVM上でKyuaを直接実行 |
| CI bhyve環境 | amd64/i386アーキテクチャのフルテスト | bhyveハイパーバイザ上にCIイメージをロードして実行。メモリ4GB以上、CPU数はhw.ncpuに依存 |
| CI QEMU環境 | aarch64, armv7, powerpc64, powerpc64le, riscv64のクロスアーキテクチャテスト | QEMU仮想マシン上でCIイメージを実行。アーキテクチャ毎にマシンタイプ・CPU数上限が設定される |
| GitHub Actions | クロスビルド検証およびスタイルチェック | ubuntu-22.04, ubuntu-24.04, macOS-latest上でカーネルビルドを検証 |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| Kyua | テストスイート実行エンジン。Kyuafileによるテストの自動探索・実行・レポート生成を行う | プロジェクト内蔵 |
| ATF (Automated Testing Framework) | テストケース記述フレームワーク。C言語およびシェルスクリプトのテストプログラムインターフェースを提供する | プロジェクト内蔵 |
| pytest | Python テストの実行フレームワーク。ATFとの統合プラグイン（conftest.py / atf_pytest.py）を通じて利用する | Python 3.x 系 |
| bhyve | amd64/i386のCIテスト仮想化基盤 | FreeBSD標準 |
| QEMU | クロスアーキテクチャCIテスト仮想化基盤（qemu-system-*, qemu-*-static） | pkg経由でインストール |
| expect | CIテスト時のVMコンソール操作自動化 | pkg経由でインストール |
| checkstyle9.pl | style(9)コーディング規約チェッカー | プロジェクト内蔵（tools/build/checkstyle9.pl） |
| GitHub Actions | CI/CD ワークフロー実行基盤 | actions/checkout@v4, actions/github-script@v7 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 明示的な数値目標は設定されていない（注：FreeBSD プロジェクトではカバレッジメトリクスよりもテストの品質と網羅性を重視する方針） |
| 分岐カバレッジ | 明示的な数値目標は設定されていない |
| テストスイート対象領域 | カーネルサブシステム（kern, net, netinet, netinet6, netipsec, netlink, netmap, netpfil, netgraph, geom, vm, vfs, kqueue, aio, mqueue, capsicum, mac, audit, opencrypto, cam, sound, ses, fifo, file, posixshm, acl, devrandom, vmm, pjdfstest, cddl, fs, compat32等の38サブシステム） |

## テストデータ

FreeBSD テストスイートにおけるテストデータは以下の方針で管理される。

- **テストプログラム内蔵データ**: 各ATFテストケースが自身のテストデータを生成・管理する。ATFのsetup/cleanup機構により、テストデータの作成・削除が自動化されている。
- **テストヘルパー**: `tests/freebsd_test_suite/macros.h` にテストスイート共通のマクロが定義されている。
- **CIイメージ内データ**: CI環境では、vmimage作成スクリプト（`release/scripts/mk-vmimage.sh`）によりテスト用ディスクイメージを生成する。追加ディスク（最大5台、各128MB）がテスト用に作成される。
- **ATF変数**: `ATFHandler.get_atf_vars()` を通じてテスト実行時の環境変数（ソースディレクトリ、アーキテクチャ情報等）がテストケースに提供される。
- **pytest マーカー**: `require_user`, `require_arch`, `require_diskspace`, `require_files`, `require_machine`, `require_memory`, `require_progs`, `timeout` の各マーカーにより、テスト実行の前提条件を宣言的に記述する。

## 不具合管理

- **Pull Requestチェックリスト**: GitHub Actions の `checklist.yml` ワークフローにより、PR作成時にCommitメッセージの `Signed-off-by` 行の有無・形式、メールアドレスの妥当性が自動検証される。
- **スタイル違反**: `style.yml` ワークフローにより、C/C++ソースファイルに対してstyle(9)準拠チェックが自動実行される。
- **テスト結果レポート**: Kyua の `kyua report` コマンドにより、テスト結果の詳細レポートが生成される。CI環境ではメタデータTARファイル経由でテスト結果が収集される。
- **CODEOWNERS**: `.github/CODEOWNERS` ファイルにより、変更対象ファイルのオーナーが自動通知される。
- **path-rules**: `.github/path-rules.txt` により、特定パスへの変更に対する注意事項が自動表示される。

## CI/CD連携

FreeBSD プロジェクトのCI/CDは以下の構成で運用されている。

### GitHub Actions ワークフロー

1. **Checklist (`checklist.yml`)**: PR作成時にコミットメッセージの形式チェック、CODEOWNERS通知、パスルールチェックを実行する。`pull_request_target` イベントで起動する。
2. **Style Checker (`style.yml`)**: PR作成時にC/C++/アセンブリソースファイルのstyle(9)準拠チェックを実行する。対象ファイル拡張子は `.S`, `.c`, `.cc`, `.cpp`, `.h`, `.hh`, `.hpp`。
3. **Cross-build Kernel (`cross-bootstrap-tools.yml`)**: main, stable/14, stable/13ブランチへのpush時およびPR時に、Ubuntu (22.04/24.04) および macOS 上でamd64/aarch64カーネルのクロスビルドを検証する。clang-15/clang-18を使用する。

### CI テストインフラ (`tests/ci/`)

- **ビルドフェーズ**: `ci-buildworld` -> `ci-buildkernel` -> `ci-buildimage` の順でFreeBSDのワールド、カーネル、テスト用VMイメージをビルドする。
- **テスト実行フェーズ**: ビルドしたVMイメージをbhyve（amd64/i386）またはQEMU（その他アーキテクチャ）上で起動し、Kyuaテストスイートを実行する。
- **テストタイプ**:
  - `ci-smoke`: VMイメージのブート確認（最小テスト）
  - `ci-full`: Kyuaテストスイートのフル実行
- **サポートアーキテクチャ**: amd64, aarch64, armv7, powerpc64, powerpc64le, riscv64
- **タイムアウト**: デフォルト5400秒（90分）。VM起動タイムアウトはexpectコマンドで制御される。
- **メタデータ収集**: テスト結果はメタデータTARファイル（512MB）に格納され、事後分析に利用される。

### テスト階層構造

テストスイートは `/usr/tests/` 以下にソースツリーと同一の階層構造でインストールされる（例：`/usr/src/bin/cp/` -> `/usr/tests/bin/cp/`）。Kyuafileの自動探索機能により、新規テストの追加は対応するディレクトリにKyuafileを配置するだけで完了する。

## 備考

- FreeBSD のテストスイートは `MK_TESTS` ビルドオプションで有効化される。`WITHOUT_TESTS` を `src.conf(5)` に設定することで無効化できる。
- サンドボックス実行がデフォルトで有効（`MK_CHECK_USE_SANDBOX=yes`）。
- テストプログラムはソースコードと同じ場所に配置する方針（例：`src/lib/libcrypt/tests/`）。ただし、横断的テストは `src/tests/` に配置する。
- META_MODE（filemonカーネルモジュール使用）が利用可能な場合、インクリメンタルビルドが有効になる。
- 詳細な利用方法は `man tests` (tests(7)) を参照のこと。
