# ER図

## Kyua テストストア (schema v3)

```mermaid
erDiagram
    metadata {
        INTEGER schema_version PK
        TIMESTAMP timestamp
    }

    contexts {
        TEXT cwd
    }

    env_vars {
        TEXT var_name PK
        TEXT var_value
    }

    metadatas {
        INTEGER metadata_id PK
        TEXT property_name PK
        TEXT property_value
    }

    test_programs {
        INTEGER test_program_id PK
        TEXT absolute_path
        TEXT root
        TEXT relative_path
        TEXT test_suite_name
        INTEGER metadata_id FK
        TEXT interface
    }

    test_cases {
        INTEGER test_case_id PK
        INTEGER test_program_id FK
        TEXT name
        INTEGER metadata_id FK
    }

    test_results {
        INTEGER test_case_id PK
        TEXT result_type
        TEXT result_reason
        TIMESTAMP start_time
        TIMESTAMP end_time
    }

    test_case_files {
        INTEGER test_case_id PK
        TEXT file_name PK
        INTEGER file_id FK
    }

    files {
        INTEGER file_id PK
        BLOB contents
    }

    test_programs ||--o{ test_cases : "has"
    test_cases ||--o| test_results : "has"
    test_cases ||--o{ test_case_files : "outputs"
    test_case_files }o--|| files : "references"
    test_programs }o--o| metadatas : "has metadata"
    test_cases }o--o| metadatas : "has metadata"
```

## WPA / hostapd EAP認証

```mermaid
erDiagram
    users {
        TEXT identity PK
        TEXT methods
        TEXT password
        TEXT remediation
        INTEGER phase2
        INTEGER t_c_timestamp
    }

    wildcards {
        TEXT identity PK
        TEXT methods
    }

    authlog {
        TEXT timestamp
        TEXT session
        TEXT nas_ip
        TEXT username
        TEXT note
    }

    pending_tc {
        TEXT mac_addr PK
        TEXT identity
    }

    current_sessions {
        TEXT mac_addr PK
        TEXT identity
        TEXT start_time
        TEXT nas
        BOOLEAN hs20_t_c_filtering
        BOOLEAN waiting_coa_ack
        BOOLEAN coa_ack_received
    }
```

## WPA / EAP-SIM データベース

```mermaid
erDiagram
    pseudonyms {
        CHAR permanent PK
        CHAR pseudonym
    }

    reauth {
        CHAR permanent PK
        CHAR reauth_id
        INTEGER counter
        CHAR mk
        CHAR k_encr
        CHAR k_aut
        CHAR k_re
    }
```

## WPA / RADIUS サーバ

```mermaid
erDiagram
    radius_attributes {
        INTEGER id PK
        TEXT sta
        TEXT reqtype
        TEXT attr
    }

    sim_provisioning {
        TEXT mobile_identifier_hash PK
        TEXT imsi
        TEXT mac_addr
        TEXT eap_method
        TEXT timestamp
    }
```

## Heimdal HDB SQLiteバックエンド

```mermaid
erDiagram
    Version {
        REAL number
    }

    Principal {
        INTEGER id PK
        TEXT principal
        INTEGER canonical
        INTEGER entry FK
    }

    Entry {
        INTEGER id PK
        BLOB data
    }

    Principal }o--o| Entry : "references"
```

## Heimdal クレデンシャルキャッシュ (scache)

```mermaid
erDiagram
    master {
        INTEGER oid PK
        INTEGER version
        TEXT defaultcache
    }

    caches {
        INTEGER oid PK
        TEXT principal
        TEXT name
    }

    credentials {
        INTEGER oid PK
        INTEGER cid FK
        INTEGER kvno
        INTEGER etype
        INTEGER created_at
        BLOB cred
    }

    principals {
        INTEGER oid PK
        TEXT principal
        INTEGER type
        INTEGER credential_id FK
    }

    caches ||--o{ credentials : "contains"
    credentials ||--o{ principals : "has"
```
