---
generated_at: 2026-02-01 00:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **authlogテーブルのNULL制約**：SQL定義にNOT NULL制約が明記されておらず、NULL許容の推定に根拠が不足
  2. **Heimdal EntryテーブルのBLOB NULL制約**：Cマクロ内のSQL定義からNULL制約の有無を確定できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `contrib/kyua/store/schema_v3.sql` -- Kyua現行スキーマ定義 (v3)
- E-02: `contrib/kyua/store/schema_v2.sql` -- Kyuaスキーマ定義 (v2)
- E-03: `contrib/kyua/store/schema_v1.sql` -- Kyuaスキーマ定義 (v1)
- E-04: `contrib/kyua/store/migrate_v1_v2.sql` -- v1からv2へのマイグレーション
- E-05: `contrib/kyua/store/migrate_v2_v3.sql` -- v2からv3へのマイグレーション
- E-06: `contrib/wpa/hostapd/hostapd.eap_user_sqlite` -- hostapd EAPユーザSQLiteスキーマ
- E-07: `contrib/wpa/src/eap_server/eap_sim_db.c` -- EAP-SIMデータベーステーブル定義 (Cソース内)
- E-08: `contrib/wpa/src/radius/radius_server.c` -- RADIUSサーバデータベーステーブル定義 (Cソース内)
- E-09: `contrib/wpa/src/ap/hostapd.c` -- hostapd RADIUS属性テーブル定義 (Cソース内)
- E-10: `crypto/heimdal/lib/hdb/hdb-sqlite.c` -- Heimdal HDB SQLiteバックエンドスキーマ (Cソース内)
- E-11: `crypto/heimdal/lib/krb5/scache.c` -- Heimdalクレデンシャルキャッシュスキーマ (Cソース内)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Kyuaスキーマは現行v3であり、schema_versionがPRIMARY KEY | E-01 | ○ |
| C-02 | metadataテーブルのtimestampはNOT NULLでCHECK >= 0 | E-01 | ○ |
| C-03 | v3のcontextsテーブルにはcontext_idカラムが存在しない | E-01 | ○ |
| C-04 | v3のenv_varsテーブルのPRIMARY KEYはvar_name | E-01 | ○ |
| C-05 | metadatasテーブルは (metadata_id, property_name) が複合PRIMARY KEY | E-01 | ○ |
| C-06 | test_programsテーブルにabsolute_path, root, relative_path, test_suite_name, metadata_id, interfaceカラムが存在 | E-01 | ○ |
| C-07 | test_casesテーブルはtest_program_idを外部キーとして持つ | E-01 | ○ |
| C-08 | test_resultsテーブルはtest_case_idをPRIMARY KEYかつ外部キーとして持ち、1:1関係 | E-01 | ○ |
| C-09 | test_case_filesテーブルで__STDOUT__と__STDERR__が予約名 | E-01 | ○ |
| C-10 | filesテーブルはfile_id (PK) とcontents (BLOB) を持つ | E-01 | ○ |
| C-11 | v2からv3への変更でactionsテーブルとcontext_id参照が廃止された | E-01, E-02, E-05 | ○ |
| C-12 | v1からv2への変更でmetadatasテーブルが導入された | E-04 | ○ |
| C-13 | v1からv2への変更でatf_test_cases, atf_test_cases_multivalues, plain_test_programsが廃止された | E-04 | ○ |
| C-14 | usersテーブルにidentity (PK), methods, password, remediation, phase2, t_c_timestampカラムが存在 | E-06 | ○ |
| C-15 | wildcardsテーブルにidentity (PK), methodsカラムが存在 | E-06 | ○ |
| C-16 | authlogテーブルにtimestamp, session, nas_ip, username, noteカラムが存在 | E-06 | ○ |
| C-17 | authlogテーブルの各カラムがNULL許容 | E-06 | △ |
| C-18 | pending_tcテーブルにmac_addr (PK), identityカラムが存在 | E-06 | ○ |
| C-19 | current_sessionsテーブルに7カラム (mac_addr PK含む) が存在 | E-06 | ○ |
| C-20 | pseudonymsテーブルにpermanent (PK, CHAR(21)), pseudonym (CHAR(21)) が存在 | E-07 | ○ |
| C-21 | reauthテーブルに7カラム (permanent PK含む) が存在 | E-07 | ○ |
| C-22 | radius_attributesテーブルにid (PK), sta, reqtype, attrが存在 | E-08, E-09 | ○ |
| C-23 | sim_provisioningテーブルに5カラムが存在 | E-08 | ○ |
| C-24 | Heimdal HDB Versionテーブルにnumberカラムのみ | E-10 | ○ |
| C-25 | Heimdal HDB Principalテーブルにid, principal (UNIQUE), canonical, entryカラムが存在 | E-10 | ○ |
| C-26 | Heimdal HDB Entryテーブルにid, dataカラムが存在 | E-10 | ○ |
| C-27 | Heimdal HDB EntryテーブルのdataカラムのNULL許容が不明確 | E-10 | △ |
| C-28 | scache masterテーブルにoid, version, defaultcacheカラムが存在 | E-11 | ○ |
| C-29 | scache cachesテーブルにoid, principal, nameカラムが存在し、削除トリガーCacheDropCredsあり | E-11 | ○ |
| C-30 | scache credentialsテーブルにoid, cid, kvno, etype, created_at, credカラムが存在し、削除トリガーcredDropPrincipalあり | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- authlogテーブルの各カラムにNOT NULL制約が明示されていないため、NULL許容と推定したが、運用上の意図（ログであるため全て任意入力とする設計かどうか）は確認できていない
  - 候補：hostapd設計仕様書 / wpa_supplicant運用ドキュメント / 実行時のINSERT文の分析
- Heimdal HDB EntryテーブルのdataカラムのNULL制約について、CマクロによるSQL定義からは明示的な制約が確認できない
  - 候補：Heimdal HDBの設計文書 / hdb-sqlite.cの実行パス分析

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- Kyuaスキーマv3の定義は `.sql` ファイルに明確に記述されており信頼性が高い
- 0: 低リスク -- WPA hostapd EAPユーザスキーマは `.eap_user_sqlite` ファイルに明確に記述されている
- 1: 中リスク -- WPA EAP-SIM / RADIUSのスキーマはCソース内に埋め込まれており、コンパイル時の条件分岐やバージョン差異により実際のスキーマが異なる可能性がある
- 1: 中リスク -- Heimdal HDB / scacheのスキーマはCマクロで定義されており、プリプロセッサ展開後の実際のSQL文と差異がある可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] Kyuaスキーマv3のテーブル定義が `contrib/kyua/store/schema_v3.sql` と一致しているか
- [ ] WPA hostapd EAPユーザテーブルが `contrib/wpa/hostapd/hostapd.eap_user_sqlite` と一致しているか
- [ ] Cソースコード内に埋め込まれたスキーマ（EAP-SIM, RADIUS, Heimdal）が対応するソースファイルの実際のSQL文と一致しているか
- [ ] NULL制約の記載が各テーブルのCREATE TABLE文と整合しているか
- [ ] ER図のリレーションシップが外部キー制約と一致しているか
- [ ] v1 -> v2 -> v3のマイグレーション経緯の記述が `migrate_v1_v2.sql` および `migrate_v2_v3.sql` と整合しているか
