---
generated_at: 2026-02-01 00:00:00
metrics:
  claims_total: 55
  claims_with_evidence: 55
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：55 / 55、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全項目に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `usr.sbin/periodic/periodic.sh` - periodicフレームワーク本体
- E-02: `usr.sbin/periodic/periodic.conf` - periodic設定ファイル（全バッチのデフォルト有効/無効設定を含む）
- E-03: `usr.sbin/periodic/etc/daily/100.clean-disks` - dailyクリーンアップスクリプト
- E-04: `usr.sbin/periodic/etc/daily/110.clean-tmps` - 一時ファイル削除スクリプト
- E-05: `usr.sbin/periodic/etc/daily/120.clean-preserve` - preserveクリーンアップスクリプト
- E-06: `usr.sbin/periodic/etc/daily/130.clean-msgs` - メッセージ削除スクリプト
- E-07: `usr.sbin/periodic/etc/daily/140.clean-rwho` - rwhoクリーンアップスクリプト
- E-08: `usr.sbin/periodic/etc/daily/150.clean-hoststat` - hoststatパージスクリプト
- E-09: `usr.sbin/periodic/etc/daily/200.backup-passwd` - passwdバックアップスクリプト
- E-10: `usr.sbin/periodic/etc/daily/210.backup-aliases` - aliasesバックアップスクリプト
- E-11: `usr.sbin/periodic/etc/daily/221.backup-gpart` - gpartバックアップスクリプト
- E-12: `usr.sbin/periodic/etc/daily/222.backup-gmirror` - gmirrorバックアップスクリプト
- E-13: `usr.sbin/periodic/etc/daily/223.backup-zfs` - ZFSバックアップスクリプト
- E-14: `usr.sbin/periodic/etc/daily/300.calendar` - calendarスクリプト
- E-15: `usr.sbin/periodic/etc/daily/310.accounting` - アカウンティングスクリプト
- E-16: `usr.sbin/periodic/etc/daily/400.status-disks` - ディスクステータススクリプト
- E-17: `usr.sbin/periodic/etc/daily/401.status-graid` - graidステータススクリプト
- E-18: `usr.sbin/periodic/etc/daily/404.status-zfs` - ZFSステータススクリプト
- E-19: `usr.sbin/periodic/etc/daily/406.status-gmirror` - gmirrorステータススクリプト
- E-20: `usr.sbin/periodic/etc/daily/407.status-graid3` - graid3ステータススクリプト
- E-21: `usr.sbin/periodic/etc/daily/408.status-gstripe` - gstripeステータススクリプト
- E-22: `usr.sbin/periodic/etc/daily/409.status-gconcat` - gconcatステータススクリプト
- E-23: `usr.sbin/periodic/etc/daily/410.status-mfi` - mfiステータススクリプト
- E-24: `usr.sbin/periodic/etc/daily/420.status-network` - ネットワークステータススクリプト
- E-25: `usr.sbin/periodic/etc/daily/430.status-uptime` - uptimeスクリプト
- E-26: `usr.sbin/periodic/etc/daily/440.status-mailq` - mailqスクリプト
- E-27: `usr.sbin/periodic/etc/daily/450.status-security` - dailyセキュリティチェックスクリプト
- E-28: `usr.sbin/periodic/etc/daily/460.status-mail-rejects` - メールリジェクトスクリプト
- E-29: `usr.sbin/periodic/etc/daily/480.leapfile-ntpd` - NTPリープファイルスクリプト
- E-30: `usr.sbin/periodic/etc/daily/480.status-ntpd` - NTPステータススクリプト
- E-31: `usr.sbin/periodic/etc/daily/500.queuerun` - メールキュー実行スクリプト
- E-32: `usr.sbin/periodic/etc/daily/510.status-world-kernel` - world/kernelステータススクリプト
- E-33: `usr.sbin/periodic/etc/daily/800.scrub-zfs` - ZFSスクラブスクリプト
- E-34: `usr.sbin/periodic/etc/daily/801.trim-zfs` - ZFS TRIMスクリプト
- E-35: `usr.sbin/periodic/etc/daily/999.local` - dailyローカルスクリプト
- E-36: `usr.sbin/periodic/etc/weekly/310.locate` - locateデータベース更新スクリプト
- E-37: `usr.sbin/periodic/etc/weekly/320.whatis` - whatisデータベース更新スクリプト
- E-38: `usr.sbin/periodic/etc/weekly/340.noid` - 所有者不明ファイル検索スクリプト
- E-39: `usr.sbin/periodic/etc/weekly/450.status-security` - weeklyセキュリティチェックスクリプト
- E-40: `usr.sbin/periodic/etc/weekly/999.local` - weeklyローカルスクリプト
- E-41: `usr.sbin/periodic/etc/monthly/200.accounting` - 月次アカウンティングスクリプト
- E-42: `usr.sbin/periodic/etc/monthly/450.status-security` - monthlyセキュリティチェックスクリプト
- E-43: `usr.sbin/periodic/etc/monthly/999.local` - monthlyローカルスクリプト
- E-44: `usr.sbin/periodic/etc/security/100.chksetuid` - setuid監査スクリプト
- E-45: `usr.sbin/periodic/etc/security/110.neggrpperm` - ネガティブグループパーミッション監査スクリプト
- E-46: `usr.sbin/periodic/etc/security/200.chkmounts` - マウントポイント監査スクリプト
- E-47: `usr.sbin/periodic/etc/security/300.chkuid0` - UID 0監査スクリプト
- E-48: `usr.sbin/periodic/etc/security/400.passwdless` - パスワード未設定監査スクリプト
- E-49: `usr.sbin/periodic/etc/security/410.logincheck` - ログインチェックスクリプト
- E-50: `usr.sbin/periodic/etc/security/500.ipfwdenied` - ipfw拒否ログスクリプト
- E-51: `usr.sbin/periodic/etc/security/510.ipfdenied` - ipf拒否ログスクリプト
- E-52: `usr.sbin/periodic/etc/security/520.pfdenied` - pf拒否ログスクリプト
- E-53: `usr.sbin/periodic/etc/security/550.ipfwlimit` - ipfw制限スクリプト
- E-54: `usr.sbin/periodic/etc/security/610.ipf6denied` - IPv6 ipf拒否ログスクリプト
- E-55: `usr.sbin/periodic/etc/security/700.kernelmsg` - カーネルメッセージスクリプト
- E-56: `usr.sbin/periodic/etc/security/800.loginfail` - ログイン失敗スクリプト
- E-57: `usr.sbin/periodic/etc/security/900.tcpwrap` - TCP Wrapperスクリプト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 100.clean-disks: 不要ファイルをディスクから削除する | E-02, E-03 | ○ |
| C-02 | 110.clean-tmps: 一時ディレクトリの古いファイルを削除する | E-02, E-04 | ○ |
| C-03 | 120.clean-preserve: /var/preserveの古いファイルを削除する | E-02, E-05 | ○ |
| C-04 | 130.clean-msgs: システムメッセージファイルを削除する | E-02, E-06 | ○ |
| C-05 | 140.clean-rwho: /var/rwhoの古いファイルを削除する | E-02, E-07 | ○ |
| C-06 | 150.clean-hoststat: sendmailホストステータスキャッシュをパージする | E-02, E-08 | ○ |
| C-07 | 200.backup-passwd: passwd/groupファイルのバックアップと差分検出 | E-02, E-09 | ○ |
| C-08 | 210.backup-aliases: メールエイリアスファイルのバックアップ | E-02, E-10 | ○ |
| C-09 | 221.backup-gpart: ディスクパーティションレイアウトのバックアップ | E-02, E-11 | ○ |
| C-10 | 222.backup-gmirror: gmirror listの出力をバックアップ | E-02, E-12 | ○ |
| C-11 | 223.backup-zfs: zpool/zfsリストとプロパティのバックアップ | E-02, E-13 | ○ |
| C-12 | 300.calendar: calendar -aを実行して予定を通知 | E-02, E-14 | ○ |
| C-13 | 310.accounting: プロセスアカウンティングログのローテーションと統計収集 | E-02, E-15 | ○ |
| C-14 | 400.status-disks: ディスク使用状況をdfで確認・報告 | E-02, E-16 | ○ |
| C-15 | 401.status-graid: graid状態を確認・報告 | E-02, E-17 | ○ |
| C-16 | 404.status-zfs: ZFSプール状態を確認・報告 | E-02, E-18 | ○ |
| C-17 | 406.status-gmirror: gmirror状態を確認・報告 | E-02, E-19 | ○ |
| C-18 | 407.status-graid3: graid3状態を確認・報告 | E-02, E-20 | ○ |
| C-19 | 408.status-gstripe: gstripe状態を確認・報告 | E-02, E-21 | ○ |
| C-20 | 409.status-gconcat: gconcat状態を確認・報告 | E-02, E-22 | ○ |
| C-21 | 410.status-mfi: mfiutil RAIDコントローラ状態を確認・報告 | E-02, E-23 | ○ |
| C-22 | 420.status-network: ネットワーク状態をnetstatで確認・報告 | E-02, E-24 | ○ |
| C-23 | 430.status-uptime: システムuptimeを確認・報告 | E-02, E-25 | ○ |
| C-24 | 440.status-mailq: メールキュー状態を確認・報告 | E-02, E-26 | ○ |
| C-25 | 450.status-security (daily): セキュリティチェックを実行 | E-02, E-27 | ○ |
| C-26 | 460.status-mail-rejects: メールリジェクトログを確認・報告 | E-02, E-28 | ○ |
| C-27 | 480.leapfile-ntpd: NTPうるう秒ファイルを取得・更新 | E-02, E-29 | ○ |
| C-28 | 480.status-ntpd: NTPデーモン同期状態を確認・報告 | E-02, E-30 | ○ |
| C-29 | 500.queuerun: メールキューの送信処理を実行 | E-02, E-31 | ○ |
| C-30 | 510.status-world-kernel: userland/kernelバージョン確認・報告 | E-02, E-32 | ○ |
| C-31 | 800.scrub-zfs: ZFSプールのスクラブを実行 | E-02, E-33 | ○ |
| C-32 | 801.trim-zfs: ZFSプールのTRIM処理を実行 | E-02, E-34 | ○ |
| C-33 | 999.local (daily): ローカルカスタムスクリプトを実行 | E-02, E-35 | ○ |
| C-34 | 310.locate (weekly): locateデータベースを再構築 | E-02, E-36 | ○ |
| C-35 | 320.whatis (weekly): whatisデータベースを再構築 | E-02, E-37 | ○ |
| C-36 | 340.noid (weekly): 所有者不明ファイルを検索・報告 | E-02, E-38 | ○ |
| C-37 | 450.status-security (weekly): 週次セキュリティチェックを実行 | E-02, E-39 | ○ |
| C-38 | 999.local (weekly): ローカルカスタムスクリプトを実行 | E-02, E-40 | ○ |
| C-39 | 200.accounting (monthly): ログインアカウンティングを集計・報告 | E-02, E-41 | ○ |
| C-40 | 450.status-security (monthly): 月次セキュリティチェックを実行 | E-02, E-42 | ○ |
| C-41 | 999.local (monthly): ローカルカスタムスクリプトを実行 | E-02, E-43 | ○ |
| C-42 | 100.chksetuid: setuid/setgidファイル変更を検出・報告 | E-02, E-44 | ○ |
| C-43 | 110.neggrpperm: ネガティブグループパーミッションを検出・報告 | E-02, E-45 | ○ |
| C-44 | 200.chkmounts: マウントポイント変更を検出・報告 | E-02, E-46 | ○ |
| C-45 | 300.chkuid0: UID 0アカウントを検出・報告 | E-02, E-47 | ○ |
| C-46 | 400.passwdless: パスワード未設定アカウントを検出・報告 | E-02, E-48 | ○ |
| C-47 | 410.logincheck: ログイン関連の異常を検出・報告 | E-02, E-49 | ○ |
| C-48 | 500.ipfwdenied: ipfw拒否ログを確認・報告 | E-02, E-50 | ○ |
| C-49 | 510.ipfdenied: ipf拒否ログを確認・報告 | E-02, E-51 | ○ |
| C-50 | 520.pfdenied: pf拒否ログを確認・報告 | E-02, E-52 | ○ |
| C-51 | 550.ipfwlimit: ipfwルール制限到達を確認・報告 | E-02, E-53 | ○ |
| C-52 | 610.ipf6denied: IPv6 ipf拒否ログを確認・報告 | E-02, E-54 | ○ |
| C-53 | 700.kernelmsg: カーネルメッセージ異常を確認・報告 | E-02, E-55 | ○ |
| C-54 | 800.loginfail: ログイン失敗を確認・報告 | E-02, E-56 | ○ |
| C-55 | 900.tcpwrap: TCP Wrapperログを確認・報告 | E-02, E-57 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全てのバッチ項目はソースコード（シェルスクリプト）およびperiodic.conf設定ファイルに基づいて記載されている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目がソースコードから直接特定され、デフォルト有効/無効設定もperiodic.confから正確に読み取られている
- 0: 低リスク - サードパーティやlocal_periodicディレクトリに追加される可能性のあるバッチスクリプトは本一覧に含まれていないが、これらは環境依存でありソースコードリポジトリには含まれないため妥当

## 6) レビュアーチェックリスト（最小）
- [ ] daily/weekly/monthly/securityの各カテゴリのスクリプト数がソースコードのファイル数と一致しているか確認
- [ ] 各バッチのデフォルト有効/無効設定がperiodic.confの記載と一致しているか確認
- [ ] 各バッチの説明がスクリプトの実際の処理内容と整合しているか確認
- [ ] local_periodicやportsから追加される可能性のあるバッチが運用上必要かどうか確認
