# バッチ設計書 1-100.clean-disks

## 概要

本ドキュメントは、FreeBSD periodicフレームワークにおける日次ディスククリーンアップバッチ `100.clean-disks` の設計を記述する。本バッチはシステム上の不要ファイル（コアダンプ、一時ファイル等）を定期的に削除し、ディスク容量を維持する。

### 本バッチの処理概要

本バッチは、ファイルシステム全体を走査し、指定されたファイルパターンに合致するファイルのうち、一定日数以上アクセスされていないものを自動的に削除する処理を行う。

**業務上の目的・背景**：長期稼働するFreeBSDシステムにおいて、コアダンプファイル（*.core）、一時ファイル（a.out）、エディタのバックアップファイル（.#*、[#,]*）などの不要ファイルがディスク上に蓄積し、ディスク容量を圧迫する問題がある。本バッチは、これらの不要ファイルを定期的に検出・削除することで、ディスク容量の枯渇を未然に防止し、システムの安定運用を支える。

**バッチの実行タイミング**：日次（daily）。FreeBSD periodicフレームワークにより、通常は毎日深夜帯にcronから実行される。

**主要な処理内容**：
1. `/etc/defaults/periodic.conf` および上書き設定ファイルの読み込み
2. `daily_clean_disks_enable` 変数による有効/無効判定
3. `daily_clean_disks_days` と `daily_clean_disks_files` の必須パラメータ検証
4. ファイルシステム全体（ルート `/` 以下）からローカルファイルシステムのみを対象に、指定パターンのファイルを `find` コマンドで検索
5. 指定日数以上アクセスのないファイルを `rm -df` で削除
6. verbose設定に応じた削除ファイルの出力

**前後の処理との関連**：daily periodicスクリプト群の最初のクリーンアップ処理として実行される。後続の `110.clean-tmps`、`120.clean-preserve` 等と同じクリーンアップカテゴリに属するが、本バッチはファイルシステム全体を対象とする点で他と異なる。

**影響範囲**：ローカルファイルシステム全体が対象。読み取り専用ファイルシステムおよび非ローカルファイルシステムは除外される。削除対象はファイルパターンと経過日数で限定される。

## バッチ種別

データクレンジング（不要ファイル削除）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodic(8)のcron設定に依存（デフォルト: 毎日深夜） |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron経由でperiodic(8)から起動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| periodic.confの存在 | `/etc/defaults/periodic.conf` が読み取り可能であること |
| daily_clean_disks_enable=YES | 明示的に有効化されていること（デフォルトはNO） |
| daily_clean_disks_days設定済 | 削除対象の経過日数が指定されていること |
| daily_clean_disks_files設定済 | 削除対象のファイルパターンが指定されていること |

### 実行可否判定

`daily_clean_disks_enable` が `YES`（大文字小文字不問）の場合のみ実行する。デフォルトは `NO` であるため、管理者が明示的に有効化する必要がある。`daily_clean_disks_days` または `daily_clean_disks_files` が未設定の場合はエラー（rc=2）で終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_clean_disks_enable | 文字列 | Yes | NO | バッチの有効/無効フラグ |
| daily_clean_disks_files | 文字列 | Yes | `[#,]* .#* a.out *.core *.CKP .emacs_[0-9]*` | 削除対象ファイルパターン（スペース区切り） |
| daily_clean_disks_days | 数値 | Yes | 3 | 削除対象とするアクセス経過日数 |
| daily_clean_disks_verbose | 文字列 | No | YES | 削除ファイルの詳細出力 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | デフォルト設定値 |
| /etc/periodic.conf | シェル変数定義 | ユーザ上書き設定 |
| /etc/periodic.conf.local | シェル変数定義 | ローカル上書き設定 |
| ローカルファイルシステム全体 | ファイルシステム | 削除対象ファイルの検索元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 削除されたファイル一覧（verbose時）および処理メッセージ |
| 終了コード | 数値 | 0:成功/変更なし、1:情報あり、2:設定不備、3:実行エラー |

### 出力ファイル仕様

本バッチはファイル出力を行わない。処理結果はperiodic(8)フレームワークにより標準出力経由でメール通知またはログに記録される。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | 標準出力（periodic(8)が制御） |
| 文字コード | システムロケール依存 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.conf を source し、source_periodic_confs で上書き設定を適用
2. 有効/無効判定
   └─ daily_clean_disks_enable が YES かどうかを case 文で判定
3. パラメータ検証
   └─ daily_clean_disks_days が空なら rc=2 でエラー終了
   └─ daily_clean_disks_files が空なら rc=2 でエラー終了
4. findコマンド引数の構築
   └─ daily_clean_disks_files のパターンを -name 引数に変換（スペースを " -o -name " で置換）
5. verboseモード判定
   └─ daily_clean_disks_verbose が YES なら -print オプションを付与
6. ファイル検索・削除実行
   └─ find / で非ローカル・読み取り専用FSを除外し、パターン一致かつ atime > 指定日数のファイルを rm -df で削除
7. 終了コード設定
   └─ verbose無効時は rc=0、有効時は削除行数に基づき rc を設定
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_clean_disks_enable=YES?}
    C -->|No| Z[rc=0で終了]
    C -->|Yes| D{daily_clean_disks_days設定済?}
    D -->|No| E[エラーメッセージ出力, rc=2]
    E --> Z2[終了]
    D -->|Yes| F{daily_clean_disks_files設定済?}
    F -->|No| G[エラーメッセージ出力, rc=2]
    G --> Z2
    F -->|Yes| H[findコマンド引数構築]
    H --> I[find / で検索・削除実行]
    I --> J{verbose?}
    J -->|Yes| K[削除ファイル一覧出力]
    J -->|No| L[rc=0]
    K --> M[削除件数に基づきrc設定]
    M --> Z2
    L --> Z2
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=2 | 設定不備 | daily_clean_disks_days が未設定 | periodic.conf で値を設定する |
| rc=2 | 設定不備 | daily_clean_disks_files が未設定 | periodic.conf で値を設定する |
| rc=1 | 情報通知 | ファイルが削除された（verbose時） | 正常動作。削除内容を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

本バッチはリトライ機構を持たない。失敗時は次回のdaily実行時に再度実行される。findコマンドがパーミッションエラー等で一部ファイルにアクセスできなかった場合でも、アクセス可能なファイルの処理は継続される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作） |
| コミットタイミング | 各ファイルの削除は即時実行 |
| ロールバック条件 | ロールバック不可（削除は不可逆） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ファイルシステム全体の走査（数万〜数百万ファイル） |
| 目標処理時間 | ファイルシステムのサイズに依存（分〜時間単位） |
| メモリ使用量上限 | findコマンドの使用量に依存（通常低い） |

## 排他制御

排他制御の仕組みは実装されていない。同時に複数回実行された場合、find/rmの競合により一部ファイルの削除に失敗する可能性があるが、致命的な問題は発生しない。periodic(8)フレームワークが単一のcronジョブとして実行するため、通常は同時実行は発生しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | "Cleaning disks:" メッセージ |
| 進捗ログ | verbose有効時 | 削除されたファイルのパス一覧 |
| 終了ログ | N/A | 明示的な終了ログなし（終了コードで判断） |
| エラーログ | 設定不備時 | 未設定パラメータに関するエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc >= 2 | periodic(8)の出力先（daily_output設定に依存、デフォルト: root宛メール） |
| 処理時間 | 定義なし | N/A |

## 備考

- デフォルトでは無効（daily_clean_disks_enable=NO）のため、使用する場合は管理者が明示的に有効化する必要がある
- `find` コマンドは `set -f noglob` でグロブ展開を抑制した状態で実行される
- 削除対象はローカルファイルシステムかつ読み書き可能なファイルシステムに限定される（`! -fstype local -o -fstype rdonly` で除外）
- `rm -df` の `-d` フラグによりディレクトリも削除対象となり得る
- ファイルパターンのデフォルト値: `[#,]* .#* a.out *.core *.CKP .emacs_[0-9]*`
