# バッチ設計書 12-300.calendar

## 概要

本ドキュメントは、FreeBSDのperiodicフレームワークにおけるdailyバッチ `300.calendar` の設計仕様を記述する。本バッチは `calendar -a` コマンドを実行し、全ユーザに対して予定・記念日情報を通知する。

### 本バッチの処理概要

本バッチは、FreeBSDに組み込まれた `calendar(1)` コマンドを `-a`（全ユーザ対象）オプション付きで実行し、各ユーザのホームディレクトリにあるcalendarファイルに基づいて予定を通知する処理を行う。

**業務上の目的・背景**：`calendar(1)` はUNIX伝統のスケジュール通知ツールであり、ユーザが `~/.calendar/calendar` ファイルに記載した予定を日次でメール通知する。ただし、ソースコードのコメントにも記述されている通り、ネットワークマウントされたホームディレクトリ環境では問題が生じる可能性があるため、デフォルトでは無効化されている。管理者が必要に応じて有効化することを想定している。

**バッチの実行タイミング**：日次（daily periodic）で実行される。デフォルトでは無効（daily_calendar_enable=NO）。

**主要な処理内容**：
1. periodic.confの設定値を読み込む
2. `daily_calendar_enable` の判定を行う
3. `calendar -a` コマンドを実行し、全ユーザの予定情報を処理する

**前後の処理との関連**：dailyカテゴリの通知・レポート系バッチに位置する。前提バッチや後続バッチへの依存関係はない。独立して動作する。

**影響範囲**：各ユーザのcalendarファイルを読み取り、該当する予定があればメール送信を行う。ファイルシステムの変更は行わない。

## バッチ種別

通知配信

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodicフレームワークの日次実行時刻（デフォルト: 3:01） |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron経由のperiodicフレームワーク |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| daily_calendar_enable | "YES"に設定されていること（デフォルト: NO） |
| calendar(1)コマンド | システムにcalendarコマンドがインストールされていること |

### 実行可否判定

`daily_calendar_enable` が "YES" でない場合、rc=0で正常終了しスキップする。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_calendar_enable | 文字列 | Yes | NO | バッチの有効/無効フラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ~/.calendar/calendar | テキストファイル | 各ユーザのcalendarファイル |
| /etc/calendar/* | テキストファイル | システムワイドのcalendarデータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | "Running calendar:" メッセージ |
| メール | テキスト | 各ユーザへの予定通知メール（calendar -aによる） |

### 出力ファイル仕様

本バッチはファイル出力を行わない。calendar -aコマンドが直接ユーザにメールを送信する。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | N/A |
| 文字コード | N/A |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. periodic.confの読み込み
   └─ /etc/defaults/periodic.confとローカル設定を読み込む
2. daily_calendar_enable判定
   └─ YESでない場合、rc=0で終了
3. "Running calendar:" メッセージ出力
4. calendar -a 実行
   └─ 成功時: rc=0、失敗時: rc=3
5. 終了コード(rc)を返却して終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_calendar_enable=YES?}
    C -->|No| D[スキップ rc=0]
    C -->|Yes| E["Running calendar:" 出力]
    E --> F[calendar -a 実行]
    F --> G{成功?}
    G -->|Yes| H[rc=0]
    G -->|No| I[rc=3]
    D --> J[exit rc]
    H --> J
    I --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=3 | コマンド実行エラー | calendar -aの実行が失敗した場合 | calendarコマンドの存在確認、ユーザホームディレクトリのアクセス権確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

calendar -aの失敗はrc=3として報告される。NFSマウントされたホームディレクトリへのアクセス問題が考えられるため、ネットワーク接続とNFSマウント状態を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル更新なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | システム上のユーザ数に依存 |
| 目標処理時間 | ユーザ数に依存（通常数秒以内） |
| メモリ使用量上限 | calendarコマンドに依存 |

## 排他制御

特別な排他制御は実装されていない。periodicフレームワークにより日次で1回のみ実行されることが想定されている。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Running calendar:" |
| 終了ログ | バッチ終了時 | 終了コードのみ（periodicフレームワーク） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc!=0 | periodicフレームワーク経由のメール通知 |

## 備考

- ソースコードのコメントに「`calendar -a` needs to die」と記載されており、ネットワークホームディレクトリ環境での問題が指摘されている
- 代替として、cronジョブや~/.profile、~/.loginからのcalendar実行が推奨されている
- デフォルト無効であり、管理者が明示的にperiodic.confで有効化する必要がある
- ソースファイル: `usr.sbin/periodic/etc/daily/300.calendar`
