# バッチ設計書 14-400.status-disks

## 概要

本ドキュメントは、FreeBSDのperiodicフレームワークにおけるdailyバッチ `400.status-disks` の設計仕様を記述する。本バッチはディスク使用状況を `df(1)` コマンドで確認し、バックアップが必要なファイルシステムの情報を合わせて報告する。

### 本バッチの処理概要

本バッチは、システムのディスク使用状況を日次で確認・報告するステータス確認バッチである。`df(1)` コマンドによるディスク容量情報の取得と、`dump W` コマンドによるバックアップ対象ファイルシステムの確認を行う。

**業務上の目的・背景**：ディスク容量の枯渇はシステム障害の主要原因の一つであり、日次での容量監視により容量不足を早期に検知し、事前対策（不要ファイル削除やディスク増設計画）を講じることができる。本バッチはデフォルトで有効であり、FreeBSDの標準的な日次運用監視の一部として機能する。

**バッチの実行タイミング**：日次（daily periodic）で実行される。デフォルトで有効（daily_status_disks_enable=YES）。

**主要な処理内容**：
1. `df` コマンドを指定フラグ付きで実行し、ディスク使用状況を取得
2. 除外パターン（`daily_status_disks_ignore`）が設定されている場合、該当行をフィルタリング
3. `/etc/dumpdates` が存在する場合、`dump W` でバックアップが必要なファイルシステムを表示

**前後の処理との関連**：dailyカテゴリのステータス確認系バッチ群（400番台）の先頭に位置する。後続にgraid、ZFS、gmirror等のストレージステータス確認バッチが続く。

**影響範囲**：読み取り専用の処理であり、システムに変更を加えない。periodicフレームワーク経由でメール通知される。

## バッチ種別

レポート生成 / ステータス確認

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodicフレームワークの日次実行時刻（デフォルト: 3:01） |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron経由のperiodicフレームワーク |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| daily_status_disks_enable | "YES"に設定されていること（デフォルト: YES） |

### 実行可否判定

`daily_status_disks_enable` が "YES" でない場合、rc=0でスキップする。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_status_disks_enable | 文字列 | Yes | YES | バッチの有効/無効フラグ |
| daily_status_disks_df_flags | 文字列 | No | -l -h | df(1)コマンドへのフラグ（-l:ローカルのみ, -h:人間可読形式） |
| daily_status_disks_ignore | 文字列 | No | （なし） | df出力から除外するegrepパターン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| df(1)出力 | テキスト | ディスク使用状況 |
| /etc/dumpdates | テキストファイル | dumpバックアップ日時記録 |
| /etc/fstab | テキストファイル | ファイルシステムテーブル（存在しない場合は/dev/nullで代替） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | "Disk status:" ヘッダ、df出力、dump W出力 |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | 標準出力のみ |
| 文字コード | N/A |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. periodic.confの読み込み
   └─ /etc/defaults/periodic.confとローカル設定を読み込む
2. daily_status_disks_enable判定
   └─ YESでない場合、rc=0で終了
3. "Disk status:" ヘッダ出力
4. 除外パターン処理の設定
   └─ daily_status_disks_ignoreが設定されていればegrep -vでフィルタ、未設定ならcat
5. df実行（daily_status_disks_df_flagsフラグ付き）
   └─ 除外パターンフィルタを通して出力。成功時rc=1、失敗時rc=3
6. /etc/dumpdatesの確認
   └─ ファイルが存在しサイズがある場合のみ以下を実行
7. /etc/fstab存在確認
   └─ 存在しない場合、PATH_FSTAB=/dev/nullを設定
8. dump W実行
   └─ バックアップが必要なファイルシステムを表示
9. 終了コード(rc)を返却して終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_status_disks_enable=YES?}
    C -->|No| D[スキップ rc=0]
    C -->|Yes| E["Disk status:" 出力]
    E --> F{daily_status_disks_ignore設定あり?}
    F -->|Yes| G[egrep -vフィルタ設定]
    F -->|No| H[catフィルタ設定]
    G --> I[df実行・フィルタ適用]
    H --> I
    I --> J{/etc/dumpdates存在?}
    J -->|Yes| K{/etc/fstab存在?}
    J -->|No| L[終了]
    K -->|No| M[PATH_FSTAB=/dev/null設定]
    K -->|Yes| N[dump W実行]
    M --> N
    N --> L
    D --> O[exit rc]
    L --> O
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=1 | 正常（情報あり） | dfが正常に実行され情報を出力した場合 | 対処不要（正常な情報出力） |
| rc=3 | コマンド実行エラー | dfまたはdump Wの実行が失敗した場合 | コマンドの存在確認、マウント状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

dfコマンドの失敗はマウントポイントの問題や不正なフラグが原因の可能性がある。daily_status_disks_df_flagsの設定を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | マウント済みファイルシステム数に依存 |
| 目標処理時間 | 通常数秒以内 |
| メモリ使用量上限 | シェルスクリプトのため最小限 |

## 排他制御

特別な排他制御は実装されていない。読み取り専用の処理であるため、同時実行による問題はない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Disk status:" |
| データログ | df実行後 | ディスク使用状況の一覧 |
| バックアップ情報 | dump W実行後 | バックアップが必要なファイルシステムの一覧 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc=3 | periodicフレームワーク経由のメール通知 |
| ディスク使用率 | df出力内の値（管理者判断） | periodicフレームワーク経由のメール通知 |

## 備考

- デフォルトで有効（daily_status_disks_enable=YES）であり、標準的なFreeBSD環境では自動的に動作する
- df成功時のrcは1（periodicフレームワークでは情報出力ありを意味する）
- /etc/fstabが存在しない場合のPATH_FSTAB=/dev/null設定は、dump Wがfstabを必要とするための回避策
- daily_status_disks_df_flagsのデフォルト "-l -h" は、ローカルファイルシステムのみを人間可読形式で表示する
- ソースファイル: `usr.sbin/periodic/etc/daily/400.status-disks`
