# バッチ設計書 16-404.status-zfs

## 概要

本ドキュメントは、FreeBSDのperiodicフレームワークにおけるdailyバッチ `404.status-zfs` の設計仕様を記述する。本バッチはZFSプールの健全性を確認し、異常がある場合に報告する。

### 本バッチの処理概要

本バッチは、ZFS（Zettabyte File System）プールの状態を日次で確認し、健全性に問題がある場合にアラートを発生させる。`zpool status -x` の出力を解析し、プール状態が正常かどうかを判定する。

**業務上の目的・背景**：ZFSはFreeBSDの主要ストレージシステムであり、プールの健全性はデータ保護の基盤である。ディスク障害、チェックサムエラー、デグレード状態の早期検知が重要であり、本バッチにより管理者は日次でZFSプール状態を自動監視できる。

**バッチの実行タイミング**：日次（daily periodic）で実行される。デフォルトでは無効（daily_status_zfs_enable=NO）。

**主要な処理内容**：
1. オプションで `zpool list` によるプール一覧表示
2. `zpool status -x` でプール状態を確認
3. 出力が "all pools are healthy" または "no pools available" であれば正常、それ以外は異常と判定

**前後の処理との関連**：dailyカテゴリのステータス確認系バッチ群（400番台）に属する。No.14（400.status-disks）、No.15（401.status-graid）と同様のストレージ監視目的を持つ。

**影響範囲**：読み取り専用の処理であり、システムに変更を加えない。

## バッチ種別

レポート生成 / ステータス確認

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodicフレームワークの日次実行時刻（デフォルト: 3:01） |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron経由のperiodicフレームワーク |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| daily_status_zfs_enable | "YES"に設定されていること（デフォルト: NO） |
| zpoolコマンド | システムにzpoolコマンドが利用可能であること |

### 実行可否判定

`daily_status_zfs_enable` が "YES" でない場合、rc=0でスキップする。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_status_zfs_enable | 文字列 | Yes | NO | バッチの有効/無効フラグ |
| daily_status_zfs_zpool_list_enable | 文字列 | No | YES | zpool list出力の表示有無 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| zpool list出力 | テキスト | ZFSプール一覧情報 |
| zpool status -x出力 | テキスト | ZFSプール異常状態情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | "Checking status of zfs pools:" ヘッダ、zpool list出力（オプション）、zpool status -x出力 |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | 標準出力のみ |
| 文字コード | N/A |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. periodic.confの読み込み
   └─ /etc/defaults/periodic.confとローカル設定を読み込む
2. daily_status_zfs_enable判定
   └─ YESでない場合、rc=0で終了
3. "Checking status of zfs pools:" ヘッダ出力
4. daily_status_zfs_zpool_list_enable判定
   └─ YESの場合、zpool listを実行して出力
5. zpool status -x 実行
   └─ 出力をsout変数に保存
6. sout出力を標準出力に表示
7. sout内容の判定
   └─ "all pools are healthy" または "no pools available": rc=0
   └─ それ以外: rc=1（異常報告）
8. 終了コード(rc)を返却して終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_status_zfs_enable=YES?}
    C -->|No| D[スキップ rc=0]
    C -->|Yes| E["Checking status of zfs pools:" 出力]
    E --> F{daily_status_zfs_zpool_list_enable=YES?}
    F -->|Yes| G[zpool list実行・出力]
    F -->|No| H[スキップ]
    G --> I[zpool status -x 実行]
    H --> I
    I --> J[sout出力を表示]
    J --> K{soutが正常メッセージ?}
    K -->|Yes| L[rc=0]
    K -->|No| M[rc=1]
    D --> N[exit rc]
    L --> N
    M --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=1 | プール異常検出 | zpool status -xの出力が正常メッセージ以外 | ZFSプールの状態を確認し、障害ディスクの交換やscrubを実施 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

rc=1の場合、ZFSプールに問題が発生している。`zpool status` で詳細を確認し、DEGRADED/FAULTED/UNAVAIL等のディスクに対して交換・リシルバを実施する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ZFSプール数に依存 |
| 目標処理時間 | 通常数秒以内 |
| メモリ使用量上限 | シェルスクリプトのため最小限 |

## 排他制御

特別な排他制御は実装されていない。読み取り専用の処理であるため、同時実行による問題はない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Checking status of zfs pools:" |
| プール一覧 | zpool list実行後（有効時） | ZFSプール一覧 |
| ステータスログ | zpool status -x実行後 | プール状態情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc=1（プール異常） | periodicフレームワーク経由のメール通知 |

## 備考

- デフォルト無効（daily_status_zfs_enable=NO）であり、ZFS使用環境でのみ有効化する
- `zpool status -x` は常にexit code 0を返すため、出力文字列の内容で正常/異常を判定している
- "all pools are healthy" と "no pools available" の2つの文字列を正常メッセージとして扱う
- daily_status_zfs_zpool_list_enableはデフォルトYESであり、zpool listの出力も表示される
- ソースファイル: `usr.sbin/periodic/etc/daily/404.status-zfs`
