# バッチ設計書 18-407.status-graid3

## 概要

本ドキュメントは、FreeBSDのperiodicフレームワークにおけるdailyバッチ `407.status-graid3` の設計仕様を記述する。本バッチは `graid3(8)` デバイスの状態を確認し、異常があれば報告する。

### 本バッチの処理概要

本バッチは、FreeBSDのGEOMベースRAID3フレームワークである `graid3(8)` のデバイス状態を日次で確認し、COMPLETEでないコンポーネントが存在する場合にアラートを発生させる。

**業務上の目的・背景**：graid3(8)はFreeBSDのソフトウェアRAID3実装であり、パリティディスクを用いたデータ保護を提供する。RAID3はストライピング＋パリティによりディスク障害からの復旧が可能だが、デグレード状態の早期検知が重要である。本バッチにより管理者は日次でRAID3デバイスの状態を自動監視できる。

**バッチの実行タイミング**：日次（daily periodic）で実行される。デフォルトでは無効（daily_status_graid3_enable=NO）。

**主要な処理内容**：
1. `graid3 status` コマンドを実行してデバイス状態を表示
2. `graid3 status -s` の出力からCOMPLETE以外のコンポーネントをフィルタリング
3. 非COMPLETEコンポーネントが存在する場合にrc=3（エラー）を返す

**前後の処理との関連**：dailyカテゴリのステータス確認系バッチ群（400番台）に属する。No.17（406.status-gmirror）の後続に位置し、同様のGEOMステータス確認パターンを踏襲する。

**影響範囲**：読み取り専用の処理であり、システムに変更を加えない。

## バッチ種別

レポート生成 / ステータス確認

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodicフレームワークの日次実行時刻（デフォルト: 3:01） |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron経由のperiodicフレームワーク |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| daily_status_graid3_enable | "YES"に設定されていること（デフォルト: NO） |
| graid3(8)コマンド | システムにgraid3コマンドが利用可能であること |

### 実行可否判定

`daily_status_graid3_enable` が "YES" でない場合、rc=0でスキップする。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_status_graid3_enable | 文字列 | Yes | NO | バッチの有効/無効フラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| graid3 status出力 | テキスト | graid3デバイスの状態情報 |
| graid3 status -s出力 | テキスト | graid3デバイスのステータス簡易表示 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | "Checking status of graid3(8) devices:" ヘッダ、graid3 status出力 |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | 標準出力のみ |
| 文字コード | N/A |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. periodic.confの読み込み
   └─ /etc/defaults/periodic.confとローカル設定を読み込む
2. daily_status_graid3_enable判定
   └─ YESでない場合、rc=0で終了
3. "Checking status of graid3(8) devices:" ヘッダ出力
4. graid3 status実行
   └─ 失敗時: rc=2
5. graid3 status -s実行・COMPLETE以外のフィルタリング
   └─ 非COMPLETEコンポーネントが存在: rc=3
   └─ 全てCOMPLETE: rc=0
6. 終了コード(rc)を返却して終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_status_graid3_enable=YES?}
    C -->|No| D[スキップ rc=0]
    C -->|Yes| E["Checking status of graid3(8) devices:" 出力]
    E --> F[graid3 status実行]
    F --> G{graid3 status成功?}
    G -->|No| H[rc=2]
    G -->|Yes| I[graid3 status -s実行・COMPLETE以外フィルタ]
    I --> J{非COMPLETEコンポーネントあり?}
    J -->|Yes| K[rc=3]
    J -->|No| L[rc=0]
    D --> M[exit rc]
    H --> M
    K --> M
    L --> M
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=2 | コマンド実行エラー | graid3 statusの実行が失敗 | graid3コマンドの存在確認、GEOMモジュールの読み込み確認 |
| rc=3 | RAID3異常検出 | COMPLETEでないコンポーネントが存在 | RAID3アレイの状態を確認し、障害ディスクの交換・リビルドを実施 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

rc=3の場合、graid3デバイスにデグレードまたは障害が発生している。`graid3 status` の出力を確認し、障害コンポーネントの特定と交換・リビルドを行う。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | graid3デバイス数に依存 |
| 目標処理時間 | 通常数秒以内 |
| メモリ使用量上限 | シェルスクリプトのため最小限 |

## 排他制御

特別な排他制御は実装されていない。読み取り専用の処理であるため、同時実行による問題はない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Checking status of graid3(8) devices:" |
| ステータスログ | graid3 status実行後 | graid3デバイスの状態一覧 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc=3（RAID3異常） | periodicフレームワーク経由のメール通知 |
| 終了コード | rc=2（コマンドエラー） | periodicフレームワーク経由のメール通知 |

## 備考

- デフォルト無効（daily_status_graid3_enable=NO）であり、graid3使用環境でのみ有効化する
- COMPLETEステータスは全コンポーネントが正常に同期されていることを示す
- fgrep -v COMPLETEにより、COMPLETE以外の行（DEGRADED等）を検出する
- 構造はNo.17（406.status-gmirror）と同一パターンであり、正常状態判定文字列もCOMPLETEで同じ
- ソースファイル: `usr.sbin/periodic/etc/daily/407.status-graid3`
