# バッチ設計書 2-110.clean-tmps

## 概要

本ドキュメントは、FreeBSD periodicフレームワークにおける日次一時ファイルクリーンアップバッチ `110.clean-tmps` の設計を記述する。本バッチは一時ディレクトリ（/tmp等）内の古いファイルおよび空ディレクトリを定期的に削除し、一時領域の肥大化を防止する。

### 本バッチの処理概要

本バッチは、指定された一時ディレクトリ内を走査し、一定日数以上アクセス・更新・変更されていないファイルおよび空ディレクトリを自動的に削除する。

**業務上の目的・背景**：長期稼働するFreeBSDシステムにおいて、/tmp等の一時ディレクトリには各種プログラムが生成する一時ファイルが蓄積される。これらのファイルは本来短期的な利用を想定しているが、プログラムの異常終了やクリーンアップ漏れにより残存し続けることがある。本バッチは、これらの残存ファイルを定期的に削除することで、一時領域のディスク使用量を適切に管理する。

**バッチの実行タイミング**：日次（daily）。FreeBSD periodicフレームワークにより、通常は毎日深夜帯にcronから実行される。

**主要な処理内容**：
1. `/etc/defaults/periodic.conf` および上書き設定ファイルの読み込み
2. `daily_clean_tmps_enable` 変数による有効/無効判定
3. `daily_clean_tmps_days` パラメータの検証
4. 指定された各一時ディレクトリ（daily_clean_tmps_dirs）に対して順次処理
5. atime/mtime/ctimeすべてが指定日数を超過したファイルを削除
6. 空ディレクトリ（mtimeが指定日数を超過）の削除
7. 特定のファイル・ディレクトリ（daily_clean_tmps_ignore）の除外

**前後の処理との関連**：`100.clean-disks` に続くクリーンアップ処理の一つ。`100.clean-disks` がファイルシステム全体の不要ファイルを対象とするのに対し、本バッチは一時ディレクトリに限定した処理を行う。

**影響範囲**：`daily_clean_tmps_dirs` で指定されたディレクトリ内のファイルおよびディレクトリ。デフォルトは `/tmp` のみ。X11関連ソケットやquotaファイルなどの重要ファイルは除外される。

## バッチ種別

データクレンジング（一時ファイル削除）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodic(8)のcron設定に依存（デフォルト: 毎日深夜） |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron経由でperiodic(8)から起動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| periodic.confの存在 | `/etc/defaults/periodic.conf` が読み取り可能であること |
| daily_clean_tmps_enable=YES | 明示的に有効化されていること（デフォルトはNO） |
| daily_clean_tmps_days設定済 | 削除対象の経過日数が指定されていること |
| 対象ディレクトリの存在 | daily_clean_tmps_dirs で指定されたディレクトリが存在すること |

### 実行可否判定

`daily_clean_tmps_enable` が `YES`（大文字小文字不問）の場合のみ実行する。デフォルトは `NO`。`daily_clean_tmps_days` が未設定の場合はエラー（rc=2）で終了する。対象ディレクトリが絶対パスでない場合や存在しない場合はスキップされる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_clean_tmps_enable | 文字列 | Yes | NO | バッチの有効/無効フラグ |
| daily_clean_tmps_dirs | 文字列 | No | /tmp | 対象ディレクトリ（スペース区切り） |
| daily_clean_tmps_days | 数値 | Yes | 3 | 削除対象とする経過日数 |
| daily_clean_tmps_ignore | 文字列 | No | .X*-lock .X11-unix .ICE-unix .font-unix .XIM-unix quota.user quota.group .snap .sujournal | 除外するファイルパターン |
| daily_clean_tmps_verbose | 文字列 | No | YES | 削除ファイルの詳細出力 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | デフォルト設定値 |
| /etc/periodic.conf | シェル変数定義 | ユーザ上書き設定 |
| 指定一時ディレクトリ | ファイルシステム | 削除対象ファイルの検索元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 削除されたファイル一覧（verbose時）および処理メッセージ |
| 終了コード | 数値 | 0:成功/変更なし、1:情報あり、2:設定不備 |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | 標準出力（periodic(8)が制御） |
| 文字コード | システムロケール依存 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.conf を source し、上書き設定を適用
2. 有効/無効判定
   └─ daily_clean_tmps_enable が YES かどうか判定
3. パラメータ検証
   └─ daily_clean_tmps_days が空なら rc=2 でエラー
4. find引数構築
   └─ atime/mtime/ctime の条件を構築
   └─ daily_clean_tmps_ignore のパターンを ! -name 引数に変換
5. 各ディレクトリに対して処理実行
   └─ ディレクトリが絶対パスかつ存在する場合のみ処理
   └─ find -x -d で通常ファイルの削除
   └─ find -x -d で空ディレクトリの削除
6. 出力のパス変換
   └─ 相対パス（./）をディレクトリの絶対パスに変換して出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_clean_tmps_enable=YES?}
    C -->|No| Z[rc=0で終了]
    C -->|Yes| D{daily_clean_tmps_days設定済?}
    D -->|No| E[エラーメッセージ出力, rc=2]
    D -->|Yes| F[find引数構築]
    F --> G[各ディレクトリをループ]
    G --> H{絶対パスかつ存在?}
    H -->|No| G
    H -->|Yes| I[古いファイルを削除]
    I --> J[空ディレクトリを削除]
    J --> G
    G --> K[終了コード設定]
    K --> Z2[終了]
    E --> Z2
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=2 | 設定不備 | daily_clean_tmps_days が未設定 | periodic.conf で値を設定する |
| rc=1 | 情報通知 | ファイルが削除された（verbose時） | 正常動作。削除内容を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

リトライ機構はない。失敗時は次回のdaily実行時に再度実行される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作） |
| コミットタイミング | 各ファイルの削除は即時実行 |
| ロールバック条件 | ロールバック不可（削除は不可逆） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 対象ディレクトリ内のファイル数に依存 |
| 目標処理時間 | ディレクトリ内のファイル数に依存（通常は数秒〜数分） |
| メモリ使用量上限 | findコマンドの使用量に依存（通常低い） |

## 排他制御

排他制御の仕組みは実装されていない。`find -x` により対象ディレクトリのファイルシステムに限定される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | "Removing old temporary files:" メッセージ |
| 進捗ログ | verbose有効時 | 削除されたファイルのパス一覧（ディレクトリプレフィックス付き） |
| 終了ログ | N/A | 明示的な終了ログなし |
| エラーログ | 設定不備時 | 未設定パラメータに関するエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc >= 2 | periodic(8)の出力先（daily_output設定、デフォルト: root宛メール） |

## 備考

- デフォルトでは無効（daily_clean_tmps_enable=NO）
- ファイル削除の判定にはatime、mtime、ctimeの3つすべてが指定日数を超過している必要がある
- 空ディレクトリの削除はmtimeのみで判定される
- `find -x` オプションにより、マウントポイントを超えたファイルシステムの走査は行われない
- `find -d` オプションにより、深さ優先で処理されるため、ディレクトリは中身が先に削除されてから削除される
- X11ソケットファイル、quotaファイル、UFS snapshot、SUJジャーナルは除外される
