# バッチ設計書 21-410.status-mfi

## 概要

本ドキュメントは、FreeBSDのperiodicフレームワークにおける日次バッチ `410.status-mfi` の設計仕様を定義する。本バッチはmfi(4) RAIDコントローラの状態を確認し、劣化(DEGRADED)状態を検出・報告する。

### 本バッチの処理概要

本バッチは、LSI MegaRAID SASコントローラ（mfi(4)ドライバ対応）のボリューム状態を日次で確認し、異常を早期発見するためのステータス監視スクリプトである。

**業務上の目的・背景**：ハードウェアRAIDコントローラは物理ディスクの障害によりボリュームがDEGRADED状態に陥る場合がある。この状態を放置するとデータ損失リスクが高まるため、日次で自動的にRAIDボリュームの健全性を確認し、管理者へ通知する必要がある。

**バッチの実行タイミング**：日次（dailyのperiodicフレームワークにより実行）。デフォルトでは無効（daily_status_mfi_enable=NO）であり、mfi(4)デバイスを持つシステムで明示的に有効化する必要がある。

**主要な処理内容**：
1. periodic.confからグローバル設定を読み込む
2. `daily_status_mfi_enable` 変数を評価し、有効時のみ処理を実行
3. `mfiutil show volumes` コマンドでRAIDボリューム一覧を取得・表示
4. 出力中に "DEGRADED" 文字列が含まれるかをgrepで判定
5. 判定結果に応じてリターンコードを設定する

**前後の処理との関連**：dailyステータス確認シリーズ（400番台）の一部であり、409.status-gconcatの後、420.status-networkの前に実行される。他のバッチとの直接的なデータ依存はない。

**影響範囲**：mfi(4)ドライバ対応のRAIDコントローラを搭載するシステム。読み取り専用の確認処理であり、システムデータへの変更は行わない。出力はperiodicフレームワークにより管理者へメール送信またはログファイルへ記録される。

## バッチ種別

レポート生成（ステータス監視）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodicフレームワークのdaily実行時刻（デフォルト: 3:01） |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron（periodicフレームワーク経由） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| mfi(4)デバイスの存在 | mfiutil(8)が正常動作するRAIDコントローラが搭載されていること |
| mfiutil(8)の利用可能性 | mfiutilコマンドが実行可能であること |
| periodic.confの存在 | /etc/defaults/periodic.confが読み取り可能であること |

### 実行可否判定

`daily_status_mfi_enable` 変数がYES（大文字小文字不問）の場合のみ処理を実行する。デフォルトはNOであり、管理者が明示的に有効化する必要がある。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_status_mfi_enable | 文字列 | No | NO | バッチの有効/無効切り替え |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数定義 | ローカルオーバーライド設定 |
| mfiutil show volumes | コマンド出力 | RAIDボリューム状態 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | ボリューム状態情報（periodicフレームワークが収集） |

### 出力ファイル仕様

本バッチは直接ファイル出力を行わない。標準出力への結果はperiodicフレームワークにより、daily_outputの設定に従ってメール送信またはファイルへ記録される。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（標準出力経由） |
| 出力先 | daily_output設定に依存（デフォルト: root宛メール） |
| 文字コード | システムロケール依存 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.confを読み込み、source_periodic_confsでオーバーライド適用
2. 有効/無効判定
   └─ daily_status_mfi_enableの値をcase文で判定
3. ボリューム状態表示
   └─ mfiutil show volumesを実行し、結果を標準出力へ表示
4. DEGRADED判定
   └─ mfiutil show volumesの出力をgrep -qでDEGRADED文字列を検索
5. リターンコード設定
   └─ 正常: rc=0、DEGRADED検出: rc=3、コマンド失敗: rc=2
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_status_mfi_enable = YES?}
    C -->|No| D[rc=0で終了]
    C -->|Yes| E["mfiutil show volumes 実行"]
    E --> F{コマンド成功?}
    F -->|No| G[rc=2で終了]
    F -->|Yes| H{DEGRADED検出?}
    H -->|Yes| I[rc=3で終了]
    H -->|No| J[rc=0で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=2 | コマンド実行エラー | mfiutil show volumesの実行に失敗 | mfiドライバの状態確認、mfiutilコマンドの存在確認 |
| rc=3 | DEGRADED検出 | RAIDボリュームがDEGRADED状態 | 物理ディスクの交換・RAID再構築を実施 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

mfiutilコマンドの実行失敗時（rc=2）は、mfi(4)ドライバの状態およびハードウェアの接続状態を確認する。DEGRADED検出時（rc=3）は、速やかに故障ディスクを特定し交換・リビルドを行う。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用処理） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回（単一システムのRAIDボリューム確認） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小（シェルスクリプト実行のみ） |

## 排他制御

同時実行に関する排他制御は行わない。読み取り専用の確認処理のため、並列実行しても問題はない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ヘッダ出力 | 処理開始時 | "Checking status of mfi(4) devices:" |
| ボリューム情報 | mfiutil実行後 | mfiutil show volumesの出力結果 |
| 異常通知 | periodicフレームワーク | rc=3の場合、daily出力にDEGRADED情報が含まれる |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| リターンコード | rc=3（DEGRADED） | daily_output設定先（デフォルト: root） |
| リターンコード | rc=2（コマンドエラー） | daily_output設定先（badconfig扱い） |

## 備考

- 本バッチはデフォルトで無効化されている。mfi(4)対応のRAIDコントローラを使用するシステムでのみ有効化すること。
- mfiutil(8)はLSI MegaRAID SASファミリのコントローラに対応している。
- ソースファイル: `usr.sbin/periodic/etc/daily/410.status-mfi`
