# バッチ設計書 22-420.status-network

## 概要

本ドキュメントは、FreeBSDのperiodicフレームワークにおける日次バッチ `420.status-network` の設計仕様を定義する。本バッチはnetstat(1)を使用してネットワークインターフェースの状態を確認・報告する。

### 本バッチの処理概要

本バッチは、システムのネットワークインターフェース状態を日次で確認し、管理者に報告するためのステータス監視スクリプトである。

**業務上の目的・背景**：サーバシステムのネットワークインターフェースの状態を定期的に確認することで、エラーカウンタの増加やインターフェースの異常を早期に検出する。ネットワーク障害の予兆把握と運用監視の自動化を目的とする。

**バッチの実行タイミング**：日次（dailyのperiodicフレームワークにより実行）。デフォルトで有効（daily_status_network_enable=YES）。

**主要な処理内容**：
1. periodic.confからグローバル設定を読み込む
2. `daily_status_network_enable` 変数を評価し、有効時のみ処理を実行
3. DNS逆引き使用の可否を `daily_status_network_usedns` で判定し、無効時は `-n` フラグを追加
4. `netstat -i` コマンドをカスタマイズされたフラグ付きで実行
5. 実行結果を標準出力へ表示する

**前後の処理との関連**：dailyステータス確認シリーズ（400番台）の一部であり、410.status-mfiの後、430.status-uptimeの前に実行される。他のバッチとの直接的なデータ依存はない。

**影響範囲**：システム全体のネットワークインターフェース情報を読み取る。読み取り専用の確認処理であり、ネットワーク設定への変更は行わない。出力はperiodicフレームワークにより管理者へ通知される。

## バッチ種別

レポート生成（ステータス監視）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodicフレームワークのdaily実行時刻 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron（periodicフレームワーク経由） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| netstat(1)の利用可能性 | netstatコマンドが実行可能であること |
| periodic.confの存在 | /etc/defaults/periodic.confが読み取り可能であること |

### 実行可否判定

`daily_status_network_enable` 変数がYES（大文字小文字不問）の場合に処理を実行する。デフォルトはYES。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_status_network_enable | 文字列 | No | YES | バッチの有効/無効切り替え |
| daily_status_network_usedns | 文字列 | No | YES | DNS逆引きの使用可否 |
| daily_status_network_netstat_flags | 文字列 | No | -d -W | netstat(1)に渡す追加フラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数定義 | ローカルオーバーライド設定 |
| netstat -i | コマンド出力 | ネットワークインターフェース統計情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | ネットワークインターフェース状態（periodicフレームワークが収集） |

### 出力ファイル仕様

本バッチは直接ファイル出力を行わない。標準出力への結果はperiodicフレームワークにより管理者へ通知される。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（標準出力経由） |
| 出力先 | daily_output設定に依存（デフォルト: root宛メール） |
| 文字コード | システムロケール依存 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.confを読み込み、source_periodic_confsでオーバーライド適用
2. 有効/無効判定
   └─ daily_status_network_enableの値をcase文で判定
3. フラグ構築
   └─ daily_status_network_netstat_flagsを基本フラグとして取得
4. DNS逆引き判定
   └─ daily_status_network_usednsがYES以外の場合、-nフラグを追加
5. netstat実行
   └─ netstat -i ${flags} を実行し結果を標準出力へ表示
6. リターンコード設定
   └─ 正常: rc=0、コマンド失敗: rc=3
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_status_network_enable = YES?}
    C -->|No| D[rc=0で終了]
    C -->|Yes| E[netstat_flagsを取得]
    E --> F{daily_status_network_usedns = YES?}
    F -->|Yes| G[フラグそのまま]
    F -->|No| H["-n"フラグを追加]
    G --> I["netstat -i ${flags} 実行"]
    H --> I
    I --> J{コマンド成功?}
    J -->|Yes| K[rc=0で終了]
    J -->|No| L[rc=3で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=3 | コマンド実行エラー | netstat -iの実行に失敗 | ネットワークサブシステムの状態確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

netstatコマンドの実行失敗時（rc=3）は、カーネルのネットワークサブシステムの状態を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用処理） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回（単一システムのインターフェース確認） |
| 目標処理時間 | 数秒以内（DNS逆引き有効時はホスト名解決に時間がかかる場合あり） |
| メモリ使用量上限 | 最小（シェルスクリプト実行のみ） |

## 排他制御

同時実行に関する排他制御は行わない。読み取り専用の確認処理のため、並列実行しても問題はない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ヘッダ出力 | 処理開始時 | "Network interface status:" |
| インターフェース情報 | netstat実行後 | netstat -iの出力結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| リターンコード | rc=3（コマンドエラー） | daily_output設定先（デフォルト: root） |

## 備考

- 本バッチはデフォルトで有効化されている。
- DNS逆引きを無効にすると、IPアドレスがそのまま表示されるが処理が高速化される。
- netstatの `-d` フラグはドロップされたパケット数を表示し、`-W` フラグは長いアドレスの表示を有効にする。
- ソースファイル: `usr.sbin/periodic/etc/daily/420.status-network`
