# バッチ設計書 23-430.status-uptime

## 概要

本ドキュメントは、FreeBSDのperiodicフレームワークにおける日次バッチ `430.status-uptime` の設計仕様を定義する。本バッチはシステムのuptime情報を確認・報告する。ローカルネットワーク上にrwhoデータが存在する場合はruptimeを、それ以外の場合はuptimeコマンドを使用する。

### 本バッチの処理概要

本バッチは、システムの稼働時間（uptime）を日次で確認し、管理者に報告するためのステータス監視スクリプトである。rwhoプロトコルによるネットワーク上の他ホストの情報が利用可能な場合は、ネットワーク全体のステータスを表示する。

**業務上の目的・背景**：サーバの稼働時間を定期的に確認することで、予期しない再起動やシステム障害の発生を検出する。また、負荷平均（load average）の情報を含めることで、システムの健全性を概観できる。

**バッチの実行タイミング**：日次（dailyのperiodicフレームワークにより実行）。デフォルトで有効（daily_status_uptime_enable=YES）。

**主要な処理内容**：
1. periodic.confからグローバル設定を読み込む
2. `daily_status_uptime_enable` 変数を評価し、有効時のみ処理を実行
3. /var/rwho/ ディレクトリ内にファイルが存在するか確認
4. rwhoファイルが存在する場合は `ruptime` コマンドを使用、存在しない場合は `uptime` コマンドを使用
5. 実行結果を標準出力へ表示し、行数をカウントしてリターンコードを判定

**前後の処理との関連**：dailyステータス確認シリーズ（400番台）の一部であり、420.status-networkの後、440.status-mailqの前に実行される。他のバッチとの直接的なデータ依存はない。

**影響範囲**：システムのuptime情報および/var/rwho/ディレクトリの内容を読み取る。読み取り専用の確認処理であり、システムデータへの変更は行わない。

## バッチ種別

レポート生成（ステータス監視）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodicフレームワークのdaily実行時刻 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron（periodicフレームワーク経由） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| uptime(1)の利用可能性 | uptimeコマンドが実行可能であること |
| periodic.confの存在 | /etc/defaults/periodic.confが読み取り可能であること |

### 実行可否判定

`daily_status_uptime_enable` 変数がYES（大文字小文字不問）の場合に処理を実行する。デフォルトはYES。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_status_uptime_enable | 文字列 | No | YES | バッチの有効/無効切り替え |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数定義 | ローカルオーバーライド設定 |
| /var/rwho/* | rwhoデータファイル | ネットワーク上のホスト情報（存在する場合） |
| uptime / ruptime | コマンド出力 | システム稼働時間情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | uptime/ruptime情報（periodicフレームワークが収集） |

### 出力ファイル仕様

本バッチは直接ファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（標準出力経由） |
| 出力先 | daily_output設定に依存（デフォルト: root宛メール） |
| 文字コード | システムロケール依存 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.confを読み込み、source_periodic_confsでオーバーライド適用
2. 有効/無効判定
   └─ daily_status_uptime_enableの値をcase文で判定
3. rwhoデータ存在判定
   └─ /var/rwho/*をグロブ展開し、最初のファイルが存在するか-fで判定
4. コマンド選択
   └─ rwhoファイルあり: ruptime / なし: uptime
5. コマンド実行と行数カウント
   └─ 選択コマンドをtee /dev/stderrで標準出力へ表示しつつwc -lで行数取得
6. リターンコード設定
   └─ コマンド成功かつ2行以上: rc=1、1行: rc=0（uptimeの場合の正常）、失敗: rc=3
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_status_uptime_enable = YES?}
    C -->|No| D[rc=0で終了]
    C -->|Yes| E{/var/rwho/*にファイル存在?}
    E -->|Yes| F["ruptime実行 + ヘッダ: Local network system status:"]
    E -->|No| G["uptime実行 + ヘッダ: Local system status:"]
    F --> H[tee /dev/stderr | wc -l]
    G --> H
    H --> I{コマンド成功?}
    I -->|No| J[rc=3で終了]
    I -->|Yes| K{出力行数 > 1?}
    K -->|Yes| L[rc=1で終了]
    K -->|No| M[rc=0 or 1で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=3 | コマンド実行エラー | uptime/ruptimeの実行に失敗 | システムの状態確認 |
| rc=1 | 情報通知 | 複数ホストの情報表示（ruptime使用時） | 正常動作（情報表示） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

uptimeコマンドの実行失敗時（rc=3）は、システムの基本動作に問題がないか確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用処理） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回（単一/複数ホストの稼働時間確認） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小（シェルスクリプト実行のみ） |

## 排他制御

同時実行に関する排他制御は行わない。読み取り専用の確認処理のため、並列実行しても問題はない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ヘッダ出力 | 処理開始時 | "Local system status:" または "Local network system status:" |
| 稼働時間情報 | コマンド実行後 | uptime/ruptimeの出力結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| リターンコード | rc=3（コマンドエラー） | daily_output設定先（デフォルト: root） |

## 備考

- 本バッチはデフォルトで有効化されている。
- rwhoデータが /var/rwho/ に存在する場合はruptimeコマンドが使用され、ネットワーク上の全ホストの稼働時間が表示される。rwhoデーモン（rwhod(8)）が動作している環境でのみruptimeが有効に機能する。
- tee /dev/stderrを使用してコマンド出力を標準出力（periodicフレームワーク向け）と標準エラー出力（行数カウント用）の両方へ送出している。
- ソースファイル: `usr.sbin/periodic/etc/daily/430.status-uptime`
