# バッチ設計書 24-440.status-mailq

## 概要

本ドキュメントは、FreeBSDのperiodicフレームワークにおける日次バッチ `440.status-mailq` の設計仕様を定義する。本バッチはメールキューの状態を確認し、滞留メールの有無を報告する。

### 本バッチの処理概要

本バッチは、sendmailのメールキュー（ローカルキューおよびサブミットキュー）の状態を日次で確認し、滞留メールの存在を管理者に報告するためのステータス監視スクリプトである。

**業務上の目的・背景**：メールサーバ運用において、メールキューの滞留はメール配送障害の兆候である。キュー内のメール数と宛先を定期的に確認することで、配送障害やスパム送信の早期発見を可能にする。

**バッチの実行タイミング**：日次（dailyのperiodicフレームワークにより実行）。デフォルトで有効（daily_status_mailq_enable=YES）。

**主要な処理内容**：
1. periodic.confからグローバル設定を読み込む
2. /usr/bin/mailqの実行可能性を確認
3. メインキューのメール状態を `mailq` コマンドで取得
4. 短縮モード有効時は、宛先アドレスごとに集計して表示
5. サブミットキュー確認が有効な場合、`mailq -Ac` でサブミットキューも確認
6. キューにメールがある場合はrc=1、空の場合はrc=0を返す

**前後の処理との関連**：dailyステータス確認シリーズ（400番台）の一部であり、430.status-uptimeの後、450.status-securityの前に実行される。500.queuerunバッチと関連があり、queuerunがキューの送信処理を行い、本バッチがキューの監視を行う。

**影響範囲**：sendmailのメールキューの状態を読み取る。読み取り専用の確認処理であり、メールキューへの変更は行わない。

## バッチ種別

レポート生成（ステータス監視）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodicフレームワークのdaily実行時刻 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron（periodicフレームワーク経由） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| /usr/bin/mailqの存在 | mailqコマンドが実行可能であること |
| sendmailの動作 | sendmailまたは互換MTAがインストールされていること |
| periodic.confの存在 | /etc/defaults/periodic.confが読み取り可能であること |

### 実行可否判定

`daily_status_mailq_enable` 変数がYES（大文字小文字不問）の場合に処理を実行する。デフォルトはYES。/usr/bin/mailqが実行可能でない場合はrc=2（badconfig）を返す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_status_mailq_enable | 文字列 | No | YES | バッチの有効/無効切り替え |
| daily_status_mailq_shorten | 文字列 | No | NO | 出力を宛先ごとに短縮表示するか |
| daily_status_include_submit_mailq | 文字列 | No | YES | サブミットキューも確認するか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数定義 | ローカルオーバーライド設定 |
| mailq | コマンド出力 | メインメールキューの内容 |
| mailq -Ac | コマンド出力 | サブミットメールキューの内容 |
| /etc/mail/submit.cf | 設定ファイル | サブミットキュー設定（存在確認用） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | メールキュー状態（periodicフレームワークが収集） |

### 出力ファイル仕様

本バッチは直接ファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（標準出力経由） |
| 出力先 | daily_output設定に依存（デフォルト: root宛メール） |
| 文字コード | システムロケール依存 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.confを読み込み、source_periodic_confsでオーバーライド適用
2. 有効/無効判定
   └─ daily_status_mailq_enableの値をcase文で判定
3. mailq実行可能性チェック
   └─ /usr/bin/mailqが実行可能か-xで確認（不可ならrc=2）
4. メインキュー確認
   └─ mailqコマンドを実行しキュー内容を表示
5. 短縮表示処理（オプション）
   └─ daily_status_mailq_shorten=YES時、egrepで宛先抽出→sort→uniq -c→sort -fnrで集計
6. メインキュー判定
   └─ "Mail queue is empty"/"mqueue is empty"/"Total requests"以外の行が存在するか判定
7. サブミットキュー確認（オプション）
   └─ daily_status_include_submit_mailq=YESかつ/etc/mail/submit.cf存在時
8. サブミットキュー処理
   └─ mailq -Acで取得し同様に表示・判定
9. リターンコード設定
   └─ キューにメールあり: rc=1、空: rc=0
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_status_mailq_enable = YES?}
    C -->|No| D[rc=0で終了]
    C -->|Yes| E{/usr/bin/mailq実行可能?}
    E -->|No| F[rc=2で終了]
    E -->|Yes| G["mailqでメインキュー確認"]
    G --> H{shorten=YES?}
    H -->|Yes| I[宛先ごとに集計表示]
    H -->|No| J[そのまま表示]
    I --> K{キューにメールあり?}
    J --> K
    K -->|Yes| L[rc=1]
    K -->|No| M[rc=0]
    L --> N{include_submit_mailq=YES?}
    M --> N
    N -->|Yes| O{/etc/mail/submit.cf存在?}
    N -->|No| P[終了]
    O -->|Yes| Q["mailq -Acでサブミットキュー確認"]
    O -->|No| P
    Q --> R{サブミットキューにメールあり?}
    R -->|Yes| S[rc=1]
    R -->|No| P
    S --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=2 | 設定エラー | /usr/bin/mailqが実行不可 | sendmailまたは互換MTAのインストール確認 |
| rc=1 | 情報通知 | キューにメールが滞留 | メール配送状態の確認、必要に応じて手動キュー処理 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

mailqコマンドが利用不可の場合（rc=2）は、sendmailパッケージの再インストールまたはMTAの設定を確認する。キューにメールが滞留している場合（rc=1）は、配送先サーバの可用性やDNS設定を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用処理） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | メールキュー内のメール数に依存 |
| 目標処理時間 | 数秒〜数十秒（キューサイズに依存） |
| メモリ使用量上限 | 最小（シェルスクリプト実行のみ） |

## 排他制御

同時実行に関する排他制御は行わない。読み取り専用の確認処理のため、並列実行しても問題はない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ヘッダ出力 | メインキュー確認時 | "Mail in local queue:" |
| メインキュー情報 | mailq実行後 | mailqの出力結果（通常または短縮表示） |
| サブミットキューヘッダ | サブミットキュー確認時 | "Mail in submit queue:" |
| サブミットキュー情報 | mailq -Ac実行後 | サブミットキューの出力結果 |
| エラー通知 | mailq不可時 | "$daily_status_mailq_enable is set but /usr/bin/mailq isn't executable" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| リターンコード | rc=1（メール滞留） | daily_output設定先（デフォルト: root） |
| リターンコード | rc=2（設定エラー） | daily_output設定先（badconfig扱い） |

## 備考

- 本バッチはデフォルトで有効化されている。
- 短縮モード（daily_status_mailq_shorten=YES）は、大量のメールがキューにある場合に出力を見やすくするオプション。宛先アドレスごとにメール数を集計して表示する。
- サブミットキューは、sendmailのsubmission用メールキューであり、/etc/mail/submit.cfが存在し、mailq -Acが利用可能な場合にのみ確認される。
- ソースファイル: `usr.sbin/periodic/etc/daily/440.status-mailq`
