# バッチ設計書 25-450.status-security

## 概要

本ドキュメントは、FreeBSDのperiodicフレームワークにおける日次バッチ `450.status-security` の設計仕様を定義する。本バッチはセキュリティチェックスクリプト群を実行し、結果を報告するオーケストレータである。

### 本バッチの処理概要

本バッチは、FreeBSDの日次セキュリティ監査の統括スクリプトであり、`periodic security` を呼び出してセキュリティ関連の全チェックスクリプト（100番台～900番台のsecurityスクリプト）を一括実行する。結果の出力先は設定により、インライン表示・ファイル記録・メール送信のいずれかを選択できる。

**業務上の目的・背景**：システムのセキュリティ状態を日次で自動監査することで、setuidファイルの変更、不正アカウント、ファイアウォールの拒否ログ、ログイン失敗など、セキュリティ上の異常を早期に検出する。FreeBSDの標準セキュリティ運用フレームワークの中核を担う。

**バッチの実行タイミング**：日次（dailyのperiodicフレームワークにより実行）。デフォルトで有効（daily_status_security_enable=YES）。

**主要な処理内容**：
1. periodic.confからグローバル設定を読み込む
2. `daily_status_security_enable` 変数を評価し、有効時のみ処理を実行
3. インラインモード判定（daily_status_security_inline=YES時は出力先を空にする）
4. security_output変数を設定し、`periodic security` コマンドを実行
5. 出力先設定に応じた結果の処理（インライン表示/ファイル記録/メール送信）

**前後の処理との関連**：dailyステータス確認シリーズの一部であり、440.status-mailqの後、460.status-mail-rejectsの前に実行される。`periodic security` を通じてsecurity/ディレクトリ内の全セキュリティチェックスクリプト（100.chksetuid、200.chkmounts、500.ipfwdenied等）を呼び出す。

**影響範囲**：システム全体のセキュリティ状態を監査する。一時ファイルを/tmp（またはTMPDIR）に作成するが、処理完了後に削除する。セキュリティチェック結果はdaily_status_security_outputの設定に従って出力される。

## バッチ種別

レポート生成（セキュリティ監査オーケストレーション）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodicフレームワークのdaily実行時刻 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron（periodicフレームワーク経由） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| periodicコマンドの利用可能性 | periodic(8)コマンドが実行可能であること |
| セキュリティスクリプトの存在 | /etc/periodic/securityディレクトリにスクリプトが存在すること |
| periodic.confの存在 | /etc/defaults/periodic.confが読み取り可能であること |
| 一時ファイル作成権限 | TMPDIR（デフォルト/tmp）への書き込み権限 |

### 実行可否判定

`daily_status_security_enable` 変数がYES（大文字小文字不問）の場合に処理を実行する。デフォルトはYES。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_status_security_enable | 文字列 | No | YES | バッチの有効/無効切り替え |
| daily_status_security_inline | 文字列 | No | NO | セキュリティ出力をdaily出力にインライン表示するか |
| daily_status_security_output | 文字列 | No | root | 出力先（ユーザ名またはファイルパス） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数定義 | ローカルオーバーライド設定 |
| /etc/periodic/security/* | シェルスクリプト | セキュリティチェックスクリプト群 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力（インライン時） | テキスト | セキュリティチェック結果全体 |
| ファイル（パス指定時） | テキスト | security_outputで指定されたファイル |
| メール（ユーザ指定時） | テキスト | security_outputで指定されたユーザ宛メール |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | daily_status_security_outputに依存 |
| 出力先 | 設定に依存（デフォルト: rootユーザ宛メール） |
| 文字コード | システムロケール依存 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.confを読み込み、source_periodic_confsでオーバーライド適用
2. 有効/無効判定
   └─ daily_status_security_enableの値をcase文で判定
3. インラインモード判定
   └─ daily_status_security_inline=YES時、daily_status_security_outputを空文字に設定
4. security_output環境変数のエクスポート
   └─ セキュリティスクリプト群に出力先を伝達
5. 出力先別処理分岐
   a. 空文字（インライン）: 一時ファイルに出力→内容表示→一時ファイル削除
   b. /で始まるパス: "output logged separately"表示→periodic security実行
   c. その他（ユーザ名）: "output mailed separately"表示→periodic security実行
6. リターンコード設定
   └─ periodic security成功かつ出力なし: rc=0、出力あり/失敗: rc=3
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_status_security_enable = YES?}
    C -->|No| D[rc=0で終了]
    C -->|Yes| E{inline = YES?}
    E -->|Yes| F[security_outputを空文字に設定]
    E -->|No| G[security_outputをそのまま使用]
    F --> H[security_outputをエクスポート]
    G --> H
    H --> I{security_outputの値は?}
    I -->|空文字| J[一時ファイル作成]
    J --> K["periodic security > 一時ファイル"]
    K --> L{一時ファイルにデータあり?}
    L -->|Yes| M[内容をcat表示, rc=3]
    L -->|No| N[rc=0]
    M --> O[一時ファイル削除]
    N --> O
    I -->|/で始まるパス| P["ログ別途記録と表示"]
    P --> Q["periodic security実行"]
    I -->|その他| R["メール別途送信と表示"]
    R --> Q
    Q --> S{成功?}
    S -->|Yes| T[rc=0]
    S -->|No| U[rc=3]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=3 | セキュリティ問題検出 | セキュリティチェックで異常を検出 | 検出内容に応じた個別対応 |
| rc=3 | periodic security失敗 | periodic securityコマンドの実行失敗 | セキュリティスクリプトの存在・権限確認 |
| N/A | 一時ファイル作成失敗 | mktemp失敗（ディスクフル等） | TMPDIR領域の空き容量確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

periodic securityの実行失敗時は、/etc/periodic/security/ディレクトリ内のスクリプトの存在と実行権限を確認する。一時ファイル作成失敗時はTMPDIR（デフォルト/tmp）の空き容量を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | セキュリティスクリプト数（デフォルト約15個） |
| 目標処理時間 | 数分（スクリプト数とシステム規模に依存） |
| メモリ使用量上限 | セキュリティスクリプト群の合計使用量に依存 |

## 排他制御

同時実行に関する明示的な排他制御は行わない。ただし、一時ファイル名にランダムサフィックスを使用（mktemp）することで、同時実行時のファイル名衝突を回避している。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ヘッダ出力 | 処理開始時 | "Security check:" |
| 結果通知（インライン） | periodic security完了後 | セキュリティチェック結果全体 |
| 結果通知（ファイル） | periodic security完了後 | "(output logged separately)" |
| 結果通知（メール） | periodic security完了後 | "(output mailed separately)" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| リターンコード | rc=3（セキュリティ問題検出） | daily_output設定先 |
| セキュリティ出力 | 出力あり | daily_status_security_output設定先（デフォルト: root） |

## 備考

- 本バッチはデフォルトで有効化されている。
- セキュリティチェックの詳細は、/etc/periodic/security/ディレクトリ内の各スクリプトが担当する。本バッチはそれらのオーケストレータとして機能する。
- インラインモード（daily_status_security_inline=YES）では、セキュリティチェック結果がdaily出力に直接含まれる。デフォルト（NO）では別途メール送信される。
- 一時ファイル名のパターン: `450.status-security.XXXXXX`（mktempにより生成）
- ソースファイル: `usr.sbin/periodic/etc/daily/450.status-security`
