# バッチ設計書 26-460.status-mail-rejects

## 概要

本ドキュメントは、FreeBSDのperiodicフレームワークにおける日次バッチ `460.status-mail-rejects` の設計仕様を定義する。本バッチはsendmailのメールリジェクトログを解析し、拒否されたメールのホストと理由を集計・報告する。

### 本バッチの処理概要

本バッチは、sendmailのメールログ（/var/log/maillog）を解析し、前日にリジェクト（拒否）されたメールの送信元ホスト・理由を集計して管理者に報告するステータス監視スクリプトである。

**業務上の目的・背景**：メールサーバに対するスパム送信やリレー試行は、リジェクトログに記録される。これを日次で集計・分析することで、不正アクセスの傾向把握、ファイアウォールルールの調整、送信元ブロックの判断材料を管理者に提供する。

**バッチの実行タイミング**：日次（dailyのperiodicフレームワークにより実行）。デフォルトで有効（daily_status_mail_rejects_enable=YES）。

**主要な処理内容**：
1. periodic.confからグローバル設定を読み込む
2. 前提条件チェック（/etc/mailディレクトリ、/var/log/maillogの存在、ログ数設定）
3. 過去のmaillogファイル（ローテーション済み含む）を読み込み
4. 前日のタイムスタンプに一致するログ行を抽出（RFC 3164およびRFC 5424形式対応）
5. sendmailのreject行をsedで解析し、ルールセット・リジェクト理由・ホスト情報を抽出
6. 結果をソート・集計して出力

**前後の処理との関連**：dailyステータス確認シリーズの一部であり、450.status-securityの後、480番台NTP関連の前に実行される。sendmailのログファイルに依存する。

**影響範囲**：/var/log/maillogおよびそのローテーション済みファイル（.gz, .bz2, .xz, .zst形式）を読み取る。読み取り専用の処理であり、ログファイルへの変更は行わない。

## バッチ種別

レポート生成（ログ分析・ステータス監視）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodicフレームワークのdaily実行時刻 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron（periodicフレームワーク経由） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| /etc/mailディレクトリの存在 | sendmailの設定ディレクトリが存在すること |
| /var/log/maillogの存在 | メールログファイルが存在すること |
| daily_status_mail_rejects_logs > 0 | 確認するログファイル数が1以上であること |
| periodic.confの存在 | /etc/defaults/periodic.confが読み取り可能であること |

### 実行可否判定

`daily_status_mail_rejects_enable` 変数がYES（大文字小文字不問）の場合に処理を実行する。デフォルトはYES。さらに、/etc/mail、/var/log/maillog、daily_status_mail_rejects_logsの各前提条件を満たす必要がある。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_status_mail_rejects_enable | 文字列 | No | YES | バッチの有効/無効切り替え |
| daily_status_mail_rejects_logs | 数値 | No | 3 | 確認するログファイル数 |
| daily_status_mail_rejects_shorten | 文字列 | No | NO | 出力を短縮するか（フィールド2,3のみ表示） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数定義 | ローカルオーバーライド設定 |
| /var/log/maillog | テキストログ | 現在のメールログ |
| /var/log/maillog.N | テキストログ | ローテーション済みメールログ（プレーン） |
| /var/log/maillog.N.gz | gzip圧縮 | ローテーション済みメールログ（gzip） |
| /var/log/maillog.N.bz2 | bzip2圧縮 | ローテーション済みメールログ（bzip2） |
| /var/log/maillog.N.xz | xz圧縮 | ローテーション済みメールログ（xz） |
| /var/log/maillog.N.zst | zstd圧縮 | ローテーション済みメールログ（zstd） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | リジェクト集計結果（件数 リジェクト理由 ホスト情報） |

### 出力ファイル仕様

本バッチは直接ファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（標準出力経由） |
| 出力先 | daily_output設定に依存（デフォルト: root宛メール） |
| 文字コード | システムロケール依存 |
| 区切り文字 | スペース区切り |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.confを読み込み、source_periodic_confsでオーバーライド適用
2. 短縮表示判定
   └─ daily_status_mail_rejects_shorten=YES時はcut -d" " -f2,3、それ以外はcat
3. 有効/無効判定
   └─ daily_status_mail_rejects_enableの値をcase文で判定
4. 前提条件チェック
   └─ /etc/mail存在、/var/log/maillog存在、logs > 0の確認
5. タイムスタンプ生成
   └─ RFC 3164形式（date '+%b %e '）とRFC 5424形式（date -I）で当日・前日のパターン生成
6. ログファイル読み込み
   └─ ローテーション済みログ（.N, .N.gz, .N.bz2, .N.xz, .N.zst）と現行ログを連結
7. sed解析
   └─ 前日タイムスタンプの行から当日タイムスタンプまでを対象に、reject行をパース
8. 集計・ソート
   └─ sort -f → uniq -ic → sort -fnr でリジェクト件数順に集計
9. リターンコード設定
   └─ リジェクトあり: rc=1、なし: rc=0
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_status_mail_rejects_enable = YES?}
    C -->|No| D[rc=0で終了]
    C -->|Yes| E{/etc/mail存在?}
    E -->|No| F[rc=2で終了]
    E -->|Yes| G{/var/log/maillog存在?}
    G -->|No| H[rc=2で終了]
    G -->|Yes| I{logs > 0?}
    I -->|No| J[rc=2で終了]
    I -->|Yes| K[タイムスタンプパターン生成]
    K --> L[ローテーション済みログ+現行ログ読み込み]
    L --> M[sedで前日のreject行を解析]
    M --> N[sort/uniq -ic/sort -fnrで集計]
    N --> O{リジェクトあり?}
    O -->|Yes| P[rc=1で終了]
    O -->|No| Q[rc=0で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=2 | 設定エラー | /etc/mailが存在しない | sendmailの設定確認 |
| rc=2 | 設定エラー | /var/log/maillogが存在しない | syslogの設定確認 |
| rc=2 | 設定エラー | daily_status_mail_rejects_logs <= 0 | periodic.confの設定確認 |
| rc=1 | 情報通知 | リジェクトされたメールが存在 | リジェクト理由の確認・対応 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

前提条件エラー（rc=2）の場合は、各エラーメッセージに従い設定を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用処理） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ログファイルサイズに依存 |
| 目標処理時間 | 数秒〜数十秒（ログサイズに依存） |
| メモリ使用量上限 | ログファイルのパイプ処理のため最小限 |

## 排他制御

同時実行に関する排他制御は行わない。読み取り専用の処理のため、並列実行しても問題はない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ヘッダ出力 | 処理開始時 | "Checking for rejected mail hosts:" |
| 集計結果 | 解析完了後 | 件数 リジェクト理由 ホスト情報（件数降順） |
| エラー通知 | 前提条件不満足時 | 該当する設定エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| リターンコード | rc=1（リジェクトあり） | daily_output設定先（デフォルト: root） |
| リターンコード | rc=2（設定エラー） | daily_output設定先（badconfig扱い） |

## 備考

- 本バッチはデフォルトで有効化されている。
- RFC 3164（伝統的syslog）とRFC 5424（構造化syslog）の両方のタイムスタンプ形式に対応している。
- 解析対象のsendmailルールセット: check_relay、check_rcpt、その他check_*ルールセット。
- 圧縮ログファイルの対応形式: gzip(.gz)、bzip2(.bz2)、xz(.xz)、zstd(.zst)。
- 短縮モード（shorten=YES）ではcut -d" " -f2,3により、リジェクト理由とルールセット名のみが表示される。
- ソースファイル: `usr.sbin/periodic/etc/daily/460.status-mail-rejects`
