# バッチ設計書 27-480.leapfile-ntpd

## 概要

本ドキュメントは、FreeBSDのperiodicフレームワークにおける日次バッチ `480.leapfile-ntpd` の設計仕様を定義する。本バッチはNTPデーモンのうるう秒ファイル（leapfile）の取得・更新を行う。

### 本バッチの処理概要

本バッチは、NTPデーモン（ntpd）が使用するうるう秒情報ファイルを定期的にダウンロードし最新の状態に保つためのスクリプトである。

**業務上の目的・背景**：うるう秒はIERS（国際地球回転・基準系事業）により不定期に挿入される。NTPデーモンがうるう秒の挿入を正しく処理するためには、最新のうるう秒ファイル（leapfile）が必要である。本バッチにより、うるう秒ファイルを自動的に取得・更新し、NTPの時刻同期精度を維持する。

**バッチの実行タイミング**：日次（dailyのperiodicフレームワークにより実行）。デフォルトで有効（daily_ntpd_leapfile_enable=YES）。

**主要な処理内容**：
1. periodic.confからグローバル設定を読み込む
2. `daily_ntpd_leapfile_enable` 変数を評価し、有効時のみ処理を実行
3. ntpdサービスが有効かつleapfileの取得が必要かを確認
4. anticongestion関数によりランダムスリープ（ダウンロードサーバ負荷分散）
5. `service ntpd fetch` でうるう秒ファイルを取得

**前後の処理との関連**：dailyのNTP関連バッチの一つであり、460.status-mail-rejectsの後に実行される。480.status-ntpdと同じ480番台だが、leapfileの取得とステータス確認は独立した処理である。

**影響範囲**：NTPデーモンのうるう秒ファイルを更新する。外部サーバへのHTTP/HTTPS接続が発生する。ネットワークアクセスが必要。

## バッチ種別

データ連携（外部データ取得・更新）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodicフレームワークのdaily実行時刻 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron（periodicフレームワーク経由） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ntpdサービスが有効 | `service ntpd enabled` がtrueを返すこと |
| leapfile取得が必要 | `service ntpd needfetch` がtrueを返すこと |
| ネットワーク接続 | 外部NTPサーバへの接続が可能であること |
| periodic.confの存在 | /etc/defaults/periodic.confが読み取り可能であること |

### 実行可否判定

`daily_ntpd_leapfile_enable` 変数がYES（大文字小文字不問）の場合に処理を実行する。デフォルトはYES。さらに、ntpdサービスが有効（enabled）かつleapfileの取得が必要（needfetch）な場合にのみ実際のダウンロードを行う。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_ntpd_leapfile_enable | 文字列 | No | YES | バッチの有効/無効切り替え |
| anticongestion_sleeptime | 数値 | No | 3600 | 最大ランダムスリープ秒数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数定義 | ローカルオーバーライド設定 |
| 外部NTPサーバ | HTTP/HTTPS | うるう秒ファイルのダウンロード元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| うるう秒ファイル | テキスト | NTPデーモンが参照するleapfile |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | ntpd設定に依存（通常 /var/db/ntpd.leap-seconds.list等） |
| 出力先 | ntpdの設定に従う |
| 文字コード | ASCII |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.confを読み込み、source_periodic_confsでオーバーライド適用
2. 有効/無効判定
   └─ daily_ntpd_leapfile_enableの値をcase文で判定
3. ntpdサービス確認
   └─ service ntpd enabled でサービスの有効性確認
4. leapfile取得必要性確認
   └─ service ntpd needfetch で取得の必要性を判定
5. anticongestion処理
   └─ ランダムスリープ（0〜anticongestion_sleeptime秒）でサーバ負荷分散
6. leapfile取得
   └─ service ntpd fetch でうるう秒ファイルをダウンロード
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_ntpd_leapfile_enable = YES?}
    C -->|No| D[終了]
    C -->|Yes| E{service ntpd enabled?}
    E -->|No| D
    E -->|Yes| F{service ntpd needfetch?}
    F -->|No| D
    F -->|Yes| G[anticongestion: ランダムスリープ]
    G --> H["service ntpd fetch"]
    H --> D
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | ネットワークエラー | 外部サーバへの接続失敗 | ネットワーク接続・ファイアウォール設定の確認 |
| N/A | サービスエラー | ntpd fetchの実行失敗 | ntpdの設定・ログの確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（次回日次実行で再試行） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

leapfileの取得失敗は次回の日次実行で自動的にリトライされる。継続的に失敗する場合は、ネットワーク接続性およびntpdの設定を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回（単一ファイルのダウンロード） |
| 目標処理時間 | anticongestion_sleeptime（最大3600秒）+ ダウンロード時間 |
| メモリ使用量上限 | 最小 |

## 排他制御

anticongestion関数によるランダムスリープが排他制御の代替として機能する。PERIODIC_ANTICONGESTION_FILEが存在する場合にのみスリープが実行され、同一periodic実行内で一度だけ適用される。対話実行時（PERIODIC_IS_INTERACTIVE設定時）はスリープをスキップする。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 取得結果 | fetch完了後 | service ntpd fetchの出力結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| リターンコード | rc != 0 | daily_output設定先（デフォルト: root） |

## 備考

- 本バッチはデフォルトで有効化されている。
- anticongestion関数は、複数ホストが同時にleapfileをダウンロードするサンダリングハード問題を回避するため、0〜3600秒のランダムスリープを行う。
- `service ntpd needfetch` は、現在のleapfileが期限切れまたは存在しない場合にtrueを返す。
- スクリプト内でrc変数が明示的に設定されないケースがあり、periodic.conf由来のrc変数がそのまま使用される可能性がある。
- ソースファイル: `usr.sbin/periodic/etc/daily/480.leapfile-ntpd`
