# バッチ設計書 28-480.status-ntpd

## 概要

本ドキュメントは、FreeBSDのperiodicフレームワークにおける日次バッチ `480.status-ntpd` の設計仕様を定義する。本バッチはNTPデーモンの同期状態を確認し、同期先が存在するかを報告する。

### 本バッチの処理概要

本バッチは、NTPデーモン（ntpd）の時刻同期状態を日次で確認し、正常に同期しているかを管理者に報告するステータス監視スクリプトである。

**業務上の目的・背景**：NTPによる正確な時刻同期は、ログのタイムスタンプ整合性、証明書の有効期限判定、分散システムの整合性など、多くのシステム運用において不可欠である。NTPデーモンが正常に同期されていない状態を早期に検出し、管理者に通知することを目的とする。

**バッチの実行タイミング**：日次（dailyのperiodicフレームワークにより実行）。デフォルトでは無効（daily_status_ntpd_enable=NO）。

**主要な処理内容**：
1. periodic.confからグローバル設定を読み込む
2. `daily_status_ntpd_enable` 変数を評価し、有効時のみ処理を実行
3. `ntpq -pn` コマンドでNTPピア一覧を取得・表示
4. 出力中に同期中のサーバ（行頭が `*` で始まる行）が存在するかを確認
5. 同期サーバが見つからない場合はrc=1を返す

**前後の処理との関連**：dailyのNTP関連バッチの一つであり、480.leapfile-ntpdと同じ480番台。leapfileの取得とは独立した処理である。

**影響範囲**：NTPデーモンへの問い合わせ（ntpq）のみ。読み取り専用の確認処理であり、NTP設定への変更は行わない。

## バッチ種別

レポート生成（ステータス監視）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodicフレームワークのdaily実行時刻 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron（periodicフレームワーク経由） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ntpq(1)の利用可能性 | ntpqコマンドが実行可能であること |
| ntpdの動作 | NTPデーモンが動作中であること |
| periodic.confの存在 | /etc/defaults/periodic.confが読み取り可能であること |

### 実行可否判定

`daily_status_ntpd_enable` 変数がYES（大文字小文字不問）の場合に処理を実行する。デフォルトはNOであり、管理者が明示的に有効化する必要がある。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_status_ntpd_enable | 文字列 | No | NO | バッチの有効/無効切り替え |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数定義 | ローカルオーバーライド設定 |
| ntpq -pn | コマンド出力 | NTPピア一覧と同期状態 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | NTPピア一覧（periodicフレームワークが収集） |

### 出力ファイル仕様

本バッチは直接ファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（標準出力経由） |
| 出力先 | daily_output設定に依存（デフォルト: root宛メール） |
| 文字コード | システムロケール依存 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.confを読み込み、source_periodic_confsでオーバーライド適用
2. rc=0を初期化
3. 有効/無効判定
   └─ daily_status_ntpd_enableの値をcase文で判定
4. NTPピア情報取得
   └─ ntpq -pnを実行し、tee /dev/stderrで標準出力へ表示
5. 同期サーバ判定
   └─ grep '^\*' で同期中サーバ（先頭*印）を検索
6. リターンコード設定
   └─ 同期サーバあり: rc=0、なし: rc=1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C[rc=0初期化]
    C --> D{daily_status_ntpd_enable = YES?}
    D -->|No| E[rc=0で終了]
    D -->|Yes| F["ntpq -pn | tee /dev/stderr 実行"]
    F --> G["grep '^\*' で同期サーバ検索"]
    G --> H{同期サーバあり?}
    H -->|Yes| I[rc=0で終了]
    H -->|No| J[rc=1で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=1 | 同期異常 | NTPの同期サーバが見つからない | ntpdの設定・ネットワーク接続の確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

同期サーバなし（rc=1）の場合は、ntp.confの設定が正しいか、NTPサーバへのネットワーク到達性があるか、ntpdプロセスが正常に動作しているかを確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用処理） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回（NTPピア一覧の取得） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小（シェルスクリプト実行のみ） |

## 排他制御

同時実行に関する排他制御は行わない。読み取り専用の確認処理のため、並列実行しても問題はない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ヘッダ出力 | 処理開始時 | "NTP status:" |
| ピア一覧 | ntpq実行後 | ntpq -pnの出力結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| リターンコード | rc=1（同期なし） | daily_output設定先（デフォルト: root） |

## 備考

- 本バッチはデフォルトで無効化されている。NTP時刻同期の監視が必要なシステムで明示的に有効化すること。
- ntpq -pnの出力で行頭の記号の意味: `*` = 現在の同期サーバ、`+` = 候補サーバ、`-` = 不採用サーバ、` ` = 到達不能等。
- `-p` フラグはピア一覧表示、`-n` フラグはDNS逆引きを無効にし数値IPアドレスで表示する。
- ソースファイル: `usr.sbin/periodic/etc/daily/480.status-ntpd`
