# バッチ設計書 29-500.queuerun

## 概要

本ドキュメントは、FreeBSDのperiodicフレームワークにおける日次バッチ `500.queuerun` の設計仕様を定義する。本バッチはsendmailのメールキューの送信処理をバックグラウンドで実行する。

### 本バッチの処理概要

本バッチは、sendmailのメールキューに滞留しているメールの送信処理を日次で実行するスクリプトである。メインキューとサブミットキューの両方を対象とする。

**業務上の目的・背景**：メールキューに滞留したメールは、一時的な配送障害（宛先サーバのダウン、ネットワーク障害等）により送信できなかったものである。日次でキューの再送信処理を実行することで、一時障害が解消した後のメール配送を促進する。sendmailの通常動作でもキュー処理は行われるが、本バッチにより確実な日次再送信を保証する。

**バッチの実行タイミング**：日次（dailyのperiodicフレームワークにより実行）。デフォルトで有効（daily_queuerun_enable=YES）。

**主要な処理内容**：
1. periodic.confからグローバル設定を読み込む
2. /usr/sbin/sendmailの実行可能性を確認
3. `sendmail -q` をバックグラウンドで実行（メインキュー処理）
4. サブミットキュー処理が有効かつ/etc/mail/submit.cf存在時、`sendmail -q -Ac` をバックグラウンドで実行

**前後の処理との関連**：dailyメール関連バッチとして440.status-mailq（キュー状態確認）と関連が深い。440がキューの監視を行い、本バッチがキューの実際の送信処理を行う。

**影響範囲**：sendmailのメールキューに対する書き込み操作が発生する。キュー内のメールを実際に送信するため、外部メールサーバへの接続が発生する。バックグラウンド実行のため、バッチ自体は即時終了する。

## バッチ種別

データ連携（メール送信処理）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodicフレームワークのdaily実行時刻 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron（periodicフレームワーク経由） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| /usr/sbin/sendmailの存在 | sendmailコマンドが実行可能であること |
| periodic.confの存在 | /etc/defaults/periodic.confが読み取り可能であること |

### 実行可否判定

`daily_queuerun_enable` 変数がYES（大文字小文字不問）の場合に処理を実行する。デフォルトはYES。/usr/sbin/sendmailが実行可能でない場合はrc=2（badconfig）を返す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_queuerun_enable | 文字列 | No | YES | バッチの有効/無効切り替え |
| daily_submit_queuerun | 文字列 | No | YES | サブミットキューも処理するか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数定義 | ローカルオーバーライド設定 |
| sendmailメールキュー | メールデータ | 送信待ちのメール |
| /etc/mail/submit.cf | 設定ファイル | サブミットキュー設定（存在確認用） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 外部メールサーバ | SMTP | キュー内メールの配送 |

### 出力ファイル仕様

本バッチは直接ファイル出力を行わない。sendmail -qの実行によりキュー内メールが配送される。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | メールキュー内メールの宛先 |
| 文字コード | メールのエンコーディングに依存 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.confを読み込み、source_periodic_confsでオーバーライド適用
2. 有効/無効判定
   └─ daily_queuerun_enableの値をcase文で判定
3. sendmail実行可能性チェック
   └─ /usr/sbin/sendmailが実行可能か-xで確認（不可ならrc=2）
4. メインキュー処理
   └─ /usr/sbin/sendmail -q をバックグラウンドで実行（出力は/dev/nullへリダイレクト）
5. サブミットキュー処理（オプション）
   └─ daily_submit_queuerun=YESかつ/etc/mail/submit.cf存在時
   └─ /usr/sbin/sendmail -q -Ac をバックグラウンドで実行
6. リターンコード設定
   └─ rc=0（バックグラウンド起動成功）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_queuerun_enable = YES?}
    C -->|No| D[rc=0で終了]
    C -->|Yes| E{/usr/sbin/sendmail実行可能?}
    E -->|No| F[rc=2で終了]
    E -->|Yes| G["sendmail -q & （バックグラウンド）"]
    G --> H{daily_submit_queuerun = YES?}
    H -->|No| I[rc=0で終了]
    H -->|Yes| J{/etc/mail/submit.cf存在?}
    J -->|No| I
    J -->|Yes| K["sendmail -q -Ac & （バックグラウンド）"]
    K --> I
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。sendmailのメールキューファイルに対する操作が行われる。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=2 | 設定エラー | /usr/sbin/sendmailが実行不可 | sendmailのインストール確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（sendmail自体がキュー内メールのリトライを管理） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

sendmailが利用不可の場合（rc=2）は、sendmailパッケージの再インストールまたはMTAの設定を確認する。バックグラウンドで起動されたsendmailプロセスのエラーはsendmailのログに記録される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | sendmailのキュー処理に依存 |
| コミットタイミング | 各メール送信完了時 |
| ロールバック条件 | sendmailのキュー管理に依存（送信失敗時はキューに残留） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | キュー内のメール数に依存 |
| 目標処理時間 | バッチ自体は即時終了（sendmailはバックグラウンド） |
| メモリ使用量上限 | sendmailプロセスの使用量に依存 |

## 排他制御

sendmail自体がキュー処理の排他制御を行う。バッチスクリプトとしての排他制御は行わない。sendmail -qの実行はバックグラウンド（`&`）で行われるため、バッチの実行時間には影響しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラー通知 | sendmail不可時 | "$daily_queuerun_enable is set but /usr/sbin/sendmail isn't executable" |
| sendmailログ | バックグラウンド処理中 | sendmailのログ（/var/log/maillog等） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| リターンコード | rc=2（設定エラー） | daily_output設定先（badconfig扱い） |

## 備考

- 本バッチはデフォルトで有効化されている。
- sendmail -qの出力はすべて /dev/null にリダイレクトされる。実際の送信結果はsendmailのログファイル（通常 /var/log/maillog）に記録される。
- バックグラウンド実行（`&`）のため、バッチの終了時点ではキュー処理は完了していない可能性がある。
- サブミットキュー処理（sendmail -q -Ac）は、/etc/mail/submit.cfが存在する場合にのみ実行される。
- ソースファイル: `usr.sbin/periodic/etc/daily/500.queuerun`
