# バッチ設計書 30-510.status-world-kernel

## 概要

本ドキュメントは、FreeBSDのperiodicフレームワークにおける日次バッチ `510.status-world-kernel` の設計仕様を定義する。本バッチは実行中のuserland（ユーザランド）とkernelのバージョンが一致しているかを確認・報告する。

### 本バッチの処理概要

本バッチは、FreeBSDシステムにおいてユーザランド（userland）とカーネル（kernel）のバージョンが同期しているかを日次で確認し、不一致を検出した場合に管理者に報告するステータス監視スクリプトである。

**業務上の目的・背景**：FreeBSDではカーネルとユーザランドを個別にアップデートできるが、バージョンが不一致の状態はシステムの不安定性やセキュリティリスクを招く可能性がある。特にfreebsd-updateやソースからのビルド後に再起動を忘れた場合や、ユーザランドのみ/カーネルのみを更新した場合に検出する。この不一致を日次で自動検出し、管理者に通知することで、システムの整合性を維持する。

**バッチの実行タイミング**：日次（dailyのperiodicフレームワークにより実行）。デフォルトで有効（daily_status_world_kernel=YES）。

**主要な処理内容**：
1. periodic.confからグローバル設定を読み込む
2. `daily_status_world_kernel` 変数を評価し、有効時のみ処理を実行
3. `uname -U` でユーザランドバージョンを取得
4. `uname -K` でカーネルバージョンを取得
5. 両バージョンを比較し、不一致の場合はそれぞれの値を報告

**前後の処理との関連**：dailyステータス確認シリーズの一部であり、500.queuerunの後、800番台のZFS保守バッチの前に実行される。他のバッチとの直接的なデータ依存はない。

**影響範囲**：uname(1)コマンドによるシステム情報の読み取りのみ。読み取り専用の確認処理であり、システムへの変更は行わない。

## バッチ種別

レポート生成（ステータス監視）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodicフレームワークのdaily実行時刻 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron（periodicフレームワーク経由） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| /usr/bin/unameの利用可能性 | unameコマンドが実行可能であること |
| uname -Uおよび-Kの対応 | FreeBSDのunameが-Uおよび-Kオプションに対応していること |
| periodic.confの存在 | /etc/defaults/periodic.confが読み取り可能であること |

### 実行可否判定

`daily_status_world_kernel` 変数がYES（大文字小文字不問）の場合に処理を実行する。デフォルトはYES。uname -Uまたはuname -Kの出力が空の場合はexit 0で即時終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_status_world_kernel | 文字列 | No | YES | バッチの有効/無効切り替え |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数定義 | ローカルオーバーライド設定 |
| /usr/bin/uname -U | コマンド出力 | ユーザランドバージョン番号 |
| /usr/bin/uname -K | コマンド出力 | カーネルバージョン番号 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | バージョン一致/不一致情報（periodicフレームワークが収集） |

### 出力ファイル仕様

本バッチは直接ファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（標準出力経由） |
| 出力先 | daily_output設定に依存（デフォルト: root宛メール） |
| 文字コード | システムロケール依存 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.confを読み込み、source_periodic_confsでオーバーライド適用
2. 有効/無効判定
   └─ daily_status_world_kernelの値をcase文で判定
3. バージョン取得
   └─ /usr/bin/uname -U でユーザランドバージョン、/usr/bin/uname -K でカーネルバージョンを取得
4. 空チェック
   └─ いずれかが空の場合はexit 0で終了（-Uまたは-Kオプション非対応の古いシステム）
5. バージョン比較
   └─ ユーザランドとカーネルのバージョンを文字列比較
6. 結果出力
   └─ 一致時: "Userland and kernel are in sync." 不一致時: 各バージョン値を表示
7. リターンコード設定
   └─ 一致: rc=0、不一致: rc=1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_status_world_kernel = YES?}
    C -->|No| D[rc=0で終了]
    C -->|Yes| E[rc=0初期化]
    E --> F["uname -U でユーザランドバージョン取得"]
    F --> G["uname -K でカーネルバージョン取得"]
    G --> H{どちらかが空?}
    H -->|Yes| I[exit 0で終了]
    H -->|No| J{バージョン一致?}
    J -->|Yes| K["'Userland and kernel are in sync.' 表示"]
    J -->|No| L["不一致メッセージと各バージョン表示, rc=1"]
    K --> M[終了]
    L --> M
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=1 | バージョン不一致 | ユーザランドとカーネルのバージョンが異なる | システムの再起動またはfreebsd-updateの完了確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

バージョン不一致（rc=1）が検出された場合は、以下を確認する：
1. freebsd-updateまたはソースビルド後の再起動が必要か
2. カーネルのみ/ユーザランドのみが更新されていないか
3. 意図的なバージョン不一致でないか

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用処理） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回（バージョン比較のみ） |
| 目標処理時間 | 即時（ミリ秒オーダー） |
| メモリ使用量上限 | 最小（シェルスクリプト実行のみ） |

## 排他制御

同時実行に関する排他制御は行わない。読み取り専用の確認処理のため、並列実行しても問題はない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ヘッダ出力 | 処理開始時 | "Checking userland and kernel versions:" |
| 一致通知 | バージョン一致時 | "Userland and kernel are in sync." |
| 不一致通知 | バージョン不一致時 | "Userland and kernel are not in sync" + 各バージョン値 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| リターンコード | rc=1（バージョン不一致） | daily_output設定先（デフォルト: root） |

## 備考

- 本バッチはデフォルトで有効化されている。
- 設定変数名は `daily_status_world_kernel` であり、他のバッチと異なり末尾に `_enable` がない点に注意。
- `uname -U` はユーザランドのバージョン番号（__FreeBSD_version）を返す。`uname -K` はカーネルのバージョン番号を返す。
- バージョン番号は数値形式（例: 1400097）で表される。
- uname -Uまたは-Kが利用できない古いFreeBSDでは、出力が空となりexit 0で正常終了する。
- ソースファイル: `usr.sbin/periodic/etc/daily/510.status-world-kernel`
