# バッチ設計書 31-800.scrub-zfs

## 概要

本ドキュメントは、FreeBSD periodic(8) フレームワークの日次バッチ `800.scrub-zfs` の設計仕様を記載する。ZFSプールのスクラブ（データ整合性チェック）を定期的に実行し、サイレントデータ破損を早期に検出するためのバッチである。

### 本バッチの処理概要

**業務上の目的・背景**：ZFSファイルシステムではディスク上のデータがチェックサムで保護されているが、長期間放置するとビットロット（サイレントデータ破損）が蓄積する可能性がある。本バッチは定期的にZFSプール全体のスクラブを実行することで、データ整合性を能動的に検証し、冗長構成（ミラー・RAIDz）であれば自動修復を行い、ストレージの信頼性を維持する。

**バッチの実行タイミング**：日次（daily periodic）で実行される。ただし、前回スクラブからの経過日数が閾値（デフォルト35日）未満の場合はスキップされるため、実質的には約35日周期での実行となる。

**主要な処理内容**：
1. periodic.confから設定を読み込み、有効/無効を判定する
2. 対象プール一覧を取得する（設定値またはzpool listから自動取得）
3. 各プールの状態チェック（FAULTED/UNAVAILはスキップ）を行う
4. プール個別の閾値設定を評価し、前回スクラブからの経過日数と比較する
5. 閾値を超過したプールに対してzpool scrubを実行する
6. スクラブ進行中やリシルバリング中のプールはスキップする

**前後の処理との関連**：本バッチは単独で動作し、他のperiodicバッチとの直接的な依存関係はない。ただし、No.32（801.trim-zfs）とは同一プールに対する保守操作であり、同時実行は避けるべきである。

**影響範囲**：ZFSプール全体のI/O負荷に影響を与える。スクラブ実行中はディスクI/Oが増大するため、本番環境ではパフォーマンスへの影響を考慮する必要がある。

## バッチ種別

データクレンジング / ストレージ保守（ZFSデータ整合性検証）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次（実質的には閾値日数ごと） |
| 実行時刻 | daily periodic の実行時刻（デフォルト: 03:01、periodic.confに依存） |
| 実行曜日 | 毎日（閾値による制御あり） |
| 実行日 | 該当なし |
| トリガー | cron経由のperiodic daily |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| daily_scrub_zfs_enable=YES | periodic.confで有効化されていること（デフォルトはNO） |
| ZFSプールが存在すること | zpool listで取得可能なプールが1つ以上あること |
| zpoolコマンドが利用可能 | ZFS関連ユーティリティがインストール済みであること |

### 実行可否判定

1. `daily_scrub_zfs_enable` が YES でなければ即座に終了（rc=0）
2. 各プールに対し以下の判定を実施:
   - プールが存在しない場合: WARNING出力してスキップ（rc=2）
   - プールがFAULTED状態: スキップ（rc=3）
   - プールがUNAVAIL状態: スキップ（rc=4）
   - 前回スクラブからの経過日数が閾値未満: スキップ
   - スクラブが進行中: スキップ
   - リシルバリングが進行中: スキップ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_scrub_zfs_enable | string | Yes | NO | バッチの有効/無効 |
| daily_scrub_zfs_pools | string | No | (全プール) | 対象プール名のスペース区切りリスト |
| daily_scrub_zfs_default_threshold | integer | No | 35 | スクラブ間隔の日数閾値 |
| daily_scrub_zfs_{pool}_threshold | integer | No | (default_threshold) | プール個別の閾値（プール名の`.:-`は`_`に変換） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数 | ユーザカスタム設定 |
| zpool list -H -o name | コマンド出力 | 全ZFSプール名一覧 |
| zpool history {pool} | コマンド出力 | プールの操作履歴（最終スクラブ日時取得用） |
| zpool status {pool} | コマンド出力 | プールの現在状態（スクラブ/リシルバ進行中判定） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 各プールの処理結果メッセージ |
| 終了コード | 整数 | 0:無効/スキップ, 1:スクラブ開始, 2:プール不在, 3:FAULTED, 4:UNAVAIL |

### 出力ファイル仕様

本バッチはファイル出力を行わない。結果はperiodicフレームワークにより標準出力経由でメール通知またはログ出力される。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 標準出力（periodicが収集） |
| 文字コード | システムロケール依存 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.conf および source_periodic_confs
2. 有効/無効判定
   └─ daily_scrub_zfs_enable が YES でなければ rc=0 で終了
3. 対象プール一覧取得
   └─ daily_scrub_zfs_pools が未設定なら zpool list -H -o name で全プール取得
4. プールごとのループ処理
   ├─ 4a. プール存在チェック（zpool list）
   ├─ 4b. プール状態チェック（FAULTED/UNAVAIL判定）
   ├─ 4c. プール個別閾値の取得
   ├─ 4d. 最終スクラブ日時の取得（zpool history）
   ├─ 4e. 経過日数の計算と閾値比較
   ├─ 4f. スクラブ/リシルバ進行中チェック（zpool status）
   └─ 4g. zpool scrub 実行
5. 終了コード返却
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定ファイル読み込み]
    B --> C{daily_scrub_zfs_enable=YES?}
    C -->|No| Z1[rc=0で終了]
    C -->|Yes| D[対象プール一覧取得]
    D --> E[プールループ開始]
    E --> F{プール存在?}
    F -->|No| G[WARNING出力, rc=2]
    F -->|Yes| H{FAULTED/UNAVAIL?}
    H -->|Yes| I[スキップ, rc=3or4]
    H -->|No| J[閾値取得]
    J --> K[最終スクラブ日時取得]
    K --> L{経過日数 < 閾値?}
    L -->|Yes| M[スキップ]
    L -->|No| N{スクラブ/リシルバ進行中?}
    N -->|Yes| O[スキップ]
    N -->|No| P[zpool scrub実行]
    G --> Q{次のプール?}
    I --> Q
    M --> Q
    O --> Q
    P --> Q
    Q -->|Yes| E
    Q -->|No| R[終了コード返却]
    R --> Z2[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。ZFSプールのメタデータに対する操作（スクラブ）を実行する。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | 該当なし | 該当なし | データベース操作なし |

### テーブル別操作詳細

該当なし（データベース操作なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=2 | WARNING | 指定プールが存在しない | periodic.confのdaily_scrub_zfs_poolsを確認 |
| rc=3 | FAULTED | プールがFAULTED状態 | zpool statusで原因調査、ディスク交換等 |
| rc=4 | UNAVAIL | プールがUNAVAIL状態 | デバイス接続状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- スクラブ開始に失敗した場合、次回のdaily periodic実行時に再試行される（閾値条件を満たしていれば）
- FAULTED/UNAVAILプールは手動での復旧が必要
- `zpool status {pool}` でスクラブ結果を確認し、エラーがあれば手動対応

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（シェルスクリプト） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし（zpool scrubは中断可能: zpool scrub -s） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | システム上のZFSプール数（通常1〜数個） |
| 目標処理時間 | スクラブ自体はバックグラウンド実行のため、バッチの実行時間は短い |
| メモリ使用量上限 | シェルスクリプトのため最小限 |

## 排他制御

- ZFSプールに対してスクラブが既に進行中の場合はスキップする
- リシルバリングが進行中の場合もスキップする
- 同一プールに対するzpool scrubの同時実行はZFS自体が排他制御する

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Scrubbing of zfs pools:" |
| 進捗ログ | プールごと | "starting scrub of pool '{pool}':" / スキップ理由 |
| 結果案内 | プールごと | "consult 'zpool status {pool}' for the result" |
| 警告ログ | プール不在時 | "WARNING: pool '{pool}' ... does not exist" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc >= 2 | periodicメール通知（daily output） |
| スクラブ結果 | zpool statusでエラー検出時 | システム管理者 |

## 備考

- デフォルトでは無効（daily_scrub_zfs_enable=NO）であり、ZFSを使用するシステムでは明示的に有効化する必要がある
- プール名に `.`、`:`、`-` を含む場合、個別閾値の変数名ではこれらが `_` に変換される
- スクラブはバックグラウンドで実行されるため、本バッチの終了は即座に行われる（スクラブ完了を待たない）
- スクラブの所要時間はプールサイズとI/O性能に依存し、数時間〜数日かかる場合がある
