# バッチ設計書 32-801.trim-zfs

## 概要

本ドキュメントは、FreeBSD periodic(8) フレームワークの日次バッチ `801.trim-zfs` の設計仕様を記載する。ZFSプールに対してTRIM（SSDのブロック解放通知）処理を実行し、SSDの性能維持と寿命延長を図るバッチである。

### 本バッチの処理概要

**業務上の目的・背景**：SSD（Solid State Drive）では、削除済みブロックをドライブに通知（TRIM/UNMAP）することで、ガベージコレクションの効率化とライト性能の維持が実現される。本バッチはZFSプールに対してTRIMを定期的に実行し、SSDベースのストレージの性能劣化を防止する。

**バッチの実行タイミング**：日次（daily periodic）で実行される。TRIM処理が既に進行中の場合はスキップされる。

**主要な処理内容**：
1. periodic.confから設定を読み込み、有効/無効を判定する
2. 対象プール一覧を取得する（設定値またはzpool listから自動取得）
3. 各プールの状態チェック（FAULTED/UNAVAILはスキップ）を行う
4. TRIM処理が進行中でないプールに対してzpool trimを実行する

**前後の処理との関連**：No.31（800.scrub-zfs）と同じZFSプールに対する保守操作である。スクラブとTRIMの同時実行による過負荷に注意が必要である。

**影響範囲**：SSDデバイスを含むZFSプールに対するI/O操作。TRIM処理はバックグラウンドで実行され、ディスクI/Oに影響を与える。

## バッチ種別

データクレンジング / ストレージ保守（SSD TRIM処理）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | daily periodic の実行時刻（デフォルト: 03:01、periodic.confに依存） |
| 実行曜日 | 毎日 |
| 実行日 | 該当なし |
| トリガー | cron経由のperiodic daily |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| daily_trim_zfs_enable=YES | periodic.confで有効化されていること（デフォルトはNO） |
| ZFSプールが存在すること | zpool listで取得可能なプールが1つ以上あること |
| SSDデバイスがプールに含まれること | TRIMはSSDにのみ有効 |

### 実行可否判定

1. `daily_trim_zfs_enable` が YES でなければ即座に終了（rc=0）
2. 各プールに対し以下の判定を実施:
   - プールが存在しない場合: WARNING出力してスキップ（rc=2）
   - プールがFAULTED状態: スキップ（rc=3）
   - プールがUNAVAIL状態: スキップ（rc=4）
   - TRIM処理が進行中: スキップ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_trim_zfs_enable | string | Yes | NO | バッチの有効/無効 |
| daily_trim_zfs_pools | string | No | (全プール) | 対象プール名のスペース区切りリスト |
| daily_trim_zfs_flags | string | No | (空) | zpool trimに渡す追加フラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数 | ユーザカスタム設定 |
| zpool list -H -o name | コマンド出力 | 全ZFSプール名一覧 |
| zpool list -Hohealth {pool} | コマンド出力 | プールの健全性状態 |
| zpool status {pool} | コマンド出力 | TRIM進行中判定（trimming文字列の検出） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 各プールの処理結果メッセージ |
| 終了コード | 整数 | 0:無効/正常, 2:プール不在, 3:FAULTED, 4:UNAVAIL |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 標準出力（periodicが収集） |
| 文字コード | システムロケール依存 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.conf および source_periodic_confs
2. 有効/無効判定
   └─ daily_trim_zfs_enable が YES でなければ rc=0 で終了
3. 対象プール一覧取得
   └─ daily_trim_zfs_pools が未設定なら zpool list -H -o name で全プール取得
4. プールごとのループ処理
   ├─ 4a. プール存在・健全性チェック（zpool list -Hohealth）
   ├─ 4b. プール状態チェック（FAULTED/UNAVAIL判定）
   ├─ 4c. TRIM進行中チェック（zpool status | grep trimming）
   └─ 4d. zpool trim 実行
5. 終了コード返却
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定ファイル読み込み]
    B --> C{daily_trim_zfs_enable=YES?}
    C -->|No| Z1[rc=0で終了]
    C -->|Yes| D[対象プール一覧取得]
    D --> E[プールループ開始]
    E --> F{プール存在?}
    F -->|No| G[WARNING出力, rc=2]
    F -->|Yes| H{FAULTED/UNAVAIL?}
    H -->|Yes| I[スキップ, rc=3or4]
    H -->|No| J{TRIM進行中?}
    J -->|Yes| K[スキップ]
    J -->|No| L[zpool trim実行]
    G --> M{次のプール?}
    I --> M
    K --> M
    L --> M
    M -->|Yes| E
    M -->|No| N[終了コード返却]
    N --> Z2[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | 該当なし | 該当なし | データベース操作なし |

### テーブル別操作詳細

該当なし（データベース操作なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=2 | WARNING | 指定プールが存在しない | periodic.confのdaily_trim_zfs_poolsを確認 |
| rc=3 | FAULTED | プールがFAULTED状態 | zpool statusで原因調査 |
| rc=4 | UNAVAIL | プールがUNAVAIL状態 | デバイス接続状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- TRIM開始に失敗した場合、次回のdaily periodic実行時に再試行される
- FAULTED/UNAVAILプールは手動での復旧が必要
- TRIMはSSD機能であるため、HDD環境では実効性がない

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（シェルスクリプト） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし（zpool trim -s で停止可能） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | システム上のZFSプール数（通常1〜数個） |
| 目標処理時間 | バッチ自体は即座に完了（TRIMはバックグラウンド実行） |
| メモリ使用量上限 | シェルスクリプトのため最小限 |

## 排他制御

- TRIM処理が既に進行中の場合はスキップする（zpool statusの出力で"trimming"文字列を検出）
- 同一プールに対するzpool trimの同時実行はZFS自体が排他制御する

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Trimming of zfs pools:" |
| 進捗ログ | プールごと | "starting trim of pool '{pool}'" / スキップ理由 |
| 警告ログ | プール不在時 | "WARNING: pool '{pool}' ... does not exist" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc >= 2 | periodicメール通知（daily output） |

## 備考

- デフォルトでは無効（daily_trim_zfs_enable=NO）であり、SSD環境では明示的に有効化することが推奨される
- `daily_trim_zfs_flags` でzpool trimに追加オプションを渡すことが可能
- 800.scrub-zfsとは異なり、閾値による実行間隔制御は実装されていない（毎日実行試行される）
- TRIM処理はSSDコントローラに対する通知であり、HDDには効果がない
