# バッチ設計書 33-999.local

## 概要

本ドキュメントは、FreeBSD periodic(8) フレームワークの日次バッチ `999.local`（daily）の設計仕様を記載する。ローカル環境固有のカスタムスクリプトを実行するためのフレームワーク提供バッチであり、管理者が独自のメンテナンスタスクを追加するための拡張ポイントである。

### 本バッチの処理概要

**業務上の目的・背景**：FreeBSDのperiodicフレームワークには標準的なシステム保守タスクが組み込まれているが、個々のシステム環境には固有の保守要件が存在する。本バッチは `/etc/daily.local` などのローカルスクリプトを実行する仕組みを提供し、periodicフレームワークの統一されたレポーティング・通知機能を活用しながらカスタム処理を実行可能にする。後方互換性のために維持されている。

**バッチの実行タイミング**：日次（daily periodic）で実行される。periodicの最後のスクリプト（番号999）として実行される。

**主要な処理内容**：
1. periodic.confから設定を読み込む
2. `$daily_local` 変数に指定されたスクリプトパス一覧をループで処理する
3. 各スクリプトが実行可能ファイルなら直接実行、通常ファイルならshで実行する
4. ファイルが存在しない場合やパスが絶対パスでない場合はエラー出力する

**前後の処理との関連**：periodicの番号999として、全ての標準日次バッチの後に実行される。標準バッチの結果に依存するカスタム処理を配置するのに適している。

**影響範囲**：ローカルスクリプトの内容に完全に依存する。本バッチ自体はフレームワークとして最小限の処理のみ行う。

## バッチ種別

ローカルカスタム処理（フレームワーク拡張ポイント）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | daily periodic の実行時刻（デフォルト: 03:01、periodic.confに依存） |
| 実行曜日 | 毎日 |
| 実行日 | 該当なし |
| トリガー | cron経由のperiodic daily |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| daily_local変数が設定されていること | periodic.confで実行するスクリプトパスが指定されていること |
| 指定スクリプトが存在すること | 絶対パスで指定されたファイルが存在すること |

### 実行可否判定

本バッチには有効/無効の制御変数はない。`$daily_local` が空の場合は何も実行されずrc=0で終了する。各スクリプトに対して以下を判定する:
- 絶対パスであること（/で始まること）
- ファイルが存在すること
- 実行可能ファイルの場合は直接実行、それ以外はshで実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_local | string | No | (空) | 実行するスクリプトのパス一覧（スペース区切り） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数 | ユーザカスタム設定 |
| $daily_local で指定されたスクリプト | シェルスクリプト | ローカルカスタムスクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 各スクリプトの実行結果メッセージ |
| 終了コード | 整数 | 0:正常/未実行, 2:ファイル不在/パスエラー, 3:スクリプト実行失敗 |

### 出力ファイル仕様

本バッチ自体はファイル出力を行わない（カスタムスクリプトの出力はスクリプト依存）。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 標準出力（periodicが収集） |
| 文字コード | システムロケール依存 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.conf および source_periodic_confs
2. $daily_local のスクリプト一覧をループ
   ├─ 2a. 絶対パス判定（/で始まるか）
   ├─ 2b. 実行可能ファイル判定（-x）
   ├─ 2c. 通常ファイル判定（-f）
   └─ 2d. スクリプト実行
3. 終了コード返却
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定ファイル読み込み]
    B --> C[daily_localのスクリプトループ]
    C --> D{絶対パス?}
    D -->|No| E[エラー出力, rc=2]
    D -->|Yes| F{実行可能ファイル?}
    F -->|Yes| G[直接実行]
    F -->|No| H{通常ファイル?}
    H -->|Yes| I[sh で実行]
    H -->|No| J[No such file, rc=2]
    G --> K{実行成功?}
    I --> K
    K -->|No| L[rc=3]
    K -->|Yes| M{次のスクリプト?}
    L --> M
    E --> M
    J --> M
    M -->|Yes| C
    M -->|No| N[終了コード返却]
    N --> O[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | 該当なし | 該当なし | データベース操作なし |

### テーブル別操作詳細

該当なし（データベース操作なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=2 | ファイル不在 | 指定スクリプトが存在しない | パスとファイルの存在を確認 |
| rc=2 | パスエラー | 相対パスが指定された | 絶対パスに修正 |
| rc=3 | 実行失敗 | スクリプトが非0で終了 | スクリプト自体のデバッグが必要 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- スクリプト実行失敗時は、個別スクリプトの内容を確認してデバッグする
- 本バッチフレームワーク自体には障害復旧機構はない

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（シェルスクリプト） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | daily_localに設定されたスクリプト数 |
| 目標処理時間 | カスタムスクリプトの内容に依存 |
| メモリ使用量上限 | カスタムスクリプトの内容に依存 |

## 排他制御

本バッチ自体には排他制御機構はない。カスタムスクリプト側で必要に応じて実装する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 実行ログ | スクリプト実行時 | "Running {script}:" |
| エラーログ | ファイル不在時 | "{script}: No such file" |
| エラーログ | パスエラー時 | "{script}: Not an absolute path" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc >= 2 | periodicメール通知（daily output） |

## 備考

- 本バッチは後方互換性のために `/etc/daily.local` の実行機能を提供する
- 番号999は、全ての標準periodicスクリプトの後に実行されることを保証する
- カスタムスクリプトは絶対パスで指定する必要がある
- 1つのスクリプトが失敗しても、残りのスクリプトは引き続き実行される
