# バッチ設計書 34-310.locate

## 概要

本ドキュメントは、FreeBSD periodic(8) フレームワークの週次バッチ `310.locate` の設計仕様を記載する。locate(1)コマンドで使用するファイル名データベースを再構築し、高速なファイル検索を可能にするバッチである。

### 本バッチの処理概要

**業務上の目的・背景**：locate(1)コマンドはファイルシステム全体を即座に検索できるユーティリティであるが、事前に構築されたデータベースに依存する。ファイルの追加・削除・移動が日常的に行われるため、データベースの定期的な再構築が必要である。本バッチは週次でデータベースを更新し、locateコマンドの検索精度を維持する。

**バッチの実行タイミング**：週次（weekly periodic）で実行される。

**主要な処理内容**：
1. periodic.confから設定を読み込み、有効/無効を判定する
2. /etc/locate.rcからlocateの設定を読み込む
3. データベースファイルの準備（touch、権限設定）を行う
4. nobody権限でlocate.updatedbを実行し、データベースを再構築する
5. データベースファイルを読み取り専用に設定する

**前後の処理との関連**：No.35（320.whatis）と同様のデータベース更新バッチであるが、独立して動作する。

**影響範囲**：/var/db/locate.database の更新。ファイルシステム全体のスキャンにより一時的にI/O負荷が上昇する。nobodyユーザ権限で実行されるためセキュリティリスクは限定的。

## バッチ種別

データベース再構築 / インデックス更新

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 週次 |
| 実行時刻 | weekly periodic の実行時刻（periodic.confに依存） |
| 実行曜日 | 土曜日（デフォルト） |
| 実行日 | 該当なし |
| トリガー | cron経由のperiodic weekly |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| weekly_locate_enable=YES | periodic.confで有効化されていること（デフォルトYES） |
| /etc/locate.rc が存在すること | locate設定ファイルが読み込み可能であること |
| /usr/libexec/locate.updatedb が存在すること | データベース更新プログラムが利用可能であること |

### 実行可否判定

`weekly_locate_enable` が YES でなければ即座にrc=0で終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| weekly_locate_enable | string | Yes | YES | バッチの有効/無効 |
| FCODES | string | No | /var/db/locate.database | データベースファイルのパス（locate.rcで設定） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数 | ユーザカスタム設定 |
| /etc/locate.rc | シェル変数 | locate固有の設定（FCODES等） |
| ファイルシステム全体 | ディレクトリツリー | スキャン対象（locate.updatedb設定に依存） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| /var/db/locate.database | バイナリ | locateデータベースファイル |
| 標準出力 | テキスト | 処理結果メッセージ |
| 終了コード | 整数 | 0:無効/正常, 3:エラー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | locate.database（FCODESで変更可能） |
| 出力先 | /var/db/ |
| 文字コード | バイナリ形式 |
| 区切り文字 | 該当なし（バイナリ） |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.conf および source_periodic_confs
2. 有効/無効判定
   └─ weekly_locate_enable が YES でなければ rc=0 で終了
3. locate.rc読み込み
   └─ FCODESなどの設定を取得
4. データベースファイル準備
   ├─ 4a. touch でファイル作成/更新
   ├─ 4b. chown nobody でオーナー変更
   └─ 4c. chmod 644 で書き込み可能に設定
5. データベース再構築
   └─ nice -n 5 su -fm nobody で locate.updatedb を低優先度で実行
6. パーミッション設定
   └─ chmod 444 で読み取り専用に設定
7. 終了コード返却
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定ファイル読み込み]
    B --> C{weekly_locate_enable=YES?}
    C -->|No| Z1[rc=0で終了]
    C -->|Yes| D[locate.rc読み込み]
    D --> E[DBファイルtouchとchown nobody]
    E --> F{準備成功?}
    F -->|No| G[rc=3]
    F -->|Yes| H[nice -n 5でlocate.updatedb実行]
    H --> I{更新成功?}
    I -->|No| J[rc=3]
    I -->|Yes| K[chmod 444で読み取り専用化]
    K --> L[バッチ終了]
    G --> L
    J --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| データベース再構築 | /var/db/locate.database | 全件再構築 | ファイルシステム全体のスキャン結果で置換 |

### テーブル別操作詳細

#### /var/db/locate.database

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| 全件再構築 | ファイルパス一覧 | ファイルシステム全体のパス | locate.updatedbが生成 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=3 | ファイル操作失敗 | touch/chown/chmodが失敗 | パーミッションとディレクトリ確認 |
| rc=3 | 更新失敗 | locate.updatedbの実行が失敗 | ディスク容量、ファイルシステム状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- データベース再構築失敗時は、古いデータベースが残っているためlocate自体は引き続き利用可能（検索結果が古い）
- ディスク容量不足が原因の場合は不要ファイルの削除が必要
- 次回の週次実行で再試行される

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル操作） |
| コミットタイミング | locate.updatedb完了時 |
| ロールバック条件 | 該当なし（旧ファイルは上書きされる） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ファイルシステム上の全ファイル数 |
| 目標処理時間 | ファイル数とI/O性能に依存（数分〜数十分） |
| メモリ使用量上限 | locate.updatedbの実装に依存 |

## 排他制御

- locate.updatedbはnobody権限で実行され、データベースファイルの書き込みロックはOS側で管理される
- 更新中はデータベースファイルのパーミッションが644であり、locateコマンドからの参照は可能

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Rebuilding locate database:" |
| 終了ログ | バッチ終了時 | periodicフレームワークが収集 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc = 3 | periodicメール通知（weekly output） |

## 備考

- デフォルトで有効（weekly_locate_enable=YES）
- データベース更新はnobody権限でnice値5（低優先度）で実行されるため、システムへの影響は抑制されている
- ルートディレクトリ（/）からスキャンが行われるため、大規模ファイルシステムでは相応の時間がかかる
- locate.rcでスキャン対象やオプションをカスタマイズ可能
