# バッチ設計書 35-320.whatis

## 概要

本ドキュメントは、FreeBSD periodic(8) フレームワークの週次バッチ `320.whatis` の設計仕様を記載する。whatis(1)コマンドで使用するマニュアルページデータベースを再構築し、マニュアルページの検索機能を最新の状態に維持するバッチである。

### 本バッチの処理概要

**業務上の目的・背景**：whatis(1)およびapropos(1)コマンドはマニュアルページのキーワード検索に使用されるが、事前構築されたデータベースに依存する。ソフトウェアのインストール・アンインストールによりマニュアルページが変更されるため、定期的なデータベース再構築が必要である。本バッチは各ロケールに対応したwhatisデータベースを再構築する。

**バッチの実行タイミング**：週次（weekly periodic）で実行される。

**主要な処理内容**：
1. periodic.confから設定を読み込み、有効/無効を判定する
2. manpath(1)でマニュアルページのパス一覧を取得する
3. makewhatis.localでデフォルトロケールのwhatisデータベースを再構築する
4. manpath -qLでローカライズされたマニュアルのロケール一覧を取得し、各ロケールのデータベースも再構築する

**前後の処理との関連**：No.34（310.locate）と同様のデータベース更新バッチであるが、独立して動作する。

**影響範囲**：MANPATHで指定された各ディレクトリ内のwhatisデータベースファイル。マニュアルページのディレクトリツリーのスキャンにより一時的にI/O負荷が上昇する。

## バッチ種別

データベース再構築 / インデックス更新

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 週次 |
| 実行時刻 | weekly periodic の実行時刻（periodic.confに依存） |
| 実行曜日 | 土曜日（デフォルト） |
| 実行日 | 該当なし |
| トリガー | cron経由のperiodic weekly |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| weekly_whatis_enable=YES | periodic.confで有効化されていること（デフォルトYES） |
| /usr/bin/manpath が存在すること | manpathコマンドが利用可能であること |
| /usr/libexec/makewhatis.local が存在すること | whatisデータベース構築プログラムが利用可能であること |

### 実行可否判定

1. `weekly_whatis_enable` が YES でなければ即座にrc=0で終了する
2. manpathコマンドの実行に失敗した場合はrc=3で終了する
3. MANPATHが空の場合はrc=3で終了する

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| weekly_whatis_enable | string | Yes | YES | バッチの有効/無効 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数 | ユーザカスタム設定 |
| manpath -q | コマンド出力 | マニュアルページディレクトリ一覧 |
| manpath -qL | コマンド出力 | ローカライズされたマニュアルのロケール一覧 |
| マニュアルページディレクトリ | ファイルシステム | MANPATHで指定されたディレクトリツリー |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| whatis データベース | バイナリ | 各MANPATHディレクトリ内のwhatisデータベース |
| 標準出力 | テキスト | 処理結果メッセージ |
| 終了コード | 整数 | 0:無効/正常, 3:エラー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | whatis（各マニュアルディレクトリ内） |
| 出力先 | MANPATHの各ディレクトリ |
| 文字コード | ロケール依存 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.conf および source_periodic_confs
2. 有効/無効判定
   └─ weekly_whatis_enable が YES でなければ rc=0 で終了
3. MANPATH取得
   └─ /usr/bin/manpath -q を実行
4. MANPATHの検証
   └─ 空の場合はエラー出力して rc=3 で終了
5. デフォルトwhatisデータベース構築
   └─ makewhatis.local "${MANPATH}" を実行
6. ロケール一覧取得
   └─ manpath -qL でローカライズロケールを取得
7. 各ロケールのwhatisデータベース構築
   └─ LC_ALL=$i makewhatis.local -a -L "${MANPATH}" をロケールごとに実行
8. 終了コード返却
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定ファイル読み込み]
    B --> C{weekly_whatis_enable=YES?}
    C -->|No| Z1[rc=0で終了]
    C -->|Yes| D[manpath -q でMANPATH取得]
    D --> E{manpath成功?}
    E -->|No| F[rc=3で終了]
    E -->|Yes| G{MANPATHが空?}
    G -->|Yes| H[エラー出力, rc=3]
    G -->|No| I[makewhatis.localでデフォルトDB構築]
    I --> J[manpath -qLでロケール一覧取得]
    J --> K{ロケールあり?}
    K -->|No| L[終了]
    K -->|Yes| M[ロケールごとにmakewhatis.local -a -L実行]
    M --> L
    H --> L
    F --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| デフォルトDB構築 | whatisデータベース | 全件再構築 | MANPATHの全マニュアルページをインデックス |
| ロケール別DB構築 | whatisデータベース | 追記更新 | 各ロケールのマニュアルページを追記 |

### テーブル別操作詳細

#### whatisデータベース

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| 全件再構築 | マニュアルエントリ | 全MANPATHのマニュアルページ | makewhatis.localが生成 |
| ロケール追記 | マニュアルエントリ | 各ロケールのマニュアルページ | -a -L オプションで追記 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=3 | manpath失敗 | manpathコマンドが正常終了しない | manpath設定とmanディレクトリを確認 |
| rc=3 | MANPATH空 | マニュアルディレクトリが見つからない | /usr/share/man等の存在を確認 |
| rc=3 | makewhatis失敗 | データベース構築が失敗 | ディスク容量、パーミッションを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- データベース再構築失敗時は、古いデータベースが残っているためwhatis/aproposは引き続き利用可能（結果が古い）
- 次回の週次実行で再試行される

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル操作） |
| コミットタイミング | makewhatis.local完了時 |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | インストール済みマニュアルページ数 |
| 目標処理時間 | マニュアルページ数に依存（通常数分以内） |
| メモリ使用量上限 | makewhatis.localの実装に依存 |

## 排他制御

特別な排他制御機構はない。データベースファイルの書き込みはOS側のファイルロックに依存する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Rebuilding whatis database:" |
| エラーログ | MANPATH空時 | "manpath failed to find any manpage directories" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc = 3 | periodicメール通知（weekly output） |

## 備考

- デフォルトで有効（weekly_whatis_enable=YES）
- 多言語対応: manpath -qLで検出されたロケールごとにデータベースが構築される
- ロケール別のデータベース構築は -a（追記）オプションで実行される
- MANPATHはmanpath(1)コマンドにより自動的に決定される（/etc/manpath.conf等に依存）
