# バッチ設計書 36-340.noid

## 概要

本ドキュメントは、FreeBSD periodic(8) フレームワークの週次バッチ `340.noid` の設計仕様を記載する。所有者不明（nouser/nogroup）のファイルをファイルシステムから検索し、セキュリティ上のリスクを報告するバッチである。

### 本バッチの処理概要

**業務上の目的・背景**：ユーザやグループが削除された後、そのユーザ/グループが所有していたファイルは所有者不明（orphan）状態になる。これらのファイルはセキュリティ上のリスクを伴い、新たに同じUID/GIDが割り当てられたユーザが意図せずアクセス権を得る可能性がある。本バッチは所有者不明ファイルを定期的に検出し、管理者に報告することでセキュリティリスクを可視化する。

**バッチの実行タイミング**：週次（weekly periodic）で実行される。

**主要な処理内容**：
1. periodic.confから設定を読み込み、有効/無効を判定する
2. ホストがjail環境でない場合、jail内のパスを除外リストに追加する
3. find(1)コマンドで所有者不明（-nouser）またはグループ不明（-nogroup）のファイルを検索する
4. ローカルファイルシステムのみを対象とし、リモートファイルシステムは除外する
5. 検出結果を標準出力に報告する

**前後の処理との関連**：No.37（450.status-security weekly）の一部として間接的にセキュリティ監査に寄与するが、直接的な依存関係はない。

**影響範囲**：ファイルシステム全体のスキャンにより一時的にI/O負荷が上昇する。読み取り専用の操作であり、データの変更は行わない。

## バッチ種別

セキュリティ監査 / レポート生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 週次 |
| 実行時刻 | weekly periodic の実行時刻（periodic.confに依存） |
| 実行曜日 | 土曜日（デフォルト） |
| 実行日 | 該当なし |
| トリガー | cron経由のperiodic weekly |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| weekly_noid_enable=YES | periodic.confで有効化されていること（デフォルトはNO） |
| find(1)が利用可能であること | 標準ユーティリティが存在すること |

### 実行可否判定

`weekly_noid_enable` が YES でなければ即座にrc=0で終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| weekly_noid_enable | string | Yes | NO | バッチの有効/無効 |
| weekly_noid_dirs | string | No | / | 検索対象ディレクトリ（スペース区切り） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数 | ユーザカスタム設定 |
| jail -f "$jail_conf" -e | コマンド出力 | jail設定からjailのpathを取得（除外用） |
| /etc/rc.subr | シェル関数 | rc設定読み込み用 |
| sysctl security.jail.jailed | コマンド出力 | jail内かどうかの判定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 所有者不明ファイル一覧（先頭にスペース2個） |
| 標準エラー | テキスト | 同上（tee /dev/stderrで両方に出力） |
| 終了コード | 整数 | 0:検出なし/無効, 1:検出あり |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 標準出力（periodicが収集） |
| 文字コード | システムロケール依存 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.conf および source_periodic_confs
2. 有効/無効判定
   └─ weekly_noid_enable が YES でなければ rc=0 で終了
3. jail除外リスト構築
   ├─ 3a. sysctl で jail 内かどうか判定
   ├─ 3b. jail外の場合、/etc/rc.subr を読み込み jail設定を取得
   └─ 3c. jail -f でjailのpathを取得し、-path ... -prune で除外
4. findコマンドの実行
   └─ find -H {dirs} で -nouser または -nogroup のファイルを検索
      （ローカルファイルシステムのみ、jail pathは除外）
5. 検出件数でリターンコードを決定
   └─ 件数 > 1 の場合 rc=1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定ファイル読み込み]
    B --> C{weekly_noid_enable=YES?}
    C -->|No| Z1[rc=0で終了]
    C -->|Yes| D{jail内?}
    D -->|Yes| F[除外リストなし]
    D -->|No| E[jail設定からpathを取得し除外リスト構築]
    E --> F
    F --> G[find -nouser -nogroup 実行]
    G --> H{検出あり?}
    H -->|Yes| I[rc=1]
    H -->|No| J[rc=0]
    I --> K[バッチ終了]
    J --> K
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | 該当なし | 該当なし | データベース操作なし |

### テーブル別操作詳細

該当なし（データベース操作なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=1 | 検出あり | 所有者不明ファイルが存在する | 該当ファイルの所有者を修正または削除 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- findコマンドの実行エラーは特別に処理されない
- 検出されたファイルは管理者が手動で確認・対処する必要がある

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用操作） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ファイルシステム上の全ファイル数 |
| 目標処理時間 | ファイル数とI/O性能に依存（数分〜数十分） |
| メモリ使用量上限 | find(1)の実装に依存（最小限） |

## 排他制御

特別な排他制御機構はない。読み取り専用操作のため排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Check for files with an unknown user or group:" |
| 結果ログ | 検出時 | 所有者不明ファイルのパス一覧 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc = 1 | periodicメール通知（weekly output） |

## 備考

- デフォルトでは無効（weekly_noid_enable=NO）であり、セキュリティ監査が必要な環境で有効化する
- jail環境内での実行時は、jailのユーザ/グループデータベースが参照される
- ホスト環境では、jailのパスは自動的に除外される（jail内は独自のUID/GIDを持つため）
- リモートファイルシステム（NFS等）は `! -fstype local` により自動除外される
- find -H オプションにより、シンボリックリンクのリンク先ではなくリンク自体を評価する
