# バッチ設計書 38-999.local

## 概要

本ドキュメントは、FreeBSD periodic(8) フレームワークの週次バッチ `999.local`（weekly）の設計仕様を記載する。ローカル環境固有の週次カスタムスクリプトを実行するためのフレームワーク提供バッチであり、管理者が独自の週次メンテナンスタスクを追加するための拡張ポイントである。

### 本バッチの処理概要

**業務上の目的・背景**：日次の999.local（No.33）と同様に、weeklyの periodicフレームワークにもローカルカスタムスクリプトの実行ポイントが必要である。本バッチは `/etc/weekly.local` などのローカルスクリプトを実行する仕組みを提供し、週次固有の保守タスクをperiodic フレームワークに統合する。後方互換性のために維持されている。

**バッチの実行タイミング**：週次（weekly periodic）で実行される。periodicの最後のスクリプト（番号999）として実行される。

**主要な処理内容**：
1. periodic.confから設定を読み込む
2. `$weekly_local` 変数に指定されたスクリプトパス一覧をループで処理する
3. 各スクリプトが実行可能ファイルなら直接実行、通常ファイルならshで実行する
4. ファイルが存在しない場合やパスが絶対パスでない場合はエラー出力する

**前後の処理との関連**：No.33（daily/999.local）の週次版。periodicの番号999として、全ての標準週次バッチの後に実行される。

**影響範囲**：ローカルスクリプトの内容に完全に依存する。本バッチ自体はフレームワークとして最小限の処理のみ行う。

## バッチ種別

ローカルカスタム処理（フレームワーク拡張ポイント）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 週次 |
| 実行時刻 | weekly periodic の実行時刻（periodic.confに依存） |
| 実行曜日 | 土曜日（デフォルト） |
| 実行日 | 該当なし |
| トリガー | cron経由のperiodic weekly |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| weekly_local変数が設定されていること | periodic.confで実行するスクリプトパスが指定されていること |
| 指定スクリプトが存在すること | 絶対パスで指定されたファイルが存在すること |

### 実行可否判定

本バッチには有効/無効の制御変数はない。`$weekly_local` が空の場合は何も実行されずrc=0で終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| weekly_local | string | No | (空) | 実行するスクリプトのパス一覧（スペース区切り） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数 | ユーザカスタム設定 |
| $weekly_local で指定されたスクリプト | シェルスクリプト | ローカルカスタムスクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 各スクリプトの実行結果メッセージ |
| 終了コード | 整数 | 0:正常/未実行, 2:ファイル不在/パスエラー, 3:スクリプト実行失敗 |

### 出力ファイル仕様

本バッチ自体はファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 標準出力（periodicが収集） |
| 文字コード | システムロケール依存 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.conf および source_periodic_confs
2. $weekly_local のスクリプト一覧をループ
   ├─ 2a. 絶対パス判定（/で始まるか）
   ├─ 2b. 実行可能ファイル判定（-x）
   ├─ 2c. 通常ファイル判定（-f）
   └─ 2d. スクリプト実行
3. 終了コード返却
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定ファイル読み込み]
    B --> C[weekly_localのスクリプトループ]
    C --> D{絶対パス?}
    D -->|No| E[エラー出力, rc=2]
    D -->|Yes| F{実行可能ファイル?}
    F -->|Yes| G[直接実行]
    F -->|No| H{通常ファイル?}
    H -->|Yes| I[sh で実行]
    H -->|No| J[No such file, rc=2]
    G --> K{実行成功?}
    I --> K
    K -->|No| L[rc=3]
    K -->|Yes| M{次のスクリプト?}
    L --> M
    E --> M
    J --> M
    M -->|Yes| C
    M -->|No| N[終了コード返却]
    N --> O[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | 該当なし | 該当なし | データベース操作なし |

### テーブル別操作詳細

該当なし（データベース操作なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=2 | ファイル不在 | 指定スクリプトが存在しない | パスとファイルの存在を確認 |
| rc=2 | パスエラー | 相対パスが指定された | 絶対パスに修正 |
| rc=3 | 実行失敗 | スクリプトが非0で終了 | スクリプト自体のデバッグが必要 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- スクリプト実行失敗時は、個別スクリプトの内容を確認してデバッグする
- 1つのスクリプトが失敗しても残りのスクリプトは引き続き実行される

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（シェルスクリプト） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | weekly_localに設定されたスクリプト数 |
| 目標処理時間 | カスタムスクリプトの内容に依存 |
| メモリ使用量上限 | カスタムスクリプトの内容に依存 |

## 排他制御

本バッチ自体には排他制御機構はない。カスタムスクリプト側で必要に応じて実装する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 実行ログ | スクリプト実行時 | "Running {script}:" |
| エラーログ | ファイル不在時 | "{script}: No such file" |
| エラーログ | パスエラー時 | "{script}: Not an absolute path" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc >= 2 | periodicメール通知（weekly output） |

## 備考

- 本バッチは後方互換性のために `/etc/weekly.local` の実行機能を提供する
- No.33（daily/999.local）と同一のロジックであり、参照する変数名（weekly_local）のみが異なる
- 番号999は、全ての標準weeklyスクリプトの後に実行されることを保証する
- カスタムスクリプトは絶対パスで指定する必要がある
