# バッチ設計書 39-200.accounting

## 概要

本ドキュメントは、FreeBSD periodic(8) フレームワークの月次バッチ `200.accounting`（monthly）の設計仕様を記載する。ログインアカウンティング情報を集計し、各ユーザの接続時間を報告するバッチである。

### 本バッチの処理概要

**業務上の目的・背景**：システム利用状況の把握はセキュリティ監査やリソース管理の基盤である。本バッチは utx.log（ログイン/ログアウト記録）を解析し、各ユーザの月間接続時間を集計・報告することで、システム利用状況の可視化とアカウンティングを実現する。異常な接続パターンの検出にも活用できる。

**バッチの実行タイミング**：月次（monthly periodic）で実行される。

**主要な処理内容**：
1. periodic.confから設定を読み込み、有効/無効を判定する
2. umaskを066に設定し、一時ファイルのセキュリティを確保する
3. utx.logのローテーション済みファイル（utx.log.0）を取得する
4. 圧縮形式（gz/bz2/xz/zst）の場合は一時ファイルに展開する
5. ac -p コマンドで各ユーザの接続時間を集計し、接続時間の降順でソートして報告する
6. 一時ファイルを削除し、umaskを元に戻す

**前後の処理との関連**：No.13（daily/310.accounting）がプロセスアカウンティングログのローテーションを担当するのに対し、本バッチはログインアカウンティングの月次集計を担当する。

**影響範囲**：/var/log/utx.log.0 の読み取りのみ。一時ファイルの作成・削除が発生するが、元データの変更は行わない。

## バッチ種別

集計処理 / レポート生成（ログインアカウンティング）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 月次 |
| 実行時刻 | monthly periodic の実行時刻（periodic.confに依存） |
| 実行曜日 | 該当なし |
| 実行日 | 月初（デフォルト） |
| トリガー | cron経由のperiodic monthly |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| monthly_accounting_enable=YES | periodic.confで有効化されていること（デフォルトYES） |
| /var/log/utx.log.0 が存在すること | ローテーション済みログファイルが存在すること |
| ac(8)コマンドが利用可能 | ログインアカウンティングツールが存在すること |

### 実行可否判定

1. `monthly_accounting_enable` が YES でなければ即座にrc=0で終了する
2. utx.log.0 が存在しない場合:
   - 圧縮版（.gz/.bz2/.xz/.zst）が存在すれば展開して使用する
   - いずれも存在しなければエラーメッセージを出力しrc=2で終了する

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| monthly_accounting_enable | string | Yes | YES | バッチの有効/無効 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数 | ユーザカスタム設定 |
| /var/log/utx.log.0 | バイナリ（utmpx形式） | ローテーション済みログインログ |
| /var/log/utx.log.0.gz | gzip圧縮 | 圧縮版ログインログ |
| /var/log/utx.log.0.bz2 | bzip2圧縮 | 圧縮版ログインログ |
| /var/log/utx.log.0.xz | xz圧縮 | 圧縮版ログインログ |
| /var/log/utx.log.0.zst | zstd圧縮 | 圧縮版ログインログ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | ユーザ別接続時間一覧（接続時間降順） |
| 標準エラー | テキスト | 同上（tee /dev/stderrで両方に出力） |
| 終了コード | 整数 | 0:無効/正常, 1:データあり, 2:ファイル不在 |

### 出力ファイル仕様

本バッチはファイル出力を行わない。結果はperiodicフレームワークにより収集される。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 標準出力（periodicが収集） |
| 文字コード | システムロケール依存 |
| 区切り文字 | スペース区切り（ac -p の出力形式） |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.conf および source_periodic_confs
2. umask設定
   └─ umask 066 で一時ファイルの権限を制限
3. 有効/無効判定
   └─ monthly_accounting_enable が YES でなければ rc=0 で終了
4. 入力ファイル取得
   ├─ 4a. utx.log.0 が存在すればそのまま使用
   ├─ 4b. 圧縮版が存在すれば一時ファイルに展開
   └─ 4c. いずれも不在の場合はエラー（rc=2）
5. アカウンティング集計
   └─ ac -p -w {file} | sort -nr -k 2 でユーザ別接続時間を降順で出力
6. 後処理
   ├─ 6a. 一時ファイルがあれば削除
   └─ 6b. umaskを元に戻す
7. 終了コード返却
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定読み込み, umask 066]
    B --> C{monthly_accounting_enable=YES?}
    C -->|No| Z1[umask復元, rc=0で終了]
    C -->|Yes| D{utx.log.0存在?}
    D -->|Yes| H[filetoread=utx.log.0]
    D -->|No| E{圧縮版存在?}
    E -->|Yes| F[一時ファイルに展開]
    E -->|No| G[エラー出力, rc=2]
    F --> H2[filetoread=一時ファイル]
    H --> I[ac -p -w で集計, sort -nr -k 2]
    H2 --> I
    I --> J[結果出力]
    J --> K{一時ファイルあり?}
    K -->|Yes| L[一時ファイル削除]
    K -->|No| M[umask復元]
    L --> M
    G --> M
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | 該当なし | 該当なし | データベース操作なし |

### テーブル別操作詳細

該当なし（データベース操作なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=1 | 展開失敗 | 圧縮ファイルの展開に失敗 | 圧縮ファイルの整合性を確認 |
| rc=2 | ファイル不在 | utx.log.0 およびその圧縮版が存在しない | ログローテーション設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- utx.log.0が存在しない場合はログローテーション（newsyslog等）の設定を確認する
- 圧縮ファイルが破損している場合は手動で対処が必要
- 次回の月次実行時に再試行される

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用操作） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | utx.log.0のレコード数（月間ログイン/ログアウト数） |
| 目標処理時間 | 通常数秒以内 |
| メモリ使用量上限 | ac(8)の実装に依存（最小限） |

## 排他制御

特別な排他制御機構はない。読み取り専用操作のため排他制御は不要。一時ファイルはmktempで一意の名前が生成される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Doing login accounting:" |
| 結果ログ | 集計完了時 | ユーザ別接続時間一覧（接続時間降順） |
| エラーログ | ファイル不在時 | "$monthly_accounting_enable is set but utx.log.0 doesn't exist" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc = 2 | periodicメール通知（monthly output） |

## 備考

- デフォルトで有効（monthly_accounting_enable=YES）
- umask 066 が設定されるため、一時ファイルは所有者のみアクセス可能（600）
- 4種類の圧縮形式（gzip、bzip2、xz、zstd）に対応している
- 出力はユーザ名と接続時間がスペース区切りで表示され、接続時間の降順でソートされる
- utx.log.0はnewsyslog(8)等によるローテーション後のファイルであり、前月のデータを含む
