# バッチ設計書 4-130.clean-msgs

## 概要

本ドキュメントは、FreeBSD periodicフレームワークにおける日次システムメッセージクリーンアップバッチ `130.clean-msgs` の設計を記述する。本バッチは `msgs(1)` コマンドを使用してシステムメッセージファイルを削除する。

### 本バッチの処理概要

本バッチは、`/var/msgs` ディレクトリに蓄積されたシステムアナウンスメッセージを、`msgs -c` コマンドを用いて削除する処理を行う。

**業務上の目的・背景**：FreeBSDの `msgs(1)` システムは、システム管理者がユーザに対してブロードキャストメッセージを送信するための仕組みである。これらのメッセージは `/var/msgs` ディレクトリに蓄積される。本バッチにより、古いメッセージを自動的に削除し、不要なメッセージの蓄積を防止する。

**バッチの実行タイミング**：日次（daily）。FreeBSD periodicフレームワークにより実行される。

**主要な処理内容**：
1. `/etc/defaults/periodic.conf` および上書き設定ファイルの読み込み
2. `daily_clean_msgs_enable` 変数による有効/無効判定
3. `/var/msgs` ディレクトリの存在確認
4. `msgs -c` コマンドによるメッセージ削除（日数指定オプション付き）

**前後の処理との関連**：daily periodicのクリーンアップカテゴリ（100番台）に属する。`120.clean-preserve` に続いて実行される。

**影響範囲**：`/var/msgs` ディレクトリ内のシステムメッセージファイル。

## バッチ種別

データクレンジング（システムメッセージ削除）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodic(8)のcron設定に依存 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron経由でperiodic(8)から起動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| periodic.confの存在 | `/etc/defaults/periodic.conf` が読み取り可能であること |
| daily_clean_msgs_enable=YES | デフォルト有効 |
| /var/msgsの存在 | ディレクトリが存在すること |
| msgs(1)コマンドの存在 | msgs コマンドが利用可能であること |

### 実行可否判定

`daily_clean_msgs_enable` が `YES`（デフォルト有効）の場合に実行する。`/var/msgs` が存在しない場合はrc=2でエラー。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_clean_msgs_enable | 文字列 | Yes | YES | バッチの有効/無効フラグ |
| daily_clean_msgs_days | 数値 | No | （空） | 削除対象とする日数。空の場合は msgs -c のデフォルト動作 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | デフォルト設定値 |
| /var/msgs | ファイルシステム | 削除対象メッセージの格納先 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 処理メッセージ |
| 終了コード | 数値 | 0:成功、2:設定不備、3:実行エラー |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | 標準出力 |
| 文字コード | システムロケール依存 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ periodic.conf を source
2. 有効/無効判定
   └─ daily_clean_msgs_enable が YES かどうか判定
3. ディレクトリ検証
   └─ /var/msgs が存在しなければ rc=2
4. 日数パラメータ構築
   └─ daily_clean_msgs_days が設定されていれば -N オプションを構築
5. msgs -c 実行
   └─ msgs -c [-N] でメッセージを削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_clean_msgs_enable=YES?}
    C -->|No| Z[rc=0で終了]
    C -->|Yes| D{/var/msgs存在?}
    D -->|No| E[rc=2]
    D -->|Yes| F[msgs -c 実行]
    F --> G{成功?}
    G -->|Yes| H[rc=0]
    G -->|No| I[rc=3]
    H --> Z2[終了]
    I --> Z2
    E --> Z2
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=2 | 設定不備 | /var/msgs が存在しない | ディレクトリを作成する |
| rc=3 | 実行エラー | msgs -c コマンドの実行失敗 | msgs コマンドの存在と /var/msgs のパーミッションを確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

リトライ機構はない。次回のdaily実行時に再度実行される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | msgs コマンドにより即時実行 |
| ロールバック条件 | ロールバック不可 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | /var/msgs 内のメッセージ数（通常少数） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | msgs コマンドの使用量（低い） |

## 排他制御

排他制御の仕組みは実装されていない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | "Cleaning out old system announcements:" |
| 終了ログ | N/A | 明示的な終了ログなし |
| エラーログ | 設定不備時 | /var/msgs が存在しない旨のメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc >= 2 | periodic(8)の出力先（デフォルト: root宛メール） |

## 備考

- デフォルトで有効（daily_clean_msgs_enable=YES）
- `daily_clean_msgs_days` のデフォルト値は空。空の場合、`msgs -c` のデフォルト動作が適用される
- `msgs -c` コマンドは古いメッセージファイルを削除する。`-N` オプションで日数を指定可能
- 他のクリーンアップバッチとは異なり、find コマンドではなく専用の msgs コマンドを使用する
