# バッチ設計書 40-450.status-security

## 概要

本ドキュメントは、FreeBSD periodic(8) フレームワークの月次バッチ `450.status-security`（monthly）の設計仕様を記載する。月次セキュリティチェックスクリプト群を実行し、システムのセキュリティ状態を包括的に確認・報告するバッチである。

### 本バッチの処理概要

**業務上の目的・背景**：日次・週次のセキュリティチェックに加えて、月次でもセキュリティ監査を実行することで、長期間にわたるセキュリティリスクの蓄積を検出する。月次レポートはセキュリティ監査記録としても活用でき、コンプライアンス要件への対応にも寄与する。本バッチはperiodic securityカテゴリのスクリプト群を一括実行するラッパーである。

**バッチの実行タイミング**：月次（monthly periodic）で実行される。

**主要な処理内容**：
1. periodic.confから設定を読み込み、有効/無効を判定する
2. 出力先の制御（インライン/ファイル/メール）を設定する
3. `periodic security` コマンドを実行し、securityカテゴリの全チェックスクリプトを実行する
4. 実行結果を設定に応じて標準出力、ファイル、またはメールで出力する

**前後の処理との関連**：No.25（daily/450.status-security）およびNo.37（weekly/450.status-security）と同じsecurityスクリプト群を実行する。月次固有のスケジュール設定で動作する。

**影響範囲**：securityカテゴリの個別スクリプト（No.42〜55の各セキュリティチェック）を呼び出すため、広範なシステムリソースにアクセスする。読み取り専用の監査操作。

## バッチ種別

セキュリティ監査 / レポート生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 月次 |
| 実行時刻 | monthly periodic の実行時刻（periodic.confに依存） |
| 実行曜日 | 該当なし |
| 実行日 | 月初（デフォルト） |
| トリガー | cron経由のperiodic monthly |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| monthly_status_security_enable=YES | periodic.confで有効化されていること（デフォルトYES） |
| periodic(8)コマンドが利用可能 | securityカテゴリのスクリプトを実行するため |

### 実行可否判定

`monthly_status_security_enable` が YES でなければ即座にrc=0で終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| monthly_status_security_enable | string | Yes | YES | バッチの有効/無効 |
| monthly_status_security_inline | string | No | NO | YESの場合、出力をインライン（標準出力）にする |
| monthly_status_security_output | string | No | (空) | 出力先（空:標準出力, /path:ファイル, その他:メール） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数 | グローバルデフォルト設定 |
| /etc/periodic.conf | シェル変数 | ユーザカスタム設定 |
| /etc/periodic/security/* | シェルスクリプト | セキュリティチェックスクリプト群 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | セキュリティチェック結果（inline/output空の場合） |
| ファイル | テキスト | セキュリティチェック結果（outputが/で始まる場合） |
| メール | テキスト | セキュリティチェック結果（outputがその他の場合） |
| 終了コード | 整数 | 0:無効/正常, 3:エラーまたは検出あり |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | monthly_status_security_outputで指定、または一時ファイル |
| 出力先 | 設定に依存 |
| 文字コード | システムロケール依存 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ /etc/defaults/periodic.conf および source_periodic_confs
2. 有効/無効判定
   └─ monthly_status_security_enable が YES でなければ rc=0 で終了
3. 出力モード決定
   ├─ 3a. inline=YES の場合、output を空に設定（標準出力へ）
   └─ 3b. security_output 環境変数をエクスポート
4. periodic security の実行
   ├─ 4a. output空: 一時ファイルに出力し、内容があれば標準出力に転送
   ├─ 4b. output=/path: "output logged separately" と表示しperiodic実行
   └─ 4c. outputその他: "output mailed separately" と表示しperiodic実行
5. 一時ファイルの削除（4aの場合）
6. 終了コード返却
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定ファイル読み込み]
    B --> C{monthly_status_security_enable=YES?}
    C -->|No| Z1[rc=0で終了]
    C -->|Yes| D{inline=YES?}
    D -->|Yes| E[output=空に設定]
    D -->|No| F[outputをそのまま使用]
    E --> G{outputの値は?}
    F --> G
    G -->|空| H[一時ファイル作成しperiodic security実行]
    G -->|/パス| I[periodic security実行, ファイル出力]
    G -->|その他| J[periodic security実行, メール出力]
    H --> K{一時ファイルに内容あり?}
    K -->|Yes| L[内容を標準出力に出力, rc=3]
    K -->|No| M[rc=0]
    L --> N[一時ファイル削除]
    M --> N
    I --> O[バッチ終了]
    J --> O
    N --> O
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | 該当なし | 該当なし | データベース操作なし |

### テーブル別操作詳細

該当なし（データベース操作なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=3 | セキュリティ検出 | periodic securityがセキュリティ問題を検出 | レポート内容を確認し対処 |
| rc=3 | 実行失敗 | periodic securityの実行が失敗 | securityスクリプトの個別確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- セキュリティチェック失敗時は個別スクリプトの実行状況を確認する
- 一時ファイルの作成に失敗した場合、出力は失われるがエラー処理は行われない

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用操作） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | securityカテゴリの全スクリプト数 |
| 目標処理時間 | 各セキュリティチェックの合計時間に依存 |
| メモリ使用量上限 | 個別スクリプトの実装に依存 |

## 排他制御

特別な排他制御機構はない。一時ファイルはmktempで一意の名前が生成される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Security check:" |
| 出力モードログ | 出力先確定時 | "(output logged separately)" または "(output mailed separately)" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc = 3 | periodicメール通知（monthly output） |

## 備考

- デフォルトで有効（monthly_status_security_enable=YES）
- No.37（weekly/450.status-security）と同一のロジック構造であり、参照する変数名のプレフィックス（monthly_）のみが異なる
- 本バッチはperiodic securityのラッパーであり、実際のセキュリティチェックはsecurityカテゴリの個別スクリプトが実行する
- 出力先は3つのモード（インライン/ファイル/メール）から選択可能
- inline設定がYESの場合、output設定よりも優先される
