# バッチ設計書 43-110.neggrpperm

## 概要

本ドキュメントは、FreeBSDのperiodicセキュリティフレームワークにおけるネガティブグループパーミッション検出バッチ `110.neggrpperm` の設計仕様を記述するものである。

### 本バッチの処理概要

このバッチは、グループパーミッションよりもその他ユーザ（other）のパーミッションの方が緩い、いわゆる「ネガティブグループパーミッション」を持つファイルを検出し報告するセキュリティ監査スクリプトである。

**業務上の目的・背景**：UNIXのファイルパーミッションモデルでは、通常「所有者 >= グループ >= その他」の順にアクセス権が制限される。しかし、設定ミスにより「グループには実行権限がないが、その他ユーザには実行権限がある」といった逆転したパーミッション設定が存在する場合がある。このような設定は意図しないセキュリティホールとなる可能性があるため、定期的に検出して報告する必要がある。

**バッチの実行タイミング**：日次（daily security checkの一部として実行。`security_status_neggrpperm_period` のデフォルトは "daily"）

**主要な処理内容**：
1. periodic.confの読み込みと有効/無効判定
2. ufs/zfsファイルシステムのうち、nosuid/noexecでないマウントポイントを抽出
3. グループパーミッションとotherパーミッションを比較し、逆転しているファイルをfindで検索
4. 検出されたファイルの詳細情報（inode、パーミッション、タイムスタンプ等）を一覧表示
5. 検出件数が1件以上の場合、終了コード1で報告

**前後の処理との関連**：セキュリティチェックスクリプト群の一つで、100.chksetuidの直後に実行される。後続の200.chkmounts以降のチェックとは独立している。

**影響範囲**：ファイルシステムの読み取りのみを行い、システムの状態を変更しない。check_diff関数は使用せず、検出結果を直接標準出力に出力する。

## バッチ種別

セキュリティ監査 / パーミッション検査レポート

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次（デフォルト。weekly/monthlyに変更可能） |
| 実行時刻 | daily security checkの実行時刻に準ずる |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | cron経由 `periodic daily` -> `450.status-security` -> 本スクリプト |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| security_status_neggrpperm_enable | "YES" であること（デフォルト: YES） |
| security_status_neggrpperm_period | 実行周期が現在のPERIODICコンテキストと一致すること（デフォルト: daily） |

### 実行可否判定

`check_yesno_period security_status_neggrpperm_enable` 関数により判定。enable設定がYESで、かつperiod設定が現在の実行コンテキスト（daily/weekly/monthly）と一致する場合に実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| security_status_neggrpperm_enable | YES/NO | No | YES | バッチの有効/無効 |
| security_status_neggrpperm_period | 文字列 | No | daily | 実行周期（daily/weekly/monthly/NO） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | デフォルト設定値 |
| mountコマンド出力 | テキスト | マウントされたufs/zfsファイルシステム一覧 |
| ファイルシステム | バイナリ/テキスト | パーミッション検査対象のファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | ネガティブグループパーミッションを持つファイルの一覧（ls -lid形式） |
| 標準エラー出力 | テキスト | 検出されたファイルの一覧（tee /dev/stderrによる） |

### 出力ファイル仕様

本バッチはログファイルの保存を行わない（check_diff関数を使用しない）。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 標準出力のみ |
| 文字コード | システムロケール依存 |
| 区切り文字 | スペース区切り（ls -lid出力形式） |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ periodic.confを読み込み
2. 実行可否判定
   └─ check_yesno_period security_status_neggrpperm_enable
3. マウントポイント抽出
   └─ mount -t ufs,zfs の出力からnosuid/noexecでないマウントポイントを抽出
4. ネガティブグループパーミッションファイル検索
   └─ findコマンドで以下の条件に一致するファイルを検索：
      - グループ実行なし かつ other実行あり
      - グループ書込なし かつ other書込あり
      - グループ読取なし かつ other読取あり
5. 結果出力
   └─ ls -lid -D "%FT%T" で詳細情報を出力
   └─ tee /dev/stderr で標準エラー出力にも出力し件数をカウント
6. 終了コード判定
   └─ 検出件数 > 0 の場合 rc=1、なければ rc=0
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> D{check_yesno_period?}
    D -->|No| K[exit 0]
    D -->|Yes| E[ufs/zfsマウントポイント抽出]
    E --> F["find: ネガティブグループパーミッション検索"]
    F --> G["ls -lid: 詳細情報取得"]
    G --> H["tee /dev/stderr | wc -l"]
    H --> I{検出件数 > 0?}
    I -->|Yes| J[exit 1]
    I -->|No| K2[exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | - |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 検出報告 | ネガティブグループパーミッションのファイルが検出された場合 | 出力されたファイルのパーミッションを確認し、意図的な設定か修正が必要かを判断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

findコマンドの実行が失敗する場合は、ファイルシステムの状態（マウント状態、権限）を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ファイルシステム全体のファイル数（通常検出されるファイルは少数） |
| 目標処理時間 | ファイルシステムサイズに依存（数分〜数十分） |
| メモリ使用量上限 | findプロセスに依存 |

## 排他制御

findコマンドは `-sx` フラグによりクロスデバイス検索を行わない。ローカルファイルシステムのみを対象とする。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | チェック開始時 | "Checking negative group permissions:" |
| 検出結果 | ファイル検出時 | ls -lid形式のファイル一覧 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ネガティブパーミッション検出 | 1件以上 | daily_status_security_output（デフォルト: root） |

## 備考

- 100.chksetuidとは異なり、check_diff関数を使用しないため、前回結果との差分比較は行わない
- 毎回全件検索の結果を出力する方式のため、ファイル数が多い環境では出力量が大きくなる可能性がある
- パーミッション検査の条件は、実行/書込/読取の各ビットについてグループとotherを個別に比較する
- ソースコード: `usr.sbin/periodic/etc/security/110.neggrpperm`
