# バッチ設計書 44-200.chkmounts

## 概要

本ドキュメントは、FreeBSDのperiodicセキュリティフレームワークにおけるマウントポイント変更検出バッチ `200.chkmounts` の設計仕様を記述するものである。

### 本バッチの処理概要

このバッチは、システムのファイルシステムマウント構成を監視し、前回実行時からの変更を検出・報告するセキュリティ監査スクリプトである。

**業務上の目的・背景**：ファイルシステムのマウント構成の変更は、不正なファイルシステムのマウント（攻撃者による悪意あるファイルシステムの追加）やシステム設定の意図しない変更を示す可能性がある。本バッチは日次でマウント構成を監視し、`/etc/fstab` の設定やランタイムのマウント状態の変更を検出して管理者に通知する。

**バッチの実行タイミング**：日次（daily security checkの一部として実行。`security_status_chkmounts_period` のデフォルトは "daily"）

**主要な処理内容**：
1. periodic.confの読み込みとsecurity.functionsの読み込み
2. amdマウントの除外設定の適用（`security_status_noamd` オプション）
3. カスタム除外パターンの適用（`security_status_chkmounts_ignore` オプション）
4. `mount -p` によるマウント情報の取得とソート
5. `check_diff` 関数による前回結果との差分検出と報告

**前後の処理との関連**：セキュリティチェックスクリプト群の一つで、110.neggrppermの後、300.chkuid0の前に実行される。独立した検査であり他のスクリプトとの依存関係はない。

**影響範囲**：システムの読み取りのみを行い状態を変更しない。`/var/log/mount.today` および `/var/log/mount.yesterday` のログファイルを更新する。

## バッチ種別

セキュリティ監査 / 構成変更検出レポート

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次（デフォルト。weekly/monthlyに変更可能） |
| 実行時刻 | daily security checkの実行時刻に準ずる |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | cron経由 `periodic daily` -> `450.status-security` -> 本スクリプト |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| security_status_chkmounts_enable | "YES" であること（デフォルト: YES） |
| security_status_chkmounts_period | 実行周期が現在のPERIODICコンテキストと一致すること（デフォルト: daily） |
| security.functions | `/etc/periodic/security/security.functions` が読み込み可能であること |

### 実行可否判定

`check_yesno_period security_status_chkmounts_enable` 関数により判定。enable設定がYESで、かつperiod設定が現在の実行コンテキストと一致する場合に実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| security_status_chkmounts_enable | YES/NO | No | YES | バッチの有効/無効 |
| security_status_chkmounts_period | 文字列 | No | daily | 実行周期 |
| security_status_chkmounts_ignore | 正規表現 | No | （空） | 除外パターン |
| security_status_noamd | YES/NO | No | NO | amdマウントを除外するか |
| security_status_logdir | パス | No | /var/log | ログ出力ディレクトリ |
| security_status_diff_flags | 文字列 | No | -b -U 0 | diff出力時のフラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | デフォルト設定値 |
| /etc/fstab | テキスト | ファイルシステムテーブル（存在しない場合は/dev/nullを使用） |
| mount -p コマンド出力 | テキスト | 現在のマウント状態（fstab形式） |
| /var/log/mount.today | テキスト | 前回実行時のマウント情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 変更検出結果のdiff出力 |
| /var/log/mount.today | テキスト | 最新のマウント情報 |
| /var/log/mount.yesterday | テキスト | 前回のマウント情報（ローテーション） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | mount.today / mount.yesterday |
| 出力先 | /var/log/（security_status_logdir設定に依存） |
| 文字コード | システムロケール依存 |
| 区切り文字 | タブ/スペース区切り（mount -p出力形式） |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ periodic.confとsecurity.functionsを読み込み
2. 除外パターン設定
   └─ security_status_chkmounts_ignoreとsecurity_status_noamdから除外パターンを構築
3. 実行可否判定
   └─ check_yesno_period security_status_chkmounts_enable
4. fstab存在確認
   └─ /etc/fstabが存在しない場合はPATH_FSTAB=/dev/nullを設定
5. マウント情報取得
   └─ mount -p でfstab形式のマウント情報を取得しソート
6. フィルタリング
   └─ 除外パターンに一致するエントリを除外（egrep -v）
7. 差分チェック
   └─ check_diff関数で/var/log/mount.todayと比較
   └─ 変更があればdiff出力とファイルローテーション
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> B2[security.functions読み込み]
    B2 --> C[除外パターン構築]
    C --> D{check_yesno_period?}
    D -->|No| K[exit 0]
    D -->|Yes| E{/etc/fstab存在?}
    E -->|No| E2["PATH_FSTAB=/dev/null"]
    E -->|Yes| F["mount -p | sort"]
    E2 --> F
    F --> G[除外パターンでフィルタ]
    G --> H["check_diff: 前回結果と比較"]
    H --> I{差分あり?}
    I -->|Yes| J[diff出力 + ファイルローテーション]
    I -->|No| K2[変更なし]
    J --> L[exit rc]
    K2 --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | - |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 変更検出 | マウント構成に変更があった場合 | diff出力を確認し、正当な変更か不正な変更かを判断 |
| 3 | ファイル操作エラー | ログファイルのコピー/移動に失敗した場合 | ログディレクトリのパーミッションとディスク容量を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

mountコマンドが失敗する場合はシステムの状態を確認する。ログファイル操作が失敗する場合は `/var/log` のディスク容量とパーミッションを確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | マウントポイント数（通常数十件以下） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 極めて低い |

## 排他制御

特別な排他制御は行わない。mountコマンドの出力はスナップショット的に取得される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 差分ログ | 変更検出時 | "{host} changes in mounted filesystems:" とdiff出力 |
| 初回ログ | 初回実行時 | "No /var/log/mount.today" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| マウント構成変更 | 差分1件以上 | daily_status_security_output（デフォルト: root） |

## 備考

- `/etc/fstab` が存在しない環境（一部のコンテナ環境等）にも対応しており、`PATH_FSTAB=/dev/null` を設定して処理を継続する
- `mount -p` はfstab互換形式で出力するため、マウントオプションの変更も検出可能
- amdマウントの除外は `security_status_noamd=YES` で有効化できる
- ソースコード: `usr.sbin/periodic/etc/security/200.chkmounts`
