# バッチ設計書 45-300.chkuid0

## 概要

本ドキュメントは、FreeBSDのperiodicセキュリティフレームワークにおけるUID 0アカウント検出バッチ `300.chkuid0` の設計仕様を記述するものである。

### 本バッチの処理概要

このバッチは、システム上のUID 0（root権限）を持つアカウントを検出し、標準アカウント（root、toor）以外のUID 0アカウントが存在する場合に警告を報告するセキュリティ監査スクリプトである。

**業務上の目的・背景**：UID 0はUNIXシステムにおける最高権限を持つスーパーユーザのUIDである。通常、UID 0を持つアカウントはrootとtoor（FreeBSD固有のrootの代替アカウント）のみであるべきである。不正にUID 0が割り当てられたアカウントの存在は、権限昇格攻撃やバックドアの設置を示す重大なセキュリティインシデントの兆候である。本バッチは定期的にこれを検査し、異常を早期に発見する。

**バッチの実行タイミング**：日次（daily security checkの一部として実行。`security_status_chkuid0_period` のデフォルトは "daily"）

**主要な処理内容**：
1. periodic.confの読み込みと有効/無効判定
2. `/etc/master.passwd` をawkで解析し、UID（第3フィールド）が0のエントリを抽出
3. 標準アカウント（root、toor）を除外した残りの件数をカウント
4. 非標準のUID 0アカウントが存在する場合、終了コード1で報告

**前後の処理との関連**：セキュリティチェックスクリプト群の一つで、200.chkmountsの後、400.passwdlessの前に実行される。独立した検査であり他のスクリプトとの依存関係はない。

**影響範囲**：`/etc/master.passwd` の読み取りのみを行い、システムの状態を変更しない。ログファイルの更新も行わない。

## バッチ種別

セキュリティ監査 / アカウント検査レポート

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次（デフォルト。weekly/monthlyに変更可能） |
| 実行時刻 | daily security checkの実行時刻に準ずる |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | cron経由 `periodic daily` -> `450.status-security` -> 本スクリプト |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| security_status_chkuid0_enable | "YES" であること（デフォルト: YES） |
| security_status_chkuid0_period | 実行周期が現在のPERIODICコンテキストと一致すること（デフォルト: daily） |
| /etc/master.passwd | ファイルが読み取り可能であること |

### 実行可否判定

`check_yesno_period security_status_chkuid0_enable` 関数により判定。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| security_status_chkuid0_enable | YES/NO | No | YES | バッチの有効/無効 |
| security_status_chkuid0_period | 文字列 | No | daily | 実行周期 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | デフォルト設定値 |
| /etc/master.passwd | コロン区切りテキスト | システムのマスターパスワードファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力/標準エラー出力 | テキスト | UID 0を持つアカウントの一覧（ユーザ名とUID） |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 標準出力のみ |
| 文字コード | システムロケール依存 |
| 区切り文字 | スペース区切り |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ periodic.confを読み込み
2. 実行可否判定
   └─ check_yesno_period security_status_chkuid0_enable
3. master.passwd解析
   └─ awkで/etc/master.passwdを解析（コメント行をスキップ）
   └─ 第3フィールド（UID）が0のエントリのユーザ名とUIDを出力
   └─ tee /dev/stderrで標準エラー出力にも出力
4. 標準アカウント除外
   └─ sedで "root 0" と "toor 0" のエントリを除外
5. 件数カウントと終了コード判定
   └─ wc -l で残りの件数をカウント
   └─ 件数 > 0 の場合 rc=1、なければ rc=0
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> D{check_yesno_period?}
    D -->|No| K[exit 0]
    D -->|Yes| E["awk: /etc/master.passwdからUID=0抽出"]
    E --> F["tee /dev/stderr: 結果を出力"]
    F --> G["sed: root/toorを除外"]
    G --> H["wc -l: 件数カウント"]
    H --> I{件数 > 0?}
    I -->|Yes| J[exit 1]
    I -->|No| K2[exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | - |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 検出報告 | root/toor以外のUID 0アカウントが検出された場合 | アカウントの正当性を確認し、不正な場合は直ちに無効化・削除する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

`/etc/master.passwd` が読み取れない場合は、ファイルのパーミッションとシステムの状態を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | master.passwdのエントリ数（通常数十件） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 極めて低い |

## 排他制御

特別な排他制御は行わない。master.passwdの読み取りはアトミックではないが、通常問題にならない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | チェック開始時 | "Checking for uids of 0:" |
| 検出結果 | アカウント検出時 | UID 0アカウントのユーザ名とUID |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 非標準UID 0アカウント検出 | 1件以上 | daily_status_security_output（デフォルト: root） |

## 備考

- FreeBSDではrootに加えてtoorアカウント（root相当の代替アカウント）がデフォルトで存在する。toorはrootのシェルを変更せずに代替シェルを使用するためのアカウントである
- awkでコメント行（#で始まる行）をスキップする処理が含まれている
- check_diff関数は使用せず、毎回全件検査の結果を直接出力する
- ソースコード: `usr.sbin/periodic/etc/security/300.chkuid0`
