# バッチ設計書 46-400.passwdless

## 概要

本ドキュメントは、FreeBSDのperiodicセキュリティフレームワークにおけるパスワード未設定アカウント検出バッチ `400.passwdless` の設計仕様を記述するものである。

### 本バッチの処理概要

このバッチは、システム上のパスワードが設定されていないアカウントを検出し報告するセキュリティ監査スクリプトである。パスワードフィールドが空のアカウントはパスワードなしでログイン可能となるため、重大なセキュリティリスクとなる。

**業務上の目的・背景**：パスワードが設定されていないアカウントは、認証なしでシステムにアクセスできる重大なセキュリティホールである。アカウント作成時の設定漏れや、意図しない変更によりパスワードが削除される可能性がある。本バッチは定期的にmaster.passwdを検査し、パスワード未設定のアカウントを検出して管理者に警告する。

**バッチの実行タイミング**：日次（daily security checkの一部として実行。`security_status_passwdless_period` のデフォルトは "daily"）

**主要な処理内容**：
1. periodic.confの読み込みと有効/無効判定
2. `/etc/master.passwd` をawkで解析
3. パスワードフィールド（第2フィールド）が空のエントリを検出
4. コメント行およびNIS/NIS+エントリ（#、+、-で始まる行）をスキップ
5. 検出件数が1件以上の場合、終了コード1で報告

**前後の処理との関連**：セキュリティチェックスクリプト群の一つで、300.chkuid0の後、410.logincheckの前に実行される。

**影響範囲**：`/etc/master.passwd` の読み取りのみを行い、システムの状態を変更しない。

## バッチ種別

セキュリティ監査 / アカウント検査レポート

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次（デフォルト。weekly/monthlyに変更可能） |
| 実行時刻 | daily security checkの実行時刻に準ずる |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | cron経由 `periodic daily` -> `450.status-security` -> 本スクリプト |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| security_status_passwdless_enable | "YES" であること（デフォルト: YES） |
| security_status_passwdless_period | 実行周期が現在のPERIODICコンテキストと一致すること（デフォルト: daily） |
| /etc/master.passwd | ファイルが読み取り可能であること |

### 実行可否判定

`check_yesno_period security_status_passwdless_enable` 関数により判定。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| security_status_passwdless_enable | YES/NO | No | YES | バッチの有効/無効 |
| security_status_passwdless_period | 文字列 | No | daily | 実行周期 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | デフォルト設定値 |
| /etc/master.passwd | コロン区切りテキスト | システムのマスターパスワードファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力/標準エラー出力 | テキスト | パスワード未設定アカウントのmaster.passwdエントリ全体 |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 標準出力のみ |
| 文字コード | システムロケール依存 |
| 区切り文字 | コロン区切り（master.passwd形式） |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ periodic.confを読み込み
2. 実行可否判定
   └─ check_yesno_period security_status_passwdless_enable
3. master.passwd解析
   └─ awkで/etc/master.passwdを解析
   └─ フィールド数が2以上（有効なエントリ）を対象
   └─ 第1フィールドが#、+、-で始まる行をスキップ
   └─ 第2フィールド（パスワード）が空のエントリを検出
   └─ tee /dev/stderrで標準エラー出力にも出力
4. 件数カウントと終了コード判定
   └─ wc -l で件数をカウント
   └─ 件数 > 0 の場合 rc=1、なければ rc=0
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> D{check_yesno_period?}
    D -->|No| K[exit 0]
    D -->|Yes| E["awk: /etc/master.passwdを解析"]
    E --> F["パスワードフィールド空のエントリ抽出"]
    F --> G["tee /dev/stderr | wc -l"]
    G --> I{検出件数 > 0?}
    I -->|Yes| J[exit 1]
    I -->|No| K2[exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | - |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 検出報告 | パスワード未設定アカウントが検出された場合 | 該当アカウントにパスワードを設定するか、不要であればアカウントをロック・削除する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

`/etc/master.passwd` が読み取れない場合は、ファイルのパーミッション（通常 0600、root:wheel）を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | master.passwdのエントリ数（通常数十件） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 極めて低い |

## 排他制御

特別な排他制御は行わない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | チェック開始時 | "Checking for passwordless accounts:" |
| 検出結果 | アカウント検出時 | master.passwdの該当エントリ全体 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| パスワード未設定アカウント検出 | 1件以上 | daily_status_security_output（デフォルト: root） |

## 備考

- awkの条件 `$1 !~ /^[#+-]/` により、コメント行とNIS/NIS+エントリを除外している
- 検出されたアカウントはmaster.passwdの行全体が出力されるため、パスワードハッシュ以外の情報も含まれる
- check_diff関数は使用せず、毎回全件検査の結果を直接出力する
- ソースコード: `usr.sbin/periodic/etc/security/400.passwdless`
