# バッチ設計書 47-410.logincheck

## 概要

本ドキュメントは、FreeBSDのperiodicセキュリティフレームワークにおけるログイン設定ファイル所有権検査バッチ `410.logincheck` の設計仕様を記述するものである。

### 本バッチの処理概要

このバッチは、`/etc/login.conf` ファイルの所有権とグループを検証し、不正な変更がないかを確認するセキュリティ監査スクリプトである。

**業務上の目的・背景**：`/etc/login.conf` はFreeBSDのログインクラス設定ファイルであり、ユーザの認証方法、リソース制限、環境変数などの重要なセキュリティポリシーを定義する。このファイルの所有権が不正に変更されると、攻撃者がログインポリシーを改竄してセキュリティ制御を迂回する可能性がある。本バッチはこのファイルが正しい所有権（スクリプト実行者、通常root）を持っていることを定期的に検証する。

**バッチの実行タイミング**：日次（daily security checkの一部として実行。`security_status_logincheck_period` のデフォルトは "daily"）

**主要な処理内容**：
1. periodic.confの読み込みと有効/無効判定
2. `/etc/login.conf` のグループ所有権検証（`-G` テスト：実効グループが所有グループと一致するか）
3. `/etc/login.conf` のユーザ所有権検証（`-O` テスト：実効ユーザが所有ユーザと一致するか）
4. 所有権が不正な場合、エラーメッセージを出力し終了コード1で報告

**前後の処理との関連**：セキュリティチェックスクリプト群の一つで、400.passwdlessの後、500.ipfwdeniedの前に実行される。

**影響範囲**：`/etc/login.conf` のメタデータ（所有権）の読み取りのみを行い、システムの状態を変更しない。

## バッチ種別

セキュリティ監査 / ファイル整合性検査レポート

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次（デフォルト。weekly/monthlyに変更可能） |
| 実行時刻 | daily security checkの実行時刻に準ずる |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | cron経由 `periodic daily` -> `450.status-security` -> 本スクリプト |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| security_status_logincheck_enable | "YES" であること（デフォルト: YES） |
| security_status_logincheck_period | 実行周期が現在のPERIODICコンテキストと一致すること（デフォルト: daily） |
| /etc/login.conf | ファイルが存在すること |

### 実行可否判定

`check_yesno_period security_status_logincheck_enable` 関数により判定。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| security_status_logincheck_enable | YES/NO | No | YES | バッチの有効/無効 |
| security_status_logincheck_period | 文字列 | No | daily | 実行周期 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | デフォルト設定値 |
| /etc/login.conf | テキスト | ログインクラス設定ファイル（メタデータのみ参照） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 所有権異常時のエラーメッセージ |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 標準出力のみ |
| 文字コード | システムロケール依存 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ periodic.confを読み込み
2. 実行可否判定
   └─ check_yesno_period security_status_logincheck_enable
3. 所有権検証
   └─ -G テスト: /etc/login.confのグループ所有権が実効グループと一致するか
   └─ -O テスト: /etc/login.confのユーザ所有権が実効ユーザと一致するか
   └─ 両方のテストに合格した場合 n=0、それ以外 n=1
4. 結果判定と出力
   └─ n > 0 の場合: "Bad ownership of /etc/login.conf" を出力、rc=1
   └─ n = 0 の場合: rc=0
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> D{check_yesno_period?}
    D -->|No| K[exit 0]
    D -->|Yes| E{"-G /etc/login.conf かつ -O /etc/login.conf?"}
    E -->|Yes| F[n=0]
    E -->|No| G["Bad ownership of /etc/login.conf"]
    G --> H[n=1]
    F --> I{n > 0?}
    H --> I
    I -->|Yes| J[exit 1]
    I -->|No| K2[exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | - |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 検出報告 | /etc/login.confの所有権が不正な場合 | chown root:wheel /etc/login.conf で正しい所有権に修正し、変更の原因を調査する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

所有権の異常が検出された場合は、不正な変更の原因を調査し、正しい所有権（通常 root:wheel）に復元する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイルの検査 |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 極めて低い |

## 排他制御

特別な排他制御は行わない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | チェック開始時 | "Checking login.conf permissions:" |
| エラーログ | 所有権異常時 | "Bad ownership of /etc/login.conf" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| login.conf所有権異常 | 検出時 | daily_status_security_output（デフォルト: root） |

## 備考

- `-G` テストは実効グループIDがファイルのグループ所有者と一致するかを検証する
- `-O` テストは実効ユーザIDがファイルのユーザ所有者と一致するかを検証する
- 本スクリプトはroot権限で実行されるため、正常時はroot:wheelの所有権が期待される
- 2006年にTom Rhodesにより追加された比較的新しいセキュリティチェック
- ソースコード: `usr.sbin/periodic/etc/security/410.logincheck`
