# バッチ設計書 49-510.ipfdenied

## 概要

本ドキュメントは、FreeBSDのperiodicセキュリティフレームワークにおけるipf拒否パケットログ確認バッチ `510.ipfdenied` の設計仕様を記述するものである。

### 本バッチの処理概要

このバッチは、ipf（IPFilter）のブロックルールに一致したパケット統計を監視し、前回実行時からの変更を検出・報告するセキュリティ監査スクリプトである。

**業務上の目的・背景**：ipf（IPFilter）はFreeBSDで利用可能なパケットフィルタリング機構の一つである。ブロックされたパケットの増加は、外部からの攻撃試行やネットワーク設定の問題を示す可能性がある。本バッチはipfのブロック統計を定期的に確認し、新たなブロックパケットが発生した場合に管理者に報告する。

**バッチの実行タイミング**：日次（daily security checkの一部として実行。`security_status_ipfdenied_period` のデフォルトは "daily"）

**主要な処理内容**：
1. periodic.confの読み込みとsecurity.functionsの読み込み
2. `ipfstat -nhio` コマンドでIPFilterの入出力統計を取得
3. "block" を含むエントリを抽出
4. `check_diff` 関数（new_onlyモード）で前回結果との差分を検出
5. 新しいブロックパケットがある場合に報告

**前後の処理との関連**：セキュリティチェックスクリプト群の一つで、500.ipfwdeniedの後、520.pfdeniedの前に実行される。ファイアウォール関連チェックの2番目のスクリプトである。

**影響範囲**：ipfの統計読み取りのみを行い、フィルタルール自体は変更しない。`/var/log/ipf.today` および `/var/log/ipf.yesterday` のログファイルを更新する。

## バッチ種別

セキュリティ監査 / ファイアウォールログレポート

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次（デフォルト。weekly/monthlyに変更可能） |
| 実行時刻 | daily security checkの実行時刻に準ずる |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | cron経由 `periodic daily` -> `450.status-security` -> 本スクリプト |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| security_status_ipfdenied_enable | "YES" であること（デフォルト: YES） |
| security_status_ipfdenied_period | 実行周期が現在のPERIODICコンテキストと一致すること（デフォルト: daily） |
| security.functions | `/etc/periodic/security/security.functions` が読み込み可能であること |
| ipfstat | ipfstatコマンドが利用可能であること |

### 実行可否判定

`check_yesno_period security_status_ipfdenied_enable` 関数により判定。さらに `ipfstat -nhio` コマンドが成功し、blockルールが存在する場合のみ差分チェックを実行する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| security_status_ipfdenied_enable | YES/NO | No | YES | バッチの有効/無効 |
| security_status_ipfdenied_period | 文字列 | No | daily | 実行周期 |
| security_status_logdir | パス | No | /var/log | ログ出力ディレクトリ |
| security_status_diff_flags | 文字列 | No | -b -U 0 | diff出力時のフラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | デフォルト設定値 |
| ipfstat -nhio 出力 | テキスト | IPFilterの入出力統計（ヒットカウント付き） |
| /var/log/ipf.today | テキスト | 前回実行時のipfブロック情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 新規ブロックパケットのdiff出力（new_onlyモード） |
| /var/log/ipf.today | テキスト | 最新のipfブロック情報 |
| /var/log/ipf.yesterday | テキスト | 前回のipfブロック情報（ローテーション） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | ipf.today / ipf.yesterday |
| 出力先 | /var/log/（security_status_logdir設定に依存） |
| 文字コード | システムロケール依存 |
| 区切り文字 | スペース区切り（ipfstat出力形式） |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ periodic.confとsecurity.functionsを読み込み
2. 実行可否判定
   └─ check_yesno_period security_status_ipfdenied_enable
3. 一時ファイル作成
   └─ mktemp -t security で一時ファイルを生成
4. ipf統計取得とフィルタリング
   └─ ipfstat -nhio でヒットカウント付きルール一覧を取得
   └─ grep block でブロックルールを抽出
   └─ 結果を一時ファイルに保存
5. 差分チェック（ブロックルールが存在する場合のみ）
   └─ check_diff new_only ipf で前回結果と比較
   └─ new_onlyモード: 新規追加分のみを表示
6. クリーンアップ
   └─ 一時ファイルを削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> B2[security.functions読み込み]
    B2 --> D{check_yesno_period?}
    D -->|No| K[exit 0]
    D -->|Yes| E["mktemp: 一時ファイル作成"]
    E --> F["ipfstat -nhio | grep block"]
    F --> G{ブロックルールあり?}
    G -->|No| H["rm 一時ファイル"]
    G -->|Yes| I["check_diff new_only ipf"]
    I --> J["rc=$?"]
    J --> H
    H --> L[exit rc]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | - |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 変更検出 | ブロックパケット統計に変更があった場合 | diff出力を確認し、攻撃の兆候や設定問題がないかを判断 |
| 3 | ファイル操作エラー | ログファイルのコピー/移動に失敗した場合 | ログディレクトリのパーミッションとディスク容量を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ipfstatコマンドが失敗する場合は、IPFilterカーネルモジュールのロード状態を確認する。IPFilterが有効でない環境ではコマンドが失敗し、差分チェック自体がスキップされる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | IPFilterルール数に依存 |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 極めて低い |

## 排他制御

特別な排他制御は行わない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 差分ログ | 変更検出時 | "{host} ipf denied packets:" と新規ブロックパケット情報 |
| 初回ログ | 初回実行時 | "No /var/log/ipf.today" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ipfブロックパケット変更 | 差分1件以上 | daily_status_security_output（デフォルト: root） |

## 備考

- `ipfstat -nhio` のオプション: `-n`（数値表示）、`-h`（ヒットカウント表示）、`-i`（入力ルール）、`-o`（出力ルール）
- 500.ipfwdeniedと同様のパターンだが、ipfw用のコマンドの代わりにipfstat用のコマンドを使用する
- IPFilterが有効でない環境では `ipfstat 2>/dev/null` が失敗し、処理が安全にスキップされる
- ソースコード: `usr.sbin/periodic/etc/security/510.ipfdenied`
