# バッチ設計書 5-140.clean-rwho

## 概要

本ドキュメントは、FreeBSD periodicフレームワークにおける日次rwhoファイルクリーンアップバッチ `140.clean-rwho` の設計を記述する。本バッチは `/var/rwho` ディレクトリ内の古いrwhoデータファイルを定期的に削除する。

### 本バッチの処理概要

本バッチは、`/var/rwho` ディレクトリ内のファイルのうち、指定日数以上更新されていないものを自動的に削除する処理を行う。

**業務上の目的・背景**：rwho(1) システムは、LAN上の各ホストのユーザログイン状況をブロードキャストで共有するための仕組みである。rwhod(8) デーモンが受信したデータは `/var/rwho` ディレクトリにファイルとして保存される。ネットワーク上のホストが停止または撤去された後も、そのホストに対応するrwhoファイルは残存し続ける。本バッチにより、古いrwhoデータファイルを自動削除し、不要データの蓄積を防止する。

**バッチの実行タイミング**：日次（daily）。FreeBSD periodicフレームワークにより実行される。

**主要な処理内容**：
1. `/etc/defaults/periodic.conf` および上書き設定ファイルの読み込み
2. `daily_clean_rwho_enable` 変数による有効/無効判定
3. `daily_clean_rwho_days` パラメータと `/var/rwho` ディレクトリの存在確認
4. `/var/rwho` 内で指定日数以上更新されていないファイルを `find` コマンドで検索・削除

**前後の処理との関連**：daily periodicのクリーンアップカテゴリ（100番台）に属する。`130.clean-msgs` に続いて実行される。

**影響範囲**：`/var/rwho` ディレクトリ内のファイルのみ。

## バッチ種別

データクレンジング（rwhoデータファイル削除）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodic(8)のcron設定に依存 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron経由でperiodic(8)から起動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| periodic.confの存在 | `/etc/defaults/periodic.conf` が読み取り可能であること |
| daily_clean_rwho_enable=YES | デフォルト有効 |
| daily_clean_rwho_days設定済 | 削除対象の経過日数が指定されていること |
| /var/rwhoの存在 | ディレクトリが存在すること |

### 実行可否判定

`daily_clean_rwho_enable` が `YES`（デフォルト有効）の場合に実行する。`daily_clean_rwho_days` が未設定の場合はrc=2。`/var/rwho` が存在しない場合もrc=2。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_clean_rwho_enable | 文字列 | Yes | YES | バッチの有効/無効フラグ |
| daily_clean_rwho_days | 数値 | Yes | 7 | 削除対象とする更新経過日数 |
| daily_clean_rwho_verbose | 文字列 | No | YES | 削除ファイルの詳細出力 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | デフォルト設定値 |
| /var/rwho | ファイルシステム | 削除対象ファイルの検索元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 削除されたファイル一覧（verbose時） |
| 終了コード | 数値 | 0:成功、1:情報あり、2:設定不備、3:実行エラー |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | 標準出力 |
| 文字コード | システムロケール依存 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ periodic.conf を source
2. 有効/無効判定
   └─ daily_clean_rwho_enable が YES かどうか判定
3. パラメータ・ディレクトリ検証
   └─ daily_clean_rwho_days が空なら rc=2
   └─ /var/rwho が存在しなければ rc=2
4. ディレクトリ移動
   └─ cd /var/rwho（失敗時 rc=3）
5. ファイル検索・削除
   └─ find . ! -name . -mtime +N -delete でファイル削除
6. 終了コード設定
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_clean_rwho_enable=YES?}
    C -->|No| Z[rc=0で終了]
    C -->|Yes| D{daily_clean_rwho_days設定済?}
    D -->|No| E[rc=2]
    D -->|Yes| F{/var/rwho存在?}
    F -->|No| G[rc=2]
    F -->|Yes| H[cd /var/rwho]
    H --> I{cd成功?}
    I -->|No| J[rc=3]
    I -->|Yes| K[find で古いファイル削除]
    K --> L[終了]
    E --> L
    G --> L
    J --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=2 | 設定不備 | daily_clean_rwho_days が未設定 | periodic.conf で値を設定する |
| rc=2 | 設定不備 | /var/rwho が存在しない | ディレクトリを作成するかrwhoを無効化する |
| rc=3 | 実行エラー | cd /var/rwho に失敗 | パーミッションを確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

リトライ機構はない。次回のdaily実行時に再度実行される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作） |
| コミットタイミング | 各ファイルの削除は即時実行 |
| ロールバック条件 | ロールバック不可 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | /var/rwho 内のファイル数（通常少数） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | findコマンドの使用量（低い） |

## 排他制御

排他制御の仕組みは実装されていない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | "Removing stale files from /var/rwho:" |
| 進捗ログ | verbose有効時 | 削除されたファイルのパス一覧 |
| 終了ログ | N/A | 明示的な終了ログなし |
| エラーログ | 設定不備時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc >= 2 | periodic(8)の出力先（デフォルト: root宛メール） |

## 備考

- デフォルトで有効（daily_clean_rwho_enable=YES）
- 削除判定はmtime（更新日時）のみ
- デフォルトの保持期間は7日
- rwho(1)/rwhod(8) はレガシーなプロトコルであり、現代のネットワーク環境ではセキュリティ上の理由から使用が推奨されない場合がある
- 構造は `120.clean-preserve` とほぼ同一で、対象ディレクトリのみが異なる
