# バッチ設計書 52-610.ipf6denied

## 概要

本ドキュメントは、FreeBSD の periodic セキュリティスクリプト `610.ipf6denied` のバッチ設計書である。IPv6 向け ipf(8) ファイアウォールの拒否パケットログを確認し、前回実行時からの変更を検出・報告する。

### 本バッチの処理概要

本バッチは、ipf(8)（IPFilter）ファイアウォールの IPv6 トラフィックに対する拒否（block）ルールの統計情報を取得し、前回実行時との差分を検出してセキュリティレポートとして管理者に通知する。

**業務上の目的・背景**：IPv6 環境におけるファイアウォールの拒否パケット状況を日次で監視することで、不正アクセスの試行やネットワーク攻撃の兆候を早期に検出する。IPv4 向けの `510.ipfdenied` の IPv6 版として、デュアルスタック環境でのセキュリティ監視を補完する。ipf(8) は FreeBSD で利用可能なパケットフィルタの一つであり、IPv6 対応の監視が求められる環境で本バッチが活用される。

**バッチの実行タイミング**：daily（日次）のセキュリティチェック（450.status-security）から呼び出される。periodic(8) フレームワークにより、`security_status_ipf6denied_period` の設定に応じて daily/weekly/monthly のいずれかで実行される。デフォルトは daily。

**主要な処理内容**：
1. `ipfstat -nhio6` コマンドで IPv6 の ipf 統計情報を取得
2. `grep block` で拒否ルールのみをフィルタリングし一時ファイルに出力
3. `check_diff new_only` 関数で前回結果（`/var/log/ipf6.today`）との差分を検出
4. 新規の拒否パケットが検出された場合、差分をレポートとして表示

**前後の処理との関連**：本バッチは `450.status-security` から呼び出される。`510.ipfdenied`（IPv4 版）と対をなし、ipf ファイアウォール監視の IPv6 部分を担当する。`security.functions` の `check_diff` 関数に依存する。

**影響範囲**：ipf(8) の統計情報を読み取り専用で参照する。`/var/log/ipf6.today` および `/var/log/ipf6.yesterday` ファイルの更新を行う（差分検出のための状態管理）。

## バッチ種別

レポート生成 / セキュリティ監査

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次（デフォルト） |
| 実行時刻 | periodic(8) の daily セキュリティチェック実行時 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron 経由の periodic(8) フレームワーク |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| periodic.conf の読み込み | `/etc/defaults/periodic.conf` が読み取り可能であること |
| security.functions | `/etc/periodic/security/security.functions` が読み込み可能であること |
| ipf カーネルモジュール | ipf(8) がカーネルに組み込まれている、またはロードされていること |
| ipfstat コマンド | `ipfstat` コマンドが利用可能であること |

### 実行可否判定

`check_yesno_period security_status_ipf6denied_enable` で有効/無効を判定（デフォルト: YES）。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| security_status_ipf6denied_enable | 文字列 | No | YES | バッチの有効/無効 |
| security_status_ipf6denied_period | 文字列 | No | daily | 実行期間（daily/weekly/monthly） |
| security_status_logdir | 文字列 | No | /var/log | ログディレクトリ |
| security_status_diff_flags | 文字列 | No | -b -U 0 | diff コマンドのフラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| `ipfstat -nhio6` 出力 | テキスト（標準出力） | IPv6 向け ipf 入出力統計情報（数値形式、ヘッダなし） |
| `/var/log/ipf6.today` | テキスト | 前回実行時の ipf6 拒否パケット情報 |
| `/etc/defaults/periodic.conf` | シェル変数定義 | periodic フレームワークの設定ファイル |
| `/etc/periodic/security/security.functions` | シェル関数定義 | check_diff 関数の定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 前回からの拒否パケット差分情報 |
| `/var/log/ipf6.today` | テキスト | 最新の ipf6 拒否パケット情報（check_diff が更新） |
| `/var/log/ipf6.yesterday` | テキスト | 前回の ipf6 拒否パケット情報（check_diff が退避） |
| 終了コード | 整数 | 0: 変化なし、1: 新規拒否パケット検出、3: ファイル操作エラー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | `ipf6.today` / `ipf6.yesterday` |
| 出力先 | `/var/log/`（`security_status_logdir` の値） |
| 文字コード | システムデフォルト |
| 区切り文字 | ipfstat 出力形式 |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイルの読み込み
   └─ /etc/defaults/periodic.conf を読み込み、source_periodic_confs で追加設定を適用
2. security.functions の読み込み
   └─ check_diff 関数等の共通関数を読み込み
3. 有効/無効判定
   └─ check_yesno_period security_status_ipf6denied_enable で実行可否を判定
4. 一時ファイル作成
   └─ mktemp で一時ファイルを作成
5. IPv6 拒否パケット情報取得
   └─ ipfstat -nhio6 で統計情報を取得し、grep block でフィルタ
6. 差分検出・報告
   └─ check_diff new_only ipf6 で前回結果との差分を検出し表示
7. クリーンアップ
   └─ 一時ファイルを削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定ファイル・共通関数読み込み]
    B --> C{security_status_ipf6denied_enable?}
    C -->|NO| Z["exit 0"]
    C -->|YES| D[一時ファイル作成]
    D --> E["ipfstat -nhio6 実行"]
    E --> F["grep block でフィルタ"]
    F --> G{block ルールあり?}
    G -->|あり| H["check_diff new_only ipf6 で差分検出"]
    G -->|なし| I[一時ファイル削除]
    H --> J{差分あり?}
    J -->|あり| K[差分を表示]
    J -->|なし| I
    K --> I
    I --> L["exit $rc"]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチではデータベース操作は行わない。ファイルベースの差分比較を行う。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 0 | 正常終了 | 変化なし、または無効設定 | 対処不要 |
| 1 | 警告 | 新規拒否パケットが検出された、または初回実行 | 管理者がレポート内容を確認 |
| 3 | エラー | ファイル操作（cp/mv）が失敗 | ファイルシステムの権限・空き容量を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

`ipfstat` コマンドが失敗した場合（ipf 未ロード等）、stderr は `/dev/null` にリダイレクトされ、grep が 0 バイト出力となるため check_diff は呼び出されずスキップされる。一時ファイルは処理終了時に `rm -f` で削除される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ipf ルール数に依存 |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小（パイプライン処理） |

## 排他制御

排他制御は実装されていない。check_diff 関数内で `ipf6.today` / `ipf6.yesterday` ファイルの mv 操作が行われるため、同一バッチの同時実行は避けるべきである。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 差分レポート | 新規拒否パケット検出時 | "{host} ipf6 denied packets:" に続き差分情報 |
| 初回実行通知 | ipf6.today が存在しない場合 | "No /var/log/ipf6.today" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 1（新規拒否パケット検出） | periodic(8) のメール通知先（daily セキュリティレポート） |

## 備考

- `ipfstat -nhio6` のオプション：`-n`（数値表示）、`-h`（ヒット数表示）、`-i`（入力ルール）、`-o`（出力ルール）、`-6`（IPv6）
- `check_diff new_only` モードでは、diff 出力から `>` または `+` で始まる行（新規追加分）のみを表示する
- IPv4 版（510.ipfdenied）とは独立して動作し、それぞれ別の状態ファイル（ipf6.today vs ipfdenied.today）を管理する
