# バッチ設計書 53-700.kernelmsg

## 概要

本ドキュメントは、FreeBSD の periodic セキュリティスクリプト `700.kernelmsg` のバッチ設計書である。カーネルメッセージ（dmesg）の変更を検出し、セキュリティ上の異常をレポートする。

### 本バッチの処理概要

本バッチは、`dmesg(8)` コマンドでカーネルメッセージバッファの内容を取得し、前回実行時からの変更を検出してセキュリティレポートとして管理者に通知する。カーネルレベルの異常（ハードウェア障害、ドライバエラー、セキュリティ関連メッセージ等）の早期発見を目的とする。

**業務上の目的・背景**：カーネルメッセージには、ハードウェアの障害兆候、メモリエラー、ディスク I/O エラー、ネットワーク異常、セキュリティ違反（不正なシステムコール等）など、システムの健全性に関する重要な情報が含まれる。本バッチは、これらのメッセージを日次で監視し、前回からの変化を管理者に通知することで、問題の早期検出と対応を支援する。

**バッチの実行タイミング**：daily（日次）のセキュリティチェック（450.status-security）から呼び出される。periodic(8) フレームワークにより、`security_status_kernelmsg_period` の設定に応じて daily/weekly/monthly のいずれかで実行される。デフォルトは daily。

**主要な処理内容**：
1. `dmesg` コマンドでカーネルメッセージバッファの内容を取得
2. `check_diff new_only dmesg` 関数でパイプ経由の入力を前回結果と比較
3. 新規メッセージが検出された場合、差分をレポートとして表示

**前後の処理との関連**：本バッチは `450.status-security` から呼び出される。セキュリティカテゴリの他のスクリプト（ファイアウォール監査、ログイン監査等）と並行して実行される。`security.functions` の `check_diff` 関数に依存する。

**影響範囲**：カーネルメッセージバッファを読み取り専用で参照する。`/var/log/dmesg.today` および `/var/log/dmesg.yesterday` ファイルの更新を行う（差分検出のための状態管理）。

## バッチ種別

レポート生成 / セキュリティ監査

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次（デフォルト） |
| 実行時刻 | periodic(8) の daily セキュリティチェック実行時 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron 経由の periodic(8) フレームワーク |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| periodic.conf の読み込み | `/etc/defaults/periodic.conf` が読み取り可能であること |
| security.functions | `/etc/periodic/security/security.functions` が読み込み可能であること |
| dmesg コマンド | `dmesg` コマンドが利用可能であること |

### 実行可否判定

`check_yesno_period security_status_kernelmsg_enable` で有効/無効を判定（デフォルト: YES）。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| security_status_kernelmsg_enable | 文字列 | No | YES | バッチの有効/無効 |
| security_status_kernelmsg_period | 文字列 | No | daily | 実行期間（daily/weekly/monthly） |
| security_status_logdir | 文字列 | No | /var/log | ログディレクトリ |
| security_status_diff_flags | 文字列 | No | -b -U 0 | diff コマンドのフラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| `dmesg` 出力 | テキスト（標準出力） | カーネルメッセージバッファの内容 |
| `/var/log/dmesg.today` | テキスト | 前回実行時のカーネルメッセージ |
| `/etc/defaults/periodic.conf` | シェル変数定義 | periodic フレームワークの設定ファイル |
| `/etc/periodic/security/security.functions` | シェル関数定義 | check_diff 関数の定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 前回からのカーネルメッセージ差分 |
| `/var/log/dmesg.today` | テキスト | 最新のカーネルメッセージ（check_diff が更新） |
| `/var/log/dmesg.yesterday` | テキスト | 前回のカーネルメッセージ（check_diff が退避） |
| 終了コード | 整数 | 0: 変化なし、1: 新規メッセージ検出、3: ファイル操作エラー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | `dmesg.today` / `dmesg.yesterday` |
| 出力先 | `/var/log/`（`security_status_logdir` の値） |
| 文字コード | システムデフォルト |
| 区切り文字 | N/A（dmesg 出力形式） |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイルの読み込み
   └─ /etc/defaults/periodic.conf を読み込み、source_periodic_confs で追加設定を適用
2. security.functions の読み込み
   └─ check_diff 関数等の共通関数を読み込み
3. 有効/無効判定
   └─ check_yesno_period security_status_kernelmsg_enable で実行可否を判定
4. カーネルメッセージ取得
   └─ dmesg コマンドでカーネルメッセージバッファを取得（stderr は /dev/null へ）
5. 差分検出・報告
   └─ check_diff new_only dmesg - で前回結果との差分を検出
   └─ "-" 指定によりパイプ入力を一時ファイル経由で処理
6. 結果出力
   └─ 新規メッセージがあれば "{host} kernel log messages:" として表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定ファイル・共通関数読み込み]
    B --> C{security_status_kernelmsg_enable?}
    C -->|NO| Z["exit 0"]
    C -->|YES| D["dmesg 実行"]
    D --> E["check_diff new_only dmesg - で差分検出"]
    E --> F{差分あり?}
    F -->|あり| G["'{host} kernel log messages:' + 差分を表示"]
    F -->|なし| H["rc=0"]
    G --> I["exit $rc"]
    H --> I
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチではデータベース操作は行わない。カーネルメッセージバッファの読み取りとファイルベースの差分比較を行う。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 0 | 正常終了 | 変化なし、または無効設定 | 対処不要 |
| 1 | 警告 | 新規カーネルメッセージが検出された、または初回実行 | 管理者がメッセージ内容を確認 |
| 3 | エラー | ファイル操作（cp/mv）が失敗 | ファイルシステムの権限・空き容量を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

`dmesg` コマンドの stderr は `/dev/null` にリダイレクトされる。dmesg 出力が空の場合、check_diff は差分なしとして処理する。ファイル操作エラー時は終了コード 3 が返される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | カーネルメッセージバッファサイズに依存（通常数百行） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小（パイプライン処理 + diff） |

## 排他制御

排他制御は実装されていない。check_diff 関数内で `dmesg.today` / `dmesg.yesterday` ファイルの mv 操作が行われるため、同一バッチの同時実行は避けるべきである。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 差分レポート | 新規メッセージ検出時 | "{host} kernel log messages:" に続き差分情報 |
| 初回実行通知 | dmesg.today が存在しない場合 | "No /var/log/dmesg.today" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 1（新規メッセージ検出） | periodic(8) のメール通知先（daily セキュリティレポート） |

## 備考

- 本バッチは非常にシンプルな構成で、dmesg 出力をパイプで check_diff に渡すのみである
- check_diff に "-" を指定することで、パイプ入力が一時ファイルに書き出されてから比較処理が行われる
- dmesg の stderr を `/dev/null` にリダイレクトしているのは、権限不足等のエラーメッセージを抑制するため
- カーネルメッセージバッファはリングバッファであるため、長時間経過するとメッセージが上書きされる可能性がある
