# バッチ設計書 6-150.clean-hoststat

## 概要

本ドキュメントは、FreeBSD periodicフレームワークにおける日次sendmailホストステータスキャッシュパージバッチ `150.clean-hoststat` の設計を記述する。本バッチはsendmailのホストステータスキャッシュを `purgestat` コマンドで削除する。

### 本バッチの処理概要

本バッチは、sendmailメール転送エージェントが保持する永続ホストステータスキャッシュ（各リモートホストへの接続結果の記録）を、`purgestat` コマンドを用いてパージする処理を行う。

**業務上の目的・背景**：sendmailは、メール配送時にリモートホストへの接続結果をホストステータスキャッシュとしてディスクに保存する。これにより、一時的に到達不能なホストへの再試行間隔を最適化できる。しかし、キャッシュが古くなると、既に回復したホストへの配送が不必要に遅延する原因となる。本バッチにより、古いステータスエントリを定期的にパージし、メール配送の効率を維持する。

**バッチの実行タイミング**：日次（daily）。FreeBSD periodicフレームワークにより実行される。

**主要な処理内容**：
1. `/etc/defaults/periodic.conf` および上書き設定ファイルの読み込み
2. `daily_clean_hoststat_enable` 変数による有効/無効判定
3. `/etc/mail/mailer.conf` に `purgestat` が定義されているか確認
4. `hoststat` コマンドで現在のキャッシュエントリが存在するか確認
5. `purgestat` コマンドでキャッシュをパージ

**前後の処理との関連**：daily periodicのクリーンアップカテゴリ（100番台）の最後の処理。`140.clean-rwho` に続いて実行される。

**影響範囲**：sendmailのホストステータスキャッシュ。メール配送の再試行タイミングに影響する可能性がある。

## バッチ種別

データクレンジング（sendmailキャッシュパージ）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodic(8)のcron設定に依存 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron経由でperiodic(8)から起動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| periodic.confの存在 | `/etc/defaults/periodic.conf` が読み取り可能であること |
| daily_clean_hoststat_enable=YES | デフォルト有効 |
| purgestatの定義 | `/etc/mail/mailer.conf` に purgestat が定義されていること |
| キャッシュエントリの存在 | hoststat の出力が空でないこと |

### 実行可否判定

`daily_clean_hoststat_enable` が `YES`（デフォルト有効）の場合に実行する。`/etc/mail/mailer.conf` に `purgestat` が定義されていない場合はrc=3で終了。`hoststat` の出力が空の場合はrc=2（キャッシュなし）で終了。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_clean_hoststat_enable | 文字列 | Yes | YES | バッチの有効/無効フラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | デフォルト設定値 |
| /etc/mail/mailer.conf | テキスト設定ファイル | メーラーコマンドマッピング |
| sendmailホストステータスキャッシュ | 内部データ | hoststatコマンドで参照 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 処理メッセージ |
| 終了コード | 数値 | 0:成功、1:purgestat失敗、2:キャッシュ空、3:purgestat未定義 |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | 標準出力 |
| 文字コード | システムロケール依存 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ periodic.conf を source
2. 有効/無効判定
   └─ daily_clean_hoststat_enable が YES かどうか判定
3. purgestat定義確認
   └─ /etc/mail/mailer.conf に purgestat が定義されているか grep で確認
   └─ 未定義なら rc=3 で終了
4. キャッシュ存在確認
   └─ hoststat コマンドの出力が空かどうか確認
   └─ 空なら rc=2 で終了
5. キャッシュパージ実行
   └─ purgestat コマンドを実行
   └─ 成功なら rc=0、失敗なら rc=1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_clean_hoststat_enable=YES?}
    C -->|No| Z[rc=0で終了]
    C -->|Yes| D{purgestat定義あり?}
    D -->|No| E[rc=3]
    D -->|Yes| F{hoststat出力あり?}
    F -->|No| G[rc=2]
    F -->|Yes| H[purgestat実行]
    H --> I{成功?}
    I -->|Yes| J[rc=0]
    I -->|No| K[rc=1]
    J --> Z2[終了]
    K --> Z2
    E --> Z2
    G --> Z2
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=3 | 環境不備 | purgestat が mailer.conf に未定義 | sendmailを使用していない環境では正常。sendmail環境では mailer.conf を確認する |
| rc=2 | 情報 | ホストステータスキャッシュが空 | パージ不要のため正常 |
| rc=1 | 実行エラー | purgestat コマンドの実行失敗 | sendmail の設定を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

リトライ機構はない。次回のdaily実行時に再度実行される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | purgestatコマンドに依存 |
| コミットタイミング | コマンド実行完了時 |
| ロールバック条件 | ロールバック不可 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ホストステータスキャッシュのエントリ数 |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | purgestatコマンドの使用量（低い） |

## 排他制御

排他制御の仕組みは本スクリプト内には実装されていない。purgestat/hoststatコマンド内部でsendmailとの排他制御が行われる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | "Removing stale entries from sendmail host status cache:" |
| 終了ログ | N/A | 明示的な終了ログなし |
| エラーログ | N/A | 明示的なエラーログなし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc >= 2 | periodic(8)の出力先（デフォルト: root宛メール） |

## 備考

- デフォルトで有効（daily_clean_hoststat_enable=YES）
- sendmailを使用していないシステム（postfix等を使用）では、`/etc/mail/mailer.conf` に purgestat が定義されていないため、rc=3 で正常にスキップされる
- 他のクリーンアップバッチとは異なり、find コマンドではなくsendmail付属の purgestat/hoststat コマンドを使用する
- verbose設定パラメータは存在しない
