# バッチ設計書 7-200.backup-passwd

## 概要

本ドキュメントは、FreeBSD periodicフレームワークにおける日次パスワード・グループファイルバックアップバッチ `200.backup-passwd` の設計を記述する。本バッチは `/etc/master.passwd` と `/etc/group` のバックアップを作成し、前回バックアップとの差分を検出・報告する。

### 本バッチの処理概要

本バッチは、システムのユーザ認証に関わる重要ファイル（master.passwd、group）を定期的にバックアップし、変更があった場合にその差分を報告する処理を行う。

**業務上の目的・背景**：`/etc/master.passwd` と `/etc/group` は、システムのユーザアカウントおよびグループ情報を格納する重要なファイルである。これらのファイルの不正変更はセキュリティインシデントにつながる可能性がある。本バッチにより、ファイルの変更を日次で検出し、管理者に通知することで、不正なアカウント追加・変更・削除を早期に検知する。また、バックアップにより障害時のリカバリも可能となる。

**バッチの実行タイミング**：日次（daily）。FreeBSD periodicフレームワークにより実行される。

**主要な処理内容**：
1. `/etc/defaults/periodic.conf` および上書き設定ファイルの読み込み
2. `daily_backup_passwd_enable` 変数による有効/無効判定
3. `/etc/master.passwd` と `/etc/group` の存在確認
4. `/var/backups/master.passwd.bak` が存在しない場合は初回バックアップを作成
5. 現在のmaster.passwdとバックアップの差分比較（パスワードフィールドはマスク）
6. 差分がある場合はバックアップをローテーション（.bak -> .bak2）して新しいバックアップを作成
7. `/var/backups/group.bak` に対しても同様の処理を実行
8. `/etc/group` の構文検証（chkgrp）

**前後の処理との関連**：daily periodicのバックアップカテゴリ（200番台）の先頭処理。クリーンアップカテゴリの後に実行される。後続の `210.backup-aliases` と同じバックアップカテゴリに属する。

**影響範囲**：`/var/backups` ディレクトリ内のバックアップファイル。元ファイル（/etc/master.passwd、/etc/group）は読み取りのみで変更しない。

## バッチ種別

データ連携（ファイルバックアップ・差分検出）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodic(8)のcron設定に依存 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron経由でperiodic(8)から起動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| periodic.confの存在 | `/etc/defaults/periodic.conf` が読み取り可能であること |
| daily_backup_passwd_enable=YES | デフォルト有効 |
| /etc/master.passwdの存在 | master.passwdファイルが存在すること |
| /etc/groupの存在 | groupファイルが存在すること |
| /var/backupsディレクトリ | バックアップ先ディレクトリが存在すること |

### 実行可否判定

`daily_backup_passwd_enable` が `YES`（デフォルト有効）の場合に実行する。`/etc/master.passwd` または `/etc/group` が存在しない場合はrc=2でエラー。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_backup_passwd_enable | 文字列 | Yes | YES | バッチの有効/無効フラグ |
| daily_diff_flags | 文字列 | No | -b -U 0 | diff コマンドのフラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | デフォルト設定値 |
| /etc/master.passwd | テキスト（passwd形式） | ユーザアカウント情報（パスワードハッシュ含む） |
| /etc/group | テキスト（group形式） | グループ情報 |
| /var/backups/master.passwd.bak | テキスト | 前回のmaster.passwdバックアップ |
| /var/backups/group.bak | テキスト | 前回のgroupバックアップ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| /var/backups/master.passwd.bak | テキスト | master.passwdの最新バックアップ |
| /var/backups/master.passwd.bak2 | テキスト | master.passwdの前回バックアップ |
| /var/backups/group.bak | テキスト | groupの最新バックアップ |
| /var/backups/group.bak2 | テキスト | groupの前回バックアップ |
| 標準出力 | テキスト | 差分情報およびchkgrp結果 |
| 終了コード | 数値 | 0:変更なし、1:変更あり、2:設定不備、3:実行エラー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | master.passwd.bak / master.passwd.bak2 / group.bak / group.bak2 |
| 出力先 | /var/backups/ |
| 文字コード | 元ファイルと同一 |
| 区切り文字 | コロン区切り（passwd/group形式） |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ periodic.conf を source
2. 有効/無効判定
   └─ daily_backup_passwd_enable が YES かどうか判定
3. ファイル存在確認
   └─ /etc/master.passwd が存在しなければ rc=2
   └─ /etc/group が存在しなければ rc=2
4. master.passwdバックアップ処理
   └─ .bak が存在しない場合は新規作成（rc=1）
   └─ cmp で .bak と現在のファイルを比較
   └─ 差分あり: diff出力（パスワードフィールドはマスク）、.bak -> .bak2 にローテーション、新規 .bak 作成
5. groupバックアップ処理
   └─ .bak が存在しない場合は新規作成
   └─ cmp で .bak と現在のファイルを比較
   └─ 差分あり: diff出力、ローテーション、新規作成
6. group構文検証
   └─ chkgrp /etc/group を実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_backup_passwd_enable=YES?}
    C -->|No| Z[rc=0で終了]
    C -->|Yes| D{master.passwd存在?}
    D -->|No| E[rc=2]
    D -->|Yes| F{group存在?}
    F -->|No| G[rc=2]
    F -->|Yes| H{master.passwd.bak存在?}
    H -->|No| I[新規バックアップ作成]
    H -->|Yes| J{差分あり?}
    J -->|Yes| K[diff出力, ローテーション, 新規バックアップ]
    J -->|No| L[スキップ]
    I --> M{group.bak存在?}
    K --> M
    L --> M
    M -->|No| N[新規バックアップ作成]
    M -->|Yes| O{差分あり?}
    O -->|Yes| P[diff出力, ローテーション, 新規バックアップ]
    O -->|No| Q[スキップ]
    N --> R[chkgrp実行]
    P --> R
    Q --> R
    R --> Z2[終了]
    E --> Z2
    G --> Z2
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=2 | 設定不備 | /etc/master.passwd が存在しない | ファイルを確認する |
| rc=2 | 設定不備 | /etc/group が存在しない | ファイルを確認する |
| rc=3 | 実行エラー | cp コマンドの失敗 | /var/backups のパーミッションを確認する |
| rc=3 | 実行エラー | chkgrp の検証失敗 | /etc/group の構文を確認する |
| rc=1 | 情報通知 | 前回との差分が検出された | 差分内容を確認し、正当な変更か判断する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

リトライ機構はない。次回のdaily実行時に再度実行される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作） |
| コミットタイミング | 各コピー操作は即時 |
| ロールバック条件 | ロールバック機構なし。ただし .bak2 に前回バックアップが保持される |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 2ファイル（master.passwd、group） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | cmp/diff/cp コマンドの使用量（低い） |

## 排他制御

排他制御の仕組みは実装されていない。passwd/groupファイルの変更中に実行された場合、不完全な状態がバックアップされる可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | "Backup passwd and group files:" |
| 差分ログ | 差分検出時 | "$host passwd diffs:" / "$host group diffs:" に続くdiff出力 |
| 検証ログ | group検証時 | "Verifying group file syntax:" に続くchkgrp出力 |
| エラーログ | 設定不備時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc=1 | periodic(8)の出力先（差分検出の通知） |
| 終了コード | rc >= 2 | periodic(8)の出力先（エラー通知） |

## 備考

- デフォルトで有効（daily_backup_passwd_enable=YES）
- セキュリティ上の配慮として、master.passwdの差分出力ではパスワードハッシュフィールドが `(password)` にマスクされる（sed による置換）
- コメント行（# で始まる行）の変更はdiff出力から除外される（`-I '^#'`）
- バックアップは2世代（.bak と .bak2）保持される
- `chkgrp` コマンドによりgroupファイルの構文検証も実施される
- `daily_diff_flags` のデフォルト値は `-b -U 0`（空白無視、unified形式、コンテキスト0行）
