# バッチ設計書 8-210.backup-aliases

## 概要

本ドキュメントは、FreeBSD periodicフレームワークにおける日次メールエイリアスバックアップバッチ `210.backup-aliases` の設計を記述する。本バッチは `/etc/mail/aliases` ファイルのバックアップを作成し、前回バックアップとの差分を検出・報告する。

### 本バッチの処理概要

本バッチは、sendmailのメールエイリアスファイルを定期的にバックアップし、変更を検出・報告する処理を行う。

**業務上の目的・背景**：`/etc/mail/aliases` はメール配送におけるエイリアス（転送先）を定義するファイルである。このファイルの不正変更はメールの誤配送やセキュリティインシデントにつながる可能性がある。本バッチにより、ファイルの変更を日次で検出し、管理者に通知することで、メール設定の不正変更を早期に検知する。

**バッチの実行タイミング**：日次（daily）。FreeBSD periodicフレームワークにより実行される。

**主要な処理内容**：
1. `/etc/defaults/periodic.conf` および上書き設定ファイルの読み込み
2. `daily_backup_aliases_enable` 変数による有効/無効判定
3. `/etc/mail/aliases` の存在確認
4. `/var/backups/aliases.bak` が存在しない場合は初回バックアップ作成
5. 現在のaliasesファイルとバックアップの差分比較
6. 差分がある場合はバックアップをローテーション（.bak -> .bak2）して新しいバックアップを作成

**前後の処理との関連**：daily periodicのバックアップカテゴリ（200番台）に属する。`200.backup-passwd` に続いて実行される。

**影響範囲**：`/var/backups` ディレクトリ内のバックアップファイル。元ファイル（/etc/mail/aliases）は読み取りのみ。

## バッチ種別

データ連携（ファイルバックアップ・差分検出）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | periodic(8)のcron設定に依存 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron経由でperiodic(8)から起動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| periodic.confの存在 | `/etc/defaults/periodic.conf` が読み取り可能であること |
| daily_backup_aliases_enable=YES | デフォルト有効 |
| /etc/mail/aliasesの存在 | aliasesファイルが存在すること |

### 実行可否判定

`daily_backup_aliases_enable` が `YES`（デフォルト有効）の場合に実行する。`/etc/mail/aliases` が存在しない場合はrc=2でエラー。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| daily_backup_aliases_enable | 文字列 | Yes | YES | バッチの有効/無効フラグ |
| daily_diff_flags | 文字列 | No | -b -U 0 | diff コマンドのフラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/defaults/periodic.conf | シェル変数定義 | デフォルト設定値 |
| /etc/mail/aliases | テキスト | メールエイリアス定義 |
| /var/backups/aliases.bak | テキスト | 前回のaliasesバックアップ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| /var/backups/aliases.bak | テキスト | aliasesの最新バックアップ |
| /var/backups/aliases.bak2 | テキスト | aliasesの前回バックアップ |
| 標準出力 | テキスト | 差分情報 |
| 終了コード | 数値 | 0:変更なし、1:変更あり、2:設定不備、3:実行エラー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | aliases.bak / aliases.bak2 |
| 出力先 | /var/backups/ |
| 文字コード | 元ファイルと同一 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 設定ファイル読み込み
   └─ periodic.conf を source
2. 有効/無効判定
   └─ daily_backup_aliases_enable が YES かどうか判定
3. ファイル存在確認
   └─ /etc/mail/aliases が存在しなければ rc=2
4. バックアップ処理
   └─ aliases.bak が存在しない場合は新規作成
   └─ cmp で .bak と現在のファイルを比較
   └─ 差分あり: diff出力、.bak -> .bak2 にローテーション、新規 .bak 作成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[periodic.conf読み込み]
    B --> C{daily_backup_aliases_enable=YES?}
    C -->|No| Z[rc=0で終了]
    C -->|Yes| D{/etc/mail/aliases存在?}
    D -->|No| E[rc=2]
    D -->|Yes| F{aliases.bak存在?}
    F -->|No| G[新規バックアップ作成]
    F -->|Yes| H{差分あり?}
    H -->|Yes| I[diff出力, ローテーション, 新規バックアップ]
    H -->|No| J[変更なし]
    G --> Z2[終了]
    I --> Z2
    J --> Z2
    E --> Z2
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| rc=2 | 設定不備 | /etc/mail/aliases が存在しない | ファイルを作成する |
| rc=3 | 実行エラー | cp/mv コマンドの失敗 | /var/backups のパーミッションを確認する |
| rc=1 | 情報通知 | 前回との差分が検出された | 差分内容を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

リトライ機構はない。次回のdaily実行時に再度実行される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作） |
| コミットタイミング | 各コピー操作は即時 |
| ロールバック条件 | ロールバック機構なし。.bak2 に前回バックアップ保持 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル（aliases） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | cmp/diff/cp コマンドの使用量（低い） |

## 排他制御

排他制御の仕組みは実装されていない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | "Backing up mail aliases:" |
| 差分ログ | 差分検出時 | "$host aliases diffs:" に続くdiff出力 |
| エラーログ | 設定不備時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | rc=1 | periodic(8)の出力先（差分検出通知） |
| 終了コード | rc >= 2 | periodic(8)の出力先（エラー通知） |

## 備考

- デフォルトで有効（daily_backup_aliases_enable=YES）
- `200.backup-passwd` と同じパターンのバックアップ・差分検出ロジック
- バックアップは2世代（.bak と .bak2）保持される
- `daily_diff_flags` のデフォルト値は `-b -U 0`
- パスワードバックアップと異なり、マスク処理は行わない
