---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：1-100.clean-disks バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足
  2. **実行時刻の具体値**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `usr.sbin/periodic/etc/daily/100.clean-disks` （バッチスクリプト本体）
- E-02: `usr.sbin/periodic/periodic.conf` （periodic設定ファイル、49-53行目: 100.clean-disks設定）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧、2行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチの目的は指定日数以上経過した不要ファイルを削除すること | E-01 (L4), E-03 | ○ |
| C-02 | デフォルトは無効（daily_clean_disks_enable=NO） | E-02 (L50) | ○ |
| C-03 | daily_clean_disks_filesのデフォルト値 | E-02 (L51) | ○ |
| C-04 | daily_clean_disks_daysのデフォルト値は3 | E-02 (L52) | ○ |
| C-05 | daily_clean_disks_verboseのデフォルト値はYES | E-02 (L53) | ○ |
| C-06 | days未設定時はrc=2でエラー | E-01 (L17-21) | ○ |
| C-07 | files未設定時はrc=2でエラー | E-01 (L22-26) | ○ |
| C-08 | findコマンドで非ローカル・読み取り専用FSを除外 | E-01 (L43-44) | ○ |
| C-09 | -atime条件で日数判定 | E-01 (L44) | ○ |
| C-10 | rm -dfで削除実行 | E-01 (L45) | ○ |
| C-11 | set -f noglob でグロブ抑制 | E-01 (L30) | ○ |
| C-12 | ファイルパターンをsedで-name引数に変換 | E-01 (L31-34) | ○ |
| C-13 | verbose時にprint付きで出力 | E-01 (L36-41) | ○ |
| C-14 | 終了コードの設定ロジック（verbose無効時rc=0等） | E-01 (L46-48) | ○ |
| C-15 | periodic.confの読み込みとsource_periodic_confs | E-01 (L9-13) | ○ |
| C-16 | case文でYES判定（大文字小文字不問） | E-01 (L16) | ○ |
| C-17 | パフォーマンス要件（数万〜数百万ファイル想定） | **根拠なし** | △ |
| C-18 | 実行時刻はデフォルト毎日深夜 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体値はソースコードや設定ファイルからは導出できない。実運用環境のファイルシステムサイズに依存するため、推定値として記載した。
  - 候補：実運用ログ / ベンチマーク結果 / システム管理者ヒアリング
- 実行時刻の具体値はperiodic(8)を呼び出すcrontabの設定に依存し、バッチスクリプト自体には記載されていない。
  - 候補：/etc/crontab / crontab設定ドキュメント / periodic(8) manページ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックはソースコードから直接確認可能
- 0: 低リスク - 設定パラメータはperiodic.confから正確に読み取り可能
- 1: 中リスク - パフォーマンス要件は推定値のためレビュー必要

## 6) レビュアーチェックリスト（最小）
- [ ] findコマンドの引数構築ロジック（sedによるパターン変換）が正確に記載されているか
- [ ] 終了コードの分岐条件がソースコードと一致しているか
- [ ] パフォーマンス要件の推定値が実運用と乖離していないか
- [ ] 実行時刻に関する記載が環境に適合しているか
