---
generated_at: 2026-02-01 12:09:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：10-222.backup-gmirror バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **gmirror(8)の業務目的説明（RAID1ミラーリング）**：根拠不足
  2. **同期中スキップの業務的意味（不安定状態の記録回避）**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/222.backup-gmirror` （バッチスクリプト本体）
- E-02: `usr.sbin/periodic/periodic.conf` （periodic設定ファイル、100-101行目: 222.backup-gmirror設定）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧、11行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチの目的はgmirror listの出力バックアップ | E-01 (L4-5), E-03 | ○ |
| C-02 | デフォルトは無効（daily_backup_gmirror_enable=NO） | E-02 (L100) | ○ |
| C-03 | daily_backup_gmirror_verboseのデフォルトはNO | E-02 (L101) | ○ |
| C-04 | gmirror statusでデバイス列挙 | E-01 (L46-47) | ○ |
| C-05 | mirror/プレフィックスを除去してデバイス名抽出 | E-01 (L47) | ○ |
| C-06 | gmirrorデバイス未検出時はrc=2 | E-01 (L49-52) | ○ |
| C-07 | gmirror status -s でCOMPLETE以外を検出 | E-01 (L60) | ○ |
| C-08 | 全コンポーネントCOMPLETE時のみgmirror listを実行 | E-01 (L60-62) | ○ |
| C-09 | rotate関数によるバックアップ管理 | E-01 (L17-37) | ○ |
| C-10 | デバイス名のtr変換 | E-01 (L59) | ○ |
| C-11 | バックアップは2世代保持（.bak, .bak2） | E-01 (L29-30) | ○ |
| C-12 | Created by Miroslav Lachman | E-01 (L2) | ○ |
| C-13 | periodic.confの読み込み | E-01 (L9-13) | ○ |
| C-14 | stderrを/dev/nullにリダイレクト | E-01 (L46) | ○ |
| C-15 | gmirror(8)はGEOMフレームワークのソフトウェアRAID1 | **根拠なし** | △ |
| C-16 | 同期中スキップは不安定状態の記録を回避する目的 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- gmirror(8)の機能説明はFreeBSD GEOMフレームワークの仕様に基づく知識であり、スクリプト内には記載されていない。
  - 候補：gmirror(8) manページ / FreeBSD Handbook / GEOM documentation
- 同期中スキップの設計意図はスクリプトの動作から推測した。コメント等での明示的な記載はない。
  - 候補：開発者コメント / コミットログ / 設計ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックはソースコードから直接確認可能
- 0: 低リスク - rotate関数のロジックも明確
- 1: 中リスク - 業務説明・設計意図は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] gmirror statusのawkパターンが正確に記載されているか
- [ ] COMPLETE判定のロジック（grep -F -v "COMPLETE"）が正確か
- [ ] rotate関数のロジックが221.backup-gpartと同等か
- [ ] 同期中スキップの条件が正確に記載されているか
