---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-223.backup-zfs

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **daily_backup_zpool_get_flagsのデフォルト値**：periodic.confに明示的な定義が確認できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `usr.sbin/periodic/etc/daily/223.backup-zfs`（ソースコード）
- E-02: `usr.sbin/periodic/periodic.conf`（デフォルト設定ファイル）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト無効（daily_backup_zfs_enable=NO） | E-02 L104 | ○ |
| C-02 | zpool listでプール一覧を取得しローテーション保存する | E-01 L49,58-59 | ○ |
| C-03 | zfs listでファイルシステム一覧を取得しローテーション保存する | E-01 L61-62 | ○ |
| C-04 | daily_backup_zfs_props_enable=YES時にプロパティをバックアップ | E-01 L67-76, E-02 L105 | ○ |
| C-05 | verbose時に差分を出力する | E-01 L27-30, L42-44 | ○ |
| C-06 | rotate関数で2世代管理を行う | E-01 L18-39 | ○ |
| C-07 | 出力先は/var/backups/ | E-01 L15 | ○ |
| C-08 | zpoolが存在しない場合rc=2 | E-01 L51-53 | ○ |
| C-09 | ファイル操作失敗時rc=3 | E-01 L31-32,36 | ○ |
| C-10 | 差異検出時またはinitial時rc=1 | E-01 L28-29, L35 | ○ |
| C-11 | daily_diff_flagsのデフォルトは"-b -U 0" | E-02 L43 | ○ |
| C-12 | daily_backup_zfs_get_flagsのデフォルトは"all" | E-02 L106 | ○ |
| C-13 | daily_backup_zfs_list_flagsのデフォルトは空 | E-02 L107 | ○ |
| C-14 | daily_backup_zfs_verbose=NOがデフォルト | E-02 L110 | ○ |
| C-15 | 作成者はMiroslav Lachman | E-01 L2 | ○ |
| C-16 | periodic.confとsource_periodic_confsで設定を読み込む | E-01 L9-13 | ○ |
| C-17 | daily_backup_zpool_get_flagsのデフォルト値が明示されていない | E-02 | △ |
| C-18 | 実行時刻はperiodicデフォルト3:01 | E-02（periodicフレームワーク仕様） | ○ |

## 4) 不足情報（Unknown / Missing）
- daily_backup_zpool_get_flagsのデフォルト値がperiodic.confに明示されていない
  - 候補：periodic.confの全体確認 / zpool getのmanページ / FreeBSDハンドブック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードと設定ファイルから直接根拠を確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] daily_backup_zpool_get_flagsの実際のデフォルト動作を確認
- [ ] rotate関数の2世代管理動作が正しく記述されているか確認
- [ ] パフォーマンス要件が環境に適合するか確認
