---
generated_at: 2026-02-01 10:01:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-300.calendar

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. なし - 全主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/300.calendar`（ソースコード）
- E-02: `usr.sbin/periodic/periodic.conf`（デフォルト設定ファイル）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト無効（daily_calendar_enable=NO） | E-02 L113 | ○ |
| C-02 | calendar -aコマンドを実行する | E-01 L23 | ○ |
| C-03 | 成功時rc=0、失敗時rc=3 | E-01 L23 | ○ |
| C-04 | 無効時はrc=0でスキップ | E-01 L25 | ○ |
| C-05 | "Running calendar:"メッセージを出力 | E-01 L21 | ○ |
| C-06 | periodic.confを読み込む | E-01 L12-16 | ○ |
| C-07 | コメントにcalendar -aの問題指摘あり | E-01 L4-8 | ○ |
| C-08 | ネットワークホームディレクトリの問題 | E-01 L5 | ○ |
| C-09 | cronジョブ等の代替手段が推奨されている | E-01 L6-7 | ○ |
| C-10 | データベース操作を行わない | E-01（全体） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。シンプルなバッチであり、ソースコードから全主張の根拠を確認できる。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 非常にシンプルなスクリプトであり、ソースコードとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] calendar -aの-aオプションの動作仕様を確認（全ユーザ対象）
- [ ] ネットワークホームディレクトリ環境での影響を確認
