---
generated_at: 2026-02-01 10:02:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-310.accounting

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - 全主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/310.accounting`（ソースコード）
- E-02: `usr.sbin/periodic/periodic.conf`（デフォルト設定ファイル）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト有効（daily_accounting_enable=YES） | E-02 L116 | ○ |
| C-02 | /var/account/acctの存在を確認 | E-01 L15-19 | ○ |
| C-03 | kern.acct_configuredで有効性確認 | E-01 L20-23 | ○ |
| C-04 | daily_accounting_saveの設定確認 | E-01 L25-29 | ○ |
| C-05 | daily_accounting_saveのデフォルト値は3 | E-02 L119 | ○ |
| C-06 | 古いログの削除処理（世代超過分） | E-01 L37-42 | ○ |
| C-07 | ログファイルの世代繰り上げリネーム | E-01 L44-52 | ○ |
| C-08 | /etc/rc.d/accounting onerotate_logの実行 | E-01 L54 | ○ |
| C-09 | acct.mergeの作成とsa -s実行 | E-01 L56-57 | ○ |
| C-10 | acct.mergeの削除 | E-01 L58 | ○ |
| C-11 | daily_accounting_compress=YES時にgzip圧縮 | E-01 L60-63 | ○ |
| C-12 | daily_accounting_compressのデフォルトはNO | E-02 L117 | ○ |
| C-13 | daily_accounting_flagsのデフォルトは-q | E-02 L118 | ○ |
| C-14 | 処理エラー時rc=3を設定して処理続行 | E-01 L41,48-49,54,56-57,62 | ○ |
| C-15 | 前提条件不足時rc=2 | E-01 L19,23,29 | ○ |
| C-16 | 無効時rc=0でスキップ | E-01 L66 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ソースコードと設定ファイルから全主張の根拠を確認できる。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性が高く、全主張に根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] /etc/rc.d/accounting onerotate_logの動作仕様を確認
- [ ] sa(8)コマンドの-sフラグによるsavacct/usracct出力を確認
- [ ] gzip圧縮ファイル(.gz)のローテーション処理が正しいか確認
