---
generated_at: 2026-02-01 10:03:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-400.status-disks

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - 全主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/400.status-disks`（ソースコード）
- E-02: `usr.sbin/periodic/periodic.conf`（デフォルト設定ファイル）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト有効（daily_status_disks_enable=YES） | E-02 L122 | ○ |
| C-02 | dfコマンドでディスク使用状況を確認 | E-01 L23 | ○ |
| C-03 | daily_status_disks_df_flagsのデフォルトは"-l -h" | E-02 L123 | ○ |
| C-04 | daily_status_disks_ignoreによるegrepフィルタ | E-01 L18-22 | ○ |
| C-05 | /etc/dumpdates存在時にdump Wを実行 | E-01 L26-33 | ○ |
| C-06 | /etc/fstab不在時にPATH_FSTAB=/dev/null設定 | E-01 L27-29 | ○ |
| C-07 | df成功時rc=1、失敗時rc=3 | E-01 L23 | ○ |
| C-08 | "Disk status:"メッセージ出力 | E-01 L16 | ○ |
| C-09 | 無効時rc=0でスキップ | E-01 L36 | ○ |
| C-10 | periodic.confを読み込む | E-01 L7-11 | ○ |
| C-11 | 読み取り専用の処理 | E-01（全体、ファイル書き込みなし） | ○ |
| C-12 | dump W失敗時rc=3 | E-01 L32 | ○ |
| C-13 | ignore未設定時はcatで全行出力 | E-01 L21 | ○ |
| C-14 | dumpdatesファイルのサイズ確認（-s） | E-01 L26 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用のシンプルなステータス確認バッチ

## 6) レビュアーチェックリスト（最小）
- [ ] daily_status_disks_ignoreパターンの動作確認
- [ ] PATH_FSTAB=/dev/null設定がdump Wに正しく影響するか確認
