---
generated_at: 2026-02-01 12:01:00
metrics:
  claims_total: 17
  claims_with_evidence: 15
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：2-110.clean-tmps バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：15 / 17、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足
  2. **実行時刻の具体値**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/110.clean-tmps` （バッチスクリプト本体）
- E-02: `usr.sbin/periodic/periodic.conf` （periodic設定ファイル、55-63行目: 110.clean-tmps設定）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` （バッチ一覧、3行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチの目的は一時ディレクトリの古いファイル削除 | E-01 (L4-6), E-03 | ○ |
| C-02 | デフォルトは無効（daily_clean_tmps_enable=NO） | E-02 (L56) | ○ |
| C-03 | デフォルト対象ディレクトリは/tmp | E-02 (L57) | ○ |
| C-04 | デフォルト日数は3 | E-02 (L58) | ○ |
| C-05 | 除外パターンのデフォルト値（X11ソケット等） | E-02 (L59-62) | ○ |
| C-06 | atime/mtime/ctimeの3条件で判定 | E-01 (L28-29) | ○ |
| C-07 | 空ディレクトリはmtimeのみで判定 | E-01 (L30) | ○ |
| C-08 | days未設定時はrc=2 | E-01 (L18-22) | ○ |
| C-09 | ディレクトリが絶対パスかつ存在する場合のみ処理 | E-01 (L46) | ○ |
| C-10 | find -x でマウントポイント超え防止 | E-01 (L47-48) | ○ |
| C-11 | find -d で深さ優先処理 | E-01 (L47-48) | ○ |
| C-12 | ignoreパターンをsedで ! -name引数に変換 | E-01 (L32-36) | ○ |
| C-13 | verbose時にprint付きで出力 | E-01 (L37-42) | ○ |
| C-14 | 出力パスの変換（./をディレクトリ名に） | E-01 (L49) | ○ |
| C-15 | periodic.confの読み込みとsource_periodic_confs | E-01 (L10-14) | ○ |
| C-16 | パフォーマンス（通常数秒〜数分） | **根拠なし** | △ |
| C-17 | 実行時刻はデフォルト毎日深夜 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件は実運用環境の一時ディレクトリのファイル数に依存し、ソースコードからは導出できない。
  - 候補：実運用ログ / ベンチマーク結果
- 実行時刻はcrontab設定に依存する。
  - 候補：/etc/crontab / periodic(8) manページ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックはソースコードから直接確認可能
- 0: 低リスク - 設定パラメータはperiodic.confから正確に読み取り可能
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] atime/mtime/ctimeの3条件判定ロジックが正確に記載されているか
- [ ] 除外パターンのデフォルト値がperiodic.confと一致しているか
- [ ] find -x -d のオプション説明が正確か
- [ ] ignoreパターンのsed変換ロジックが正確か
