---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：21-410.status-mfi.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **daily実行時刻のデフォルト値**：crontab設定に依存し、ソースコードからは直接確認不可

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/periodic/etc/daily/410.status-mfi`（バッチスクリプト本体）
- E-02: `usr.sbin/periodic/periodic.conf`（デフォルト設定ファイル）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | daily_status_mfi_enableのデフォルトはNO | E-02 (L145) | ○ |
| C-02 | mfiutil show volumesコマンドでボリューム状態を取得 | E-01 (L18) | ○ |
| C-03 | DEGRADED文字列をgrep -qで検索 | E-01 (L19) | ○ |
| C-04 | DEGRADED検出時rc=3 | E-01 (L20) | ○ |
| C-05 | コマンド失敗時rc=2 | E-01 (L25) | ○ |
| C-06 | 正常時rc=0 | E-01 (L22, L29) | ○ |
| C-07 | periodic.confを読み込む | E-01 (L7-L11) | ○ |
| C-08 | YES/NO判定は大文字小文字不問 | E-01 (L14) | ○ |
| C-09 | 標準出力にボリューム情報を出力 | E-01 (L16-L18) | ○ |
| C-10 | ヘッダ "Checking status of mfi(4) devices:" を出力 | E-01 (L17) | ○ |
| C-11 | daily_outputのデフォルトはroot | E-02 (L44) | ○ |
| C-12 | 読み取り専用処理でデータ変更なし | E-01 (全体) | ○ |
| C-13 | バッチ一覧でカテゴリはdaily/ステータス確認 | E-03 (L22) | ○ |
| C-14 | mfi(4)ドライバ対応RAIDコントローラが対象 | E-01 (L17) | ○ |
| C-15 | daily実行時刻のデフォルトは3:01 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- daily実行時刻はcrontab(5)の設定に依存しており、periodic.confやスクリプト内には定義されていない
  - 候補：/etc/crontab / crontab(5)マニュアル / FreeBSDデフォルトcrontab

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 実行時刻の記載は慣例的なデフォルト値であり、実質的な影響は小さい

## 6) レビュアーチェックリスト（最小）
- [ ] mfiutil show volumesの出力フォーマットが実環境と一致するか確認
- [ ] DEGRADED以外の異常状態（OFFLINE等）の検出漏れがないか確認
- [ ] 実行時刻のデフォルト値が実環境のcrontab設定と一致するか確認
